/*
 * Decompiled with CFR 0.152.
 */
package me.kokko.tradingcards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import me.kokko.tradingcards.Artifakt;
import me.kokko.tradingcards.ConfigManager;
import me.kokko.tradingcards.Komponent;
import me.kokko.tradingcards.PluginTradingCards;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class TradingCardStack
extends Artifakt {
    private static final Map<String, ItemStack> cardCache = new HashMap<String, ItemStack>();
    private static final Map<String, ConfigurationSection> namespaceCache = new HashMap<String, ConfigurationSection>();
    private static ConfigurationSection cardData;
    private static ConfigurationSection namespaceSettings;
    private static ConfigurationSection listsData;
    private String identifier;
    private boolean glinted;
    private String key;

    public TradingCardStack(Material material) {
        super(material);
    }

    public static TradingCardStack init(Material material) {
        return new TradingCardStack(material);
    }

    public TradingCardStack create(String id, boolean glint) {
        this.loadCardSettings(id);
        this.glinted = glint;
        this.setCacheKey();
        return this;
    }

    public TradingCardStack generate(String id, Random random) {
        this.loadCardSettings(id);
        this.glinted = TradingCardStack.rollGlint(random);
        this.setCacheKey();
        return this;
    }

    private void loadCardSettings(String id) {
        this.loadCardIdentifier(id);
        this.loadNamespace(cardData.getString("namespace", "default"));
    }

    @Override
    public ItemStack build() {
        if (cardCache.containsKey(this.key) && ConfigManager.hasFeature("cards-cache")) {
            return cardCache.get(this.key);
        }
        this.generateCardMeta();
        this.generateCardName();
        this.generateCardLore();
        this.meta.lore(this.lore);
        this.item.setItemMeta(this.meta);
        cardCache.put(this.key, this.item.clone());
        return this.item;
    }

    private void loadCardIdentifier(String name) {
        this.identifier = name;
        if (cardCache.containsKey(name)) {
            return;
        }
        cardData = ConfigManager.getConfig("cards").getConfigurationSection("card." + name);
        listsData = ConfigManager.getConfig("lists").getConfigurationSection("rarity");
    }

    private void loadNamespace(String namespace) {
        if (namespaceCache.containsKey(namespace)) {
            namespaceSettings = namespaceCache.get(namespace);
            return;
        }
        namespaceSettings = ConfigManager.getConfig("games").getConfigurationSection("game." + namespace);
        ConfigurationSection defaultSettings = ConfigManager.getConfig("games").getConfigurationSection("games.default");
        namespaceSettings = namespaceSettings == null ? defaultSettings : TradingCardStack.mergeConfigurationSections(defaultSettings, namespaceSettings);
        namespaceCache.put(namespace, namespaceSettings);
    }

    private void setCacheKey() {
        this.key = String.join((CharSequence)".", this.identifier, Boolean.toString(this.glinted));
    }

    private static boolean rollGlint(Random random) {
        int namespaceChance = namespaceSettings.getInt("glint.chance", 100);
        int chance = cardData.getInt("override-glint-chance-to", namespaceChance);
        if (chance <= 0) {
            return false;
        }
        PluginTradingCards.info(3, "<TradingCardStack> (rollGlint) chance: " + chance);
        return random.nextInt(chance) == 0;
    }

    public void generateCardMeta() {
        this.metaKey((Plugin)PluginTradingCards.getInstance(), "card-id", this.identifier);
        if (cardData.contains("custom-model-data")) {
            this.customModelData(cardData.getInt("custom-model-data"));
        }
        boolean globalGlint = namespaceSettings.getBoolean("glint.enabled", true);
        boolean localGlint = cardData.getBoolean("has-glint-variant", true);
        this.glint(globalGlint && localGlint && this.glinted);
    }

    public void generateCardName() {
        Component gameName = Komponent.assemble(TradingCardStack.getStylesheet(namespaceSettings, "game-name")).build(true);
        Component glintName = Komponent.assemble(TradingCardStack.getStylesheet(namespaceSettings, "glint")).build(this.glinted);
        Komponent cardNameRaw = Komponent.text(cardData.getString("card-name", "card-name"));
        if (cardData.getBoolean("override-color-as-rarity-to", namespaceSettings.getBoolean("card-name.color-as-rarity", true))) {
            cardNameRaw = cardNameRaw.format(TradingCardStack.getStylesheet(listsData, cardData.getString("rarity", "common")));
        }
        Component cardName = cardNameRaw.compose(TradingCardStack.getStylesheet(namespaceSettings, "card-name")).build(true);
        List<Component> components = Arrays.asList(gameName, glintName, cardName);
        List<Integer> componentsIndexes = Arrays.asList(namespaceSettings.getInt("game-name.order", 1), namespaceSettings.getInt("glint.order", 2), namespaceSettings.getInt("card-name.order", 3));
        Integer[] indices = new Integer[]{0, 1, 2};
        Arrays.sort(indices, Comparator.comparingInt(componentsIndexes::get));
        Component name = Component.empty();
        Integer[] integerArray = indices;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = integerArray[i];
            name = name.append(components.get(i2));
        }
        this.name(name);
    }

    public void generateCardLore() {
        ArrayList<Component> lore = new ArrayList<Component>();
        String cardType = cardData.getString("type", "default");
        ConfigurationSection cardTemplate = namespaceSettings.getConfigurationSection("templates." + cardType);
        if (cardTemplate == null) {
            cardTemplate = namespaceSettings.getConfigurationSection("templates.default");
        }
        if (cardTemplate == null) {
            return;
        }
        for (String section : cardTemplate.getKeys(false)) {
            List<Component> loreSection;
            String type = cardTemplate.getString(section);
            if (type == null || (loreSection = TradingCardStack.generateSection(type, section)) == null || loreSection.isEmpty() || loreSection.getFirst().equals(Component.empty())) continue;
            lore.addAll(loreSection);
        }
        this.lore(lore);
    }

    private static List<Component> generateSection(String type, String section) {
        return switch (type) {
            case "space" -> List.of(Component.empty());
            case "category" -> List.of(TradingCardStack.sectionCategory(section));
            case "tags" -> List.of(TradingCardStack.sectionTags(section));
            case "collection" -> TradingCardStack.sectionCollection(section);
            case "text" -> TradingCardStack.sectionText(section);
            case "sequence" -> List.of(TradingCardStack.sectionSequence(section));
            case "rarity" -> List.of(TradingCardStack.sectionRarity());
            default -> null;
        };
    }

    private static Component sectionCategory(String selector) {
        String category = cardData.getString(selector);
        if (category == null) {
            return Component.empty();
        }
        Component label = Komponent.assemble(TradingCardStack.getStylesheet(namespaceSettings, selector)).build(true);
        Component text = Komponent.assemble(TradingCardStack.getStylesheet(namespaceSettings, selector + ".map." + category)).build(true);
        return label.append(text);
    }

    private static Component sectionTags(String selector) {
        List tags = cardData.getStringList(selector);
        if (tags.isEmpty()) {
            return Component.empty();
        }
        PluginTradingCards.info(3, "<TradingCardStack> (sectionTags) tags: " + String.valueOf(tags));
        ConfigurationSection delimiters = namespaceSettings.getConfigurationSection(selector + ".delimiter");
        if (delimiters == null) {
            delimiters = new MemoryConfiguration();
        }
        Component label = Komponent.assemble(TradingCardStack.getStylesheet(namespaceSettings, selector)).build(true);
        Component start = Komponent.text(delimiters.getString("start", "")).compose(delimiters).build(true);
        Component separator = Komponent.text(delimiters.getString("separator", " ")).compose(delimiters).build(true);
        Component closer = Komponent.text(delimiters.getString("close", "")).compose(delimiters).build(true);
        Component chain = Component.empty().append(start);
        for (int i = 0; i < tags.size(); ++i) {
            String tag = (String)tags.get(i);
            Component element = Komponent.text(tag).build(true);
            ConfigurationSection stylesheet = TradingCardStack.getStylesheet(namespaceSettings, selector + ".map." + tag);
            if (stylesheet != null) {
                element = Komponent.assemble(stylesheet).build(true);
            }
            chain = chain.append(element);
            if (i >= tags.size() - 1) continue;
            chain = chain.append(separator);
        }
        chain = chain.append(closer);
        return label.append(chain);
    }

    private static List<Component> sectionCollection(String selector) {
        ConfigurationSection collectionData = cardData.getConfigurationSection(selector);
        if (collectionData == null) {
            return null;
        }
        ArrayList<Component> collection = new ArrayList<Component>();
        Komponent label = Komponent.assemble(TradingCardStack.getStylesheet(namespaceSettings, selector));
        if (!label.hideLabel) {
            collection.add(label.build(true));
        }
        ConfigurationSection extraStylesheet = TradingCardStack.getStylesheet(namespaceSettings, selector + ".extra");
        Component prefix = Komponent.text(namespaceSettings.getString(selector + ".bullets", "")).compose(extraStylesheet).build(true);
        Component separator = Komponent.text(namespaceSettings.getString(selector + ".separator", " ")).compose(extraStylesheet).build(true);
        for (String key : collectionData.getKeys(false)) {
            String value = collectionData.getString(key, key);
            PluginTradingCards.info(3, "<TradingCardStack> (sectionCollection) key: " + key);
            PluginTradingCards.info(3, "<TradingCardStack> (sectionCollection) value: " + value);
            collection.add(prefix.append(Komponent.assemble(TradingCardStack.getStylesheet(namespaceSettings, selector + ".map." + key)).build(true)).append(separator).append(Komponent.text(value).compose(extraStylesheet).build(true)));
        }
        return collection;
    }

    private static List<Component> sectionText(String selector) {
        List<String> stringList = cardData.getStringList(selector);
        if (stringList.isEmpty()) {
            return null;
        }
        ArrayList<Component> text = new ArrayList<Component>();
        Component label = Komponent.assemble(TradingCardStack.getStylesheet(namespaceSettings, selector)).build(true);
        if (!label.equals(Component.empty())) {
            text.add(label);
        }
        PluginTradingCards.info(3, "<TradingCardStack> (sectionText) label: " + String.valueOf(label));
        String indentationString = " ".repeat(namespaceSettings.getInt(selector + ".indentation", 2));
        TextComponent indentation = Component.text(indentationString);
        stringList = TradingCardStack.wrapList(stringList, namespaceSettings.getInt(selector + ".max-length", 24));
        PluginTradingCards.info(3, "<TradingCardStack> (sectionText) stringList: " + String.valueOf(stringList));
        for (String string : stringList) {
            PluginTradingCards.info(3, "<TradingCardStack> (sectionText) string: " + string);
            text.add(indentation.append(Komponent.text(string).compose(TradingCardStack.getStylesheet(namespaceSettings, selector + ".extra")).build(true)));
        }
        return text;
    }

    private static Component sectionSequence(String selector) {
        ConfigurationSection levelData = cardData.getConfigurationSection(selector);
        if (levelData == null) {
            return Component.empty();
        }
        String sequenceMode = namespaceSettings.getString(selector + ".mode", "number");
        String sequenceSeparator = namespaceSettings.getString(selector + ".separator", "/");
        Component sequenceLabel = Komponent.assemble(TradingCardStack.getStylesheet(namespaceSettings, selector)).build(true);
        int sequenceMinValue = levelData.getInt("min-value", 0);
        int sequenceMaxValue = levelData.getInt("max-value", 0);
        String sequenceMinSymbol = levelData.getString("min-symbol", "");
        String sequenceMaxSymbol = levelData.getString("max-symbol", "");
        String sequenceText = switch (sequenceMode) {
            case "symbol-sub" -> sequenceMinSymbol.repeat(sequenceMinValue) + sequenceMaxSymbol.repeat(Math.max(sequenceMaxValue - sequenceMinValue, 0));
            case "symbol-add" -> sequenceMinSymbol.repeat(sequenceMinValue) + sequenceMaxSymbol.repeat(sequenceMaxValue);
            case "differential" -> sequenceMinValue + sequenceMinSymbol + sequenceSeparator + sequenceMaxValue + sequenceMaxSymbol;
            case "number" -> sequenceMinValue + sequenceSeparator + sequenceMaxValue;
            default -> String.valueOf(sequenceMinValue);
        };
        return sequenceLabel.append(Komponent.text(sequenceText).compose(TradingCardStack.getStylesheet(namespaceSettings, selector + ".extra")).build(true));
    }

    private static Component sectionRarity() {
        return Komponent.empty().format(TradingCardStack.getStylesheet(listsData, cardData.getString("rarity", "common"))).compose(TradingCardStack.getStylesheet(namespaceSettings, "rarity")).build(true);
    }

    private static List<String> wrap(String text, int maxLength) {
        if (text == null || text.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> wrappedText = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        for (String word : text.split(" ")) {
            if (!currentLine.isEmpty() && currentLine.length() + word.length() + 1 > maxLength) {
                wrappedText.add(currentLine.toString());
                currentLine.setLength(0);
            }
            if (!currentLine.isEmpty()) {
                currentLine.append(" ");
            }
            currentLine.append(word);
        }
        if (!currentLine.isEmpty()) {
            wrappedText.add(currentLine.toString());
        }
        return wrappedText;
    }

    private static List<String> wrapList(List<String> textList, int textLimit) {
        if (textList == null || textList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> wrappedText = new ArrayList<String>();
        for (String text : textList) {
            wrappedText.addAll(TradingCardStack.wrap(text, textLimit));
        }
        return wrappedText;
    }

    private static ConfigurationSection mergeConfigurationSections(ConfigurationSection merge, ConfigurationSection source) {
        if (source == null) {
            return merge;
        }
        if (merge == null) {
            return source;
        }
        MemoryConfiguration merged = new MemoryConfiguration();
        for (String key : merge.getKeys(false)) {
            merged.set(key, merge.get(key));
        }
        for (String key : source.getKeys(false)) {
            Object mergeValue = source.get(key);
            Object targetValue = merge.get(key);
            if (mergeValue instanceof ConfigurationSection) {
                ConfigurationSection sourceSection = (ConfigurationSection)mergeValue;
                if (targetValue instanceof ConfigurationSection) {
                    ConfigurationSection targetSection = (ConfigurationSection)targetValue;
                    merged.set(key, (Object)TradingCardStack.mergeConfigurationSections(targetSection, sourceSection));
                    continue;
                }
            }
            merged.set(key, mergeValue);
        }
        return merged;
    }

    private static ConfigurationSection getStylesheet(ConfigurationSection config, String selector) {
        return config.getConfigurationSection(selector);
    }
}

