/*
 * Decompiled with CFR 0.152.
 */
package de.darksmp;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.player.KickedFromServerEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import de.darksmp.FallbackRouterConfig;
import de.darksmp.LanguageFileExporter;
import de.darksmp.Messages;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import net.kyori.adventure.text.Component;
import org.slf4j.Logger;

@Plugin(id="fallbackrouter", name="FallbackRouter", version="1.5")
public class FallbackRouter {
    private final ProxyServer server;
    private final Messages messages;
    private final Logger logger;
    private final Map<String, List<String>> fallbackMap;

    @Inject
    public FallbackRouter(ProxyServer server, @DataDirectory Path dataDirectory, Logger logger) throws Exception {
        this.server = server;
        this.logger = logger;
        new LanguageFileExporter(dataDirectory).exportIfMissing();
        this.fallbackMap = FallbackRouterConfig.load(dataDirectory);
        this.messages = new Messages(FallbackRouterConfig.language);
        logger.info("[FallbackRouter] Loaded with language: " + FallbackRouterConfig.language);
    }

    @Subscribe
    public void onKickedFromServer(KickedFromServerEvent event) {
        String reason = event.getServerKickReason().toString().toLowerCase();
        if (!(reason.contains("server closed") || reason.contains("disconnected") || reason.contains("timed out"))) {
            return;
        }
        this.tryFallback(event.getPlayer(), event.getServer().getServerInfo().getName());
    }

    private void tryFallback(Player player, String fromServer) {
        if (!player.isActive()) {
            return;
        }
        List fallbackTargets = this.fallbackMap.getOrDefault(fromServer, List.of());
        this.server.getScheduler().buildTask((Object)this, () -> this.attemptConnection(player, fallbackTargets.iterator())).delay(2L, TimeUnit.SECONDS).schedule();
    }

    private void attemptConnection(Player player, Iterator<String> targets) {
        if (!targets.hasNext()) {
            player.disconnect((Component)Component.text((String)this.messages.get("fallback.all_offline", Map.of())));
            return;
        }
        String targetName = targets.next();
        this.server.getServer(targetName).ifPresentOrElse(server -> server.ping().whenComplete((ping, error) -> {
            if (error != null) {
                this.attemptConnection(player, targets);
            } else if (player.isActive()) {
                player.createConnectionRequest(server).connect().whenComplete((result, err) -> {
                    if (!result.isSuccessful()) {
                        this.attemptConnection(player, targets);
                    } else {
                        this.logger.info("[FallbackRouter] " + player.getUsername() + " -> " + targetName);
                    }
                });
            }
        }), () -> this.attemptConnection(player, targets));
    }
}

