/*
 * Decompiled with CFR 0.152.
 */
package de.darksmp;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class FallbackRouterConfig {
    public static String language = "en";

    public static Map<String, List<String>> load(Path dataDirectory) throws Exception {
        Path configPath = dataDirectory.resolve("config.yml");
        if (!Files.exists(configPath, new LinkOption[0])) {
            Files.createDirectories(dataDirectory, new FileAttribute[0]);
            Files.writeString(configPath, (CharSequence)"language: \"en\"\n\nfallbacks:\n  smp:\n    - smpfb\n    - lobby\n  prac:\n    - pracfb\n    - lobby", new OpenOption[0]);
        }
        try (InputStream in = Files.newInputStream(configPath, new OpenOption[0]);){
            Yaml yaml = new Yaml();
            Object configObj = yaml.load(in);
            if (configObj instanceof Map) {
                Object fallbacksObj;
                Map config = (Map)configObj;
                Object v = config.get("language");
                if (v instanceof String) {
                    String langCode;
                    language = langCode = (String)v;
                }
                if ((fallbacksObj = config.get("fallbacks")) instanceof Map) {
                    Map typedFallbacks = (Map)fallbacksObj;
                    HashMap<String, List<String>> fallbackMap = new HashMap<String, List<String>>();
                    for (Map.Entry entry : typedFallbacks.entrySet()) {
                        Object v2;
                        if (!(entry.getKey() instanceof String) || !((v2 = entry.getValue()) instanceof List)) continue;
                        List list = (List)v2;
                        List<String> servers = list.stream().filter(e -> e instanceof String).map(e -> (String)e).toList();
                        fallbackMap.put((String)entry.getKey(), servers);
                    }
                    HashMap<String, List<String>> hashMap = fallbackMap;
                    return hashMap;
                }
                throw new IllegalArgumentException("Invalid structure for 'fallbacks' in config.yml");
            }
            throw new IllegalArgumentException("Invalid YAML format in config.yml");
        }
    }
}

