/*
 * Decompiled with CFR 0.152.
 */
package de.darksmp;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public class LanguageFileExporter {
    private final Path langFolder;
    private final List<String> languageFiles = List.of("en.yml", "de.yml");

    public LanguageFileExporter(Path dataDirectory) {
        this.langFolder = dataDirectory.resolve("lang");
    }

    public void exportIfMissing() {
        try {
            Files.createDirectories(this.langFolder, new FileAttribute[0]);
            for (String file : this.languageFiles) {
                Path targetFile = this.langFolder.resolve(file);
                if (Files.exists(targetFile, new LinkOption[0])) continue;
                InputStream in = this.getClass().getClassLoader().getResourceAsStream("lang/" + file);
                try {
                    if (in != null) {
                        Files.copy(in, targetFile, new CopyOption[0]);
                        System.out.println("[FallbackRouter] Exported " + file + " to lang folder.");
                        continue;
                    }
                    System.out.println("[FallbackRouter] WARNING: Could not find " + file + " in JAR resources.");
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        catch (IOException e) {
            System.err.println("[FallbackRouter] Failed to export language files:");
            e.printStackTrace();
        }
    }
}

