/*
 * Decompiled with CFR 0.152.
 */
package de.darksmp;

import java.io.InputStream;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class Messages {
    private final Map<String, Object> lang;
    private final Map<String, Object> fallback;

    public Messages(String language) {
        this.lang = this.loadLanguage(language);
        this.fallback = this.loadLanguage("en");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> loadLanguage(String code) {
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("lang/" + code + ".yml");){
            if (in == null) {
                Map<String, Object> map2 = Map.of();
                return map2;
            }
            Map map = (Map)new Yaml().load(in);
            return map;
        }
        catch (Exception e) {
            return Map.of();
        }
    }

    public String get(String key, Map<String, String> placeholders) {
        String value = this.getRaw(key);
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            value = value.replace("%" + entry.getKey() + "%", entry.getValue());
        }
        return value;
    }

    public String getRaw(String key) {
        String[] parts = key.split("\\\\.");
        Object current = this.lang;
        for (String part : parts) {
            Map<String, Object> map;
            if (!(current instanceof Map) || !(map = current).containsKey(part)) {
                current = this.getFallback(parts);
                break;
            }
            current = map.get(part);
        }
        return current instanceof String ? (String)current : key;
    }

    private Object getFallback(String[] parts) {
        Object current = this.fallback;
        for (String part : parts) {
            Map<String, Object> map;
            if (!(current instanceof Map) || !(map = current).containsKey(part)) {
                return null;
            }
            current = map.get(part);
        }
        return current;
    }
}

