/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.heriosfloralexpansion.entity;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.mcreator.heriosfloralexpansion.init.HeriosFloralExpansionModEntities;
import net.mcreator.heriosfloralexpansion.procedures.BabyScaleProcedure;
import net.mcreator.heriosfloralexpansion.procedures.CattusRandomColorProcedure;
import net.mcreator.heriosfloralexpansion.procedures.CattusRightClickedOnEntityProcedure;
import net.mcreator.heriosfloralexpansion.procedures.CattusSitPlaybackConditionProcedure;
import net.mcreator.heriosfloralexpansion.procedures.CattusSittingProcedure;
import net.mcreator.heriosfloralexpansion.procedures.CattusSprintPlaybackConditionProcedure;
import net.mcreator.heriosfloralexpansion.procedures.CattusSprintsToTargetProcedure;
import net.mcreator.heriosfloralexpansion.procedures.IdlePlaybackConditionProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class CattusEntity
extends TamableAnimal {
    public static final EntityDataAccessor<Boolean> DATA_pink = SynchedEntityData.defineId(CattusEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_red = SynchedEntityData.defineId(CattusEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_violet = SynchedEntityData.defineId(CattusEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_yellow = SynchedEntityData.defineId(CattusEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_blue = SynchedEntityData.defineId(CattusEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_orange = SynchedEntityData.defineId(CattusEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_sitting = SynchedEntityData.defineId(CattusEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();

    public CattusEntity(EntityType<CattusEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_pink, (Object)false);
        builder.define(DATA_red, (Object)false);
        builder.define(DATA_violet, (Object)false);
        builder.define(DATA_yellow, (Object)false);
        builder.define(DATA_blue, (Object)false);
        builder.define(DATA_orange, (Object)false);
        builder.define(DATA_sitting, (Object)false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.0, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Creeper.class, false, true){

            public boolean canUse() {
                double x = CattusEntity.this.getX();
                double y = CattusEntity.this.getY();
                double z = CattusEntity.this.getZ();
                CattusEntity entity = CattusEntity.this;
                Level world = CattusEntity.this.level();
                return super.canUse() && CattusSittingProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CattusEntity.this.getX();
                double y = CattusEntity.this.getY();
                double z = CattusEntity.this.getZ();
                CattusEntity entity = CattusEntity.this;
                Level world = CattusEntity.this.level();
                return super.canContinueToUse() && CattusSittingProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f){

            public boolean canUse() {
                double x = CattusEntity.this.getX();
                double y = CattusEntity.this.getY();
                double z = CattusEntity.this.getZ();
                CattusEntity entity = CattusEntity.this;
                Level world = CattusEntity.this.level();
                return super.canUse() && CattusSittingProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CattusEntity.this.getX();
                double y = CattusEntity.this.getY();
                double z = CattusEntity.this.getZ();
                CattusEntity entity = CattusEntity.this;
                Level world = CattusEntity.this.level();
                return super.canContinueToUse() && CattusSittingProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new BreedGoal((Animal)this, 1.0){

            public boolean canUse() {
                double x = CattusEntity.this.getX();
                double y = CattusEntity.this.getY();
                double z = CattusEntity.this.getZ();
                CattusEntity entity = CattusEntity.this;
                Level world = CattusEntity.this.level();
                return super.canUse() && CattusSittingProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CattusEntity.this.getX();
                double y = CattusEntity.this.getY();
                double z = CattusEntity.this.getZ();
                CattusEntity entity = CattusEntity.this;
                Level world = CattusEntity.this.level();
                return super.canContinueToUse() && CattusSittingProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new FollowParentGoal((Animal)this, 1.0){

            public boolean canUse() {
                double x = CattusEntity.this.getX();
                double y = CattusEntity.this.getY();
                double z = CattusEntity.this.getZ();
                CattusEntity entity = CattusEntity.this;
                Level world = CattusEntity.this.level();
                return super.canUse() && CattusSittingProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CattusEntity.this.getX();
                double y = CattusEntity.this.getY();
                double z = CattusEntity.this.getZ();
                CattusEntity entity = CattusEntity.this;
                Level world = CattusEntity.this.level();
                return super.canContinueToUse() && CattusSittingProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.BONE_MEAL}), false){

            public boolean canUse() {
                double x = CattusEntity.this.getX();
                double y = CattusEntity.this.getY();
                double z = CattusEntity.this.getZ();
                CattusEntity entity = CattusEntity.this;
                Level world = CattusEntity.this.level();
                return super.canUse() && CattusSittingProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CattusEntity.this.getX();
                double y = CattusEntity.this.getY();
                double z = CattusEntity.this.getZ();
                CattusEntity entity = CattusEntity.this;
                Level world = CattusEntity.this.level();
                return super.canContinueToUse() && CattusSittingProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                double x = CattusEntity.this.getX();
                double y = CattusEntity.this.getY();
                double z = CattusEntity.this.getZ();
                CattusEntity entity = CattusEntity.this;
                Level world = CattusEntity.this.level();
                return super.canUse() && CattusSittingProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CattusEntity.this.getX();
                double y = CattusEntity.this.getY();
                double z = CattusEntity.this.getZ();
                CattusEntity entity = CattusEntity.this;
                Level world = CattusEntity.this.level();
                return super.canContinueToUse() && CattusSittingProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(9, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.cat.ambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.cat.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.cat.death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.CACTUS)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        CattusRandomColorProcedure.execute((Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Datapink", ((Boolean)this.entityData.get(DATA_pink)).booleanValue());
        compound.putBoolean("Datared", ((Boolean)this.entityData.get(DATA_red)).booleanValue());
        compound.putBoolean("Dataviolet", ((Boolean)this.entityData.get(DATA_violet)).booleanValue());
        compound.putBoolean("Datayellow", ((Boolean)this.entityData.get(DATA_yellow)).booleanValue());
        compound.putBoolean("Datablue", ((Boolean)this.entityData.get(DATA_blue)).booleanValue());
        compound.putBoolean("Dataorange", ((Boolean)this.entityData.get(DATA_orange)).booleanValue());
        compound.putBoolean("Datasitting", ((Boolean)this.entityData.get(DATA_sitting)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datapink")) {
            this.entityData.set(DATA_pink, (Object)compound.getBoolean("Datapink"));
        }
        if (compound.contains("Datared")) {
            this.entityData.set(DATA_red, (Object)compound.getBoolean("Datared"));
        }
        if (compound.contains("Dataviolet")) {
            this.entityData.set(DATA_violet, (Object)compound.getBoolean("Dataviolet"));
        }
        if (compound.contains("Datayellow")) {
            this.entityData.set(DATA_yellow, (Object)compound.getBoolean("Datayellow"));
        }
        if (compound.contains("Datablue")) {
            this.entityData.set(DATA_blue, (Object)compound.getBoolean("Datablue"));
        }
        if (compound.contains("Dataorange")) {
            this.entityData.set(DATA_orange, (Object)compound.getBoolean("Dataorange"));
        }
        if (compound.contains("Datasitting")) {
            this.entityData.set(DATA_sitting, (Object)compound.getBoolean("Datasitting"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide()) : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        CattusEntity entity = this;
        Level world = this.level();
        CattusRightClickedOnEntityProcedure.execute((Entity)entity, (Entity)sourceentity);
        return retval;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(IdlePlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState1.animateWhen(CattusSitPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(CattusSprintPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        CattusSprintsToTargetProcedure.execute((LevelAccessor)this.level(), (Entity)this);
        this.refreshDimensions();
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        CattusEntity retval = (CattusEntity)((EntityType)HeriosFloralExpansionModEntities.CATTUS.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.BONE_MEAL)}).test(stack);
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        CattusEntity entity = this;
        Level world = this.level();
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        return super.getDefaultDimensions(pose).scale((float)BabyScaleProcedure.execute((Entity)entity));
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)HeriosFloralExpansionModEntities.CATTUS.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getBlockState(pos.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON) && world.getRawBrightness(pos, 0) > 8, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.25);
        builder = builder.add(Attributes.MAX_HEALTH, 10.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 25.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }
}

