/*
 * Decompiled with CFR 0.152.
 */
package com.spaceagle17.iris_shader_folder;

import com.spaceagle17.iris_shader_folder.ConfigManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="iris_shader_folder")
public class IrisShaderFolder {
    public static final String MOD_ID = "iris_shader_folder";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"iris_shader_folder");
    public static final String VERSION = "1.2.4";
    public static Path shaderpacks = FMLPaths.GAMEDIR.get().resolve("shaderpacks");
    private static IrisShaderFolder INSTANCE;
    public static boolean debugLoggingEnabled;
    public static List<String> filterPatterns;
    public static List<String> reorderPatterns;
    public static List<String> recolorPatterns;
    public static List<String> tooltipPatterns;

    public static IrisShaderFolder getInstance() {
        return INSTANCE;
    }

    public void loadConfigOptions() {
        String defaultContent;
        debugLoggingEnabled = Boolean.parseBoolean(ConfigManager.readWriteConfig("debugLogging", "false", "Enable debug logging (creates a debug file with detailed pattern processing)"));
        if (ConfigManager.getSectionItems("filter").isEmpty()) {
            String filterDescription = "List of shader patterns to filter out, one per line\nExamples:\n  - Exact Match: Test (only \"Test\" will be filtered)\n  - With version placeholder: ComplementaryReimagined_r{version}\n  - With regex: Complementary{.*}\n{version} matches any version number pattern like 1.2.3 or 4.5\nOther {xyz} are treated as regex patterns (very powerful, be careful!)\n.zip extensions are handled automatically\n";
            defaultContent = "# Add filter patterns here, one per line\n# test\n# Complementary\n# BSL{.*}";
            ConfigManager.writeSection("filter", defaultContent, filterDescription);
        }
        filterPatterns = ConfigManager.getSectionItems("filter");
        if (ConfigManager.getSectionItems("reorder").isEmpty()) {
            String reorderDescription = "List of shaderpacks to reorder in the shaderpacks selection menu, one per line\nThe position is determined by line order (first line = position 1, etc.)\nExamples:\n  - First position: {.*}EuphoriaPatches{.*}\n  - Second position: Complementary{.*}_r{version}\n  - Third position: BSL{.*}\nIf multiple shaderpacks match a pattern, they are inserted at the given position, sorted alphabetically.\n{version} matches any version number pattern like 1.2.3 or 4.5\nOther {xyz} are treated as regex patterns (very powerful, be careful!)\n.zip extensions are handled automatically\n";
            defaultContent = "# Add reorder patterns here, one per line\n# {.*}EuphoriaPatches{.*}\n# Complementary{.*}_r{version}\n# BSL{.*}";
            ConfigManager.writeSection("reorder", defaultContent, reorderDescription);
        }
        reorderPatterns = ConfigManager.getSectionItems("reorder");
        if (ConfigManager.getSectionItems("recolor").isEmpty()) {
            String recolorDescription = "List of recoloring rules for shaderpack names in the selection menu\nEach rule recolors either a specific part of the shaderpack name or the entire name.\n{version} matches any version number pattern like 1.2.3 or 4.5\nOther {xyz} are treated as regex patterns (very powerful, be careful!)\nFormat: shader_pattern [|] part_pattern [->] color_name [|] part_pattern2 [->] color_name2 ....\n  - shader_pattern: Matches shaderpack names (exact or with {regex})\n  - part_pattern: Matches the part of the name to recolor (exact or with {regex})\n      - Use {all} to recolor the entire name\n  - color_name: One of the official Minecraft color names or Minecraft color codes:\n    black (\u00a70), dark_blue (\u00a71), dark_green (\u00a72), dark_aqua (\u00a73), dark_red (4), dark_purple (\u00a75), gold (\u00a76), gray (\u00a77),\n    dark_gray (\u00a78), blue (\u00a79), green (\u00a7a), aqua (\u00a7b), red (\u00a7c), light_purple (\u00a7d), yellow (\u00a7e), white (\u00a7f)\n    Additional formatting codes: bold (\u00a7l), italic (\u00a7o), underline (\u00a7n), strikethrough (\u00a7m), reset (\u00a7r), obfuscated (\u00a7k)\n  - The \"part_pattern [->] color_name\" combination can be repeated as often as desired to get multiple colors in the same name\n\nExamples:\n  - Complementary{.*} [|] Comp [->] red [|] {version} [->] \u00a76\n      Recolors the \"Comp\" part to red and the version part in any Complementary shaderpack name to gold.\n  - {.*}EuphoriaPatches{.*} [|] EuphoriaPatches_{version} [->] light_purple\n      Recolors the \"EuphoriaPatches_{version}\" part in any shader with EuphoriaPatches in the name to light_purple.\n  - test [|] {all} [->] red\n      Recolors the entire name \"test\" to red.\n";
            defaultContent = "# Add recolor rules here, one per line\n# Complementary{.*} [|] Comp [->] red [|] {version} [->] \u00a76\n# {.*}EuphoriaPatches{.*} [|] EuphoriaPatches_{version} [->] light_purple\n# test [|] {all} [->] red";
            ConfigManager.writeSection("recolor", defaultContent, recolorDescription);
        }
        recolorPatterns = ConfigManager.getSectionItems("recolor");
        if (ConfigManager.getSectionItems("tooltip").isEmpty()) {
            String tooltipDescription = "List of tooltip rules for shaderpacks in the selection menu\nFormat: shader_pattern [|] tooltip_text\n  - shader_pattern: Matches shaderpack names (exact or with {regex})\n  - tooltip_text: Text to display when hovering over the shader\n\nNote: If a shader has its own description in its pack.json file, that description will be\nshown first, followed by your custom tooltip text if configured here.\n\nExamples:\n  - Complementary{.*} [|] Complementary is a shaderpack focused on performance and visual quality.\n  - {.*}EuphoriaPatches{.*} [|] A powerful add-on for Complementary Shaders.\n  - test [|] This is a test shaderpack.";
            defaultContent = "# Add tooltip rules here, one per line\n# Complementary{.*} [|] Complementary is a shaderpack focused on performance and visual quality.\n# test [|] This is a test shaderpack.";
            ConfigManager.writeSection("tooltip", defaultContent, tooltipDescription);
        }
        tooltipPatterns = ConfigManager.getSectionItems("tooltip");
    }

    public List<String> getFilterPatterns() {
        return filterPatterns;
    }

    public List<String> getReorderPatterns() {
        return reorderPatterns;
    }

    public List<String> getRecolorPatterns() {
        return recolorPatterns;
    }

    public List<String> getTooltipPatterns() {
        return tooltipPatterns;
    }

    public IrisShaderFolder() {
        INSTANCE = this;
        ConfigManager.loadProperties();
        this.loadConfigOptions();
        ConfigManager.startConfigWatcher();
        LOGGER.info("Hello from Iris Shader Folder Mod v1.2.4");
    }

    public static boolean isSpacEagle() {
        try {
            boolean containsSpacEagle = shaderpacks.toString().contains("SpacEagle");
            Path euphoriaFolder = shaderpacks.resolve("Euphoria-Patches");
            boolean hasEuphoriaFolder = Files.exists(euphoriaFolder, new LinkOption[0]) && Files.isDirectory(euphoriaFolder, new LinkOption[0]);
            return containsSpacEagle && hasEuphoriaFolder;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    static {
        debugLoggingEnabled = false;
        filterPatterns = new ArrayList<String>();
        reorderPatterns = new ArrayList<String>();
        recolorPatterns = new ArrayList<String>();
        tooltipPatterns = new ArrayList<String>();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                ConfigManager.stopConfigWatcher();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
    }
}

