/*
 * Decompiled with CFR 0.152.
 */
package com.spaceagle17.iris_shader_folder;

import com.spaceagle17.iris_shader_folder.ConfigManager;
import com.spaceagle17.iris_shader_folder.IrisShaderFolder;
import com.spaceagle17.iris_shader_folder.util.ShaderPatternUtil;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ShaderFilterSystem {
    private static ShaderFilterSystem INSTANCE;
    private static final String DEBUG_FILE = "config/iris_shader_filter_debug.txt";
    private List<Pattern> compiledPatterns = new ArrayList<Pattern>();
    private List<String> lastFilterPatterns = new ArrayList<String>();
    private boolean lastDebugLogSetting = false;

    private ShaderFilterSystem() {
        this.updatePatterns();
    }

    public static ShaderFilterSystem getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ShaderFilterSystem();
        }
        return INSTANCE;
    }

    private void writeDebug(String message, boolean append) {
        if (!IrisShaderFolder.debugLoggingEnabled) {
            return;
        }
        try (FileWriter debugWriter = new FileWriter(DEBUG_FILE, append);){
            debugWriter.write(message);
        }
        catch (IOException e) {
            IrisShaderFolder.LOGGER.error("Failed to write debug info", (Throwable)e);
        }
    }

    public void updatePatterns() {
        List<String> filterPatterns = IrisShaderFolder.filterPatterns;
        boolean debugLogging = IrisShaderFolder.debugLoggingEnabled;
        if (filterPatterns.equals(this.lastFilterPatterns) && debugLogging == this.lastDebugLogSetting) {
            return;
        }
        this.lastFilterPatterns = new ArrayList<String>(filterPatterns);
        this.lastDebugLogSetting = debugLogging;
        StringBuilder debugContent = new StringBuilder();
        debugContent.append("Filter patterns (").append(filterPatterns.size()).append("):\n");
        for (String pattern : filterPatterns) {
            debugContent.append("  - '").append(pattern).append("'\n");
        }
        debugContent.append("\n");
        if (debugLogging) {
            this.writeDebug(debugContent.toString(), false);
        }
        this.compiledPatterns.clear();
        for (String pattern : filterPatterns) {
            if ((pattern = pattern.trim()).isEmpty() || pattern.startsWith("#")) continue;
            try {
                debugContent = new StringBuilder();
                if (debugLogging) {
                    debugContent.append("Processing pattern: '").append(pattern).append("'\n");
                }
                String regexPattern = ShaderPatternUtil.convertToRegex(pattern);
                if (debugLogging) {
                    debugContent.append("  \u2192 Converted to regex: '").append(regexPattern).append("'\n");
                }
                String finalPattern = "^" + regexPattern + "(\\.zip)?$";
                if (debugLogging) {
                    debugContent.append("  \u2192 Final pattern: '").append(finalPattern).append("'\n\n");
                    this.writeDebug(debugContent.toString(), true);
                }
                if (debugLogging) {
                    ShaderPatternUtil.logDebug("Creating pattern: " + finalPattern);
                }
                this.compiledPatterns.add(Pattern.compile(finalPattern, 2));
            }
            catch (PatternSyntaxException e) {
                String errorMsg = "Invalid filter pattern: " + pattern + " - " + e.getMessage();
                IrisShaderFolder.LOGGER.error(errorMsg);
                if (!debugLogging) continue;
                this.writeDebug("ERROR: " + errorMsg + "\n", true);
            }
        }
    }

    public boolean shouldFilterShaderPack(String packName) {
        if (ConfigManager.checkForUpdates()) {
            this.updatePatterns();
        }
        for (Pattern pattern : this.compiledPatterns) {
            if (!pattern.matcher(packName).matches()) continue;
            if (IrisShaderFolder.debugLoggingEnabled) {
                IrisShaderFolder.LOGGER.info("Filtering out shader pack: " + packName);
                this.writeDebug("Filtering out shader pack: " + packName + "\n", true);
            }
            return false;
        }
        return true;
    }

    public boolean matchesPattern(String packName, String patternStr) {
        return ShaderPatternUtil.matchesPattern(packName, patternStr);
    }
}

