/*
 * Decompiled with CFR 0.152.
 */
package com.spaceagle17.iris_shader_folder;

import com.spaceagle17.iris_shader_folder.IrisShaderFolder;
import com.spaceagle17.iris_shader_folder.util.ShaderPatternUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ShaderReorderSystem {
    private static ShaderReorderSystem INSTANCE;

    private ShaderReorderSystem() {
    }

    public static ShaderReorderSystem getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ShaderReorderSystem();
        }
        return INSTANCE;
    }

    public List<String> reorderShaderPacks(List<String> shaderPacks) {
        List<String> reorderPatterns;
        if (shaderPacks.isEmpty()) {
            return shaderPacks;
        }
        ArrayList<String> result = new ArrayList<String>(shaderPacks);
        if (IrisShaderFolder.isSpacEagle()) {
            String euphoriaPatches = "Euphoria-Patches";
            if (result.contains(euphoriaPatches)) {
                result.remove(euphoriaPatches);
                result.add(0, euphoriaPatches);
            }
            ShaderPatternUtil.logDebug("SpacEagle detected: Euphoria-Patches prioritized to first position");
        }
        if ((reorderPatterns = IrisShaderFolder.getInstance().getReorderPatterns()).isEmpty()) {
            return result;
        }
        ArrayList<ReorderRule> rules = new ArrayList<ReorderRule>();
        int i = 0;
        while (i < reorderPatterns.size()) {
            String pattern = reorderPatterns.get(i).trim();
            int position = i++;
            rules.add(new ReorderRule(pattern, position));
            ShaderPatternUtil.logDebug("Added reorder rule: pattern '" + pattern + "' at position " + (position + 1));
        }
        int nextAvailableIndex = IrisShaderFolder.isSpacEagle() ? 1 : 0;
        for (ReorderRule rule : rules) {
            ArrayList<String> matchingPacks = new ArrayList<String>();
            Iterator it = result.iterator();
            while (it.hasNext()) {
                String pack = (String)it.next();
                if (IrisShaderFolder.isSpacEagle() && result.indexOf(pack) == 0 && (pack.equals("Euphoria-Patches") || pack.equals("Euphoria-Patches.zip")) || !ShaderPatternUtil.matchesPattern(pack, rule.getPattern())) continue;
                matchingPacks.add(pack);
                it.remove();
            }
            Collections.sort(matchingPacks);
            int insertIndex = rule.getPosition();
            insertIndex = Math.max(insertIndex, nextAvailableIndex);
            insertIndex = Math.min(insertIndex, result.size());
            for (String pack : matchingPacks) {
                result.add(insertIndex, pack);
                nextAvailableIndex = ++insertIndex;
            }
        }
        return result;
    }

    private static class ReorderRule {
        private final String pattern;
        private final int position;

        public ReorderRule(String pattern, int position) {
            this.pattern = pattern;
            this.position = position;
        }

        public String getPattern() {
            return this.pattern;
        }

        public int getPosition() {
            return this.position;
        }
    }
}

