/*
 * Decompiled with CFR 0.152.
 */
package com.spaceagle17.iris_shader_folder;

import com.spaceagle17.iris_shader_folder.ConfigManager;
import com.spaceagle17.iris_shader_folder.IrisShaderFolder;
import com.spaceagle17.iris_shader_folder.util.ShaderPatternUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ShaderRecolorSystem
implements ConfigManager.ConfigUpdateListener {
    private static ShaderRecolorSystem INSTANCE;
    private static final Map<String, String> COLOR_MAP;
    private static final String EUPHORIA_DETECTION = "(EuphoriaPatches|Euphoria-Patches|EP_earlyDev|Complementary.* \\+ EP)";
    private static final String EUPHORIA_PATTERN = "{.*(EuphoriaPatches|Euphoria-Patches|EP_earlyDev|Complementary.* \\+ EP).*}";
    private final List<ColorRule> euphoriaRules = new ArrayList<ColorRule>();
    private final Map<String, String> recolorCache = new HashMap<String, String>();
    private final Set<String> loggedRecolors = new HashSet<String>();
    private List<RecolorRule> recolorRules = new ArrayList<RecolorRule>();
    private List<String> lastRecolorPatterns = new ArrayList<String>();
    private boolean euphoriaRulesAdded = false;

    private ShaderRecolorSystem() {
        this.euphoriaRules.add(new ColorRule("+ EuphoriaPatches_{version}", COLOR_MAP.get("light_purple")));
        this.euphoriaRules.add(new ColorRule("Euphoria-Patches{.*}", COLOR_MAP.get("light_purple")));
        this.euphoriaRules.add(new ColorRule("+ EP_{.*}", COLOR_MAP.get("light_purple")));
        this.euphoriaRules.add(new ColorRule("EuphoriaPatches_earlyDev{.*}", COLOR_MAP.get("light_purple")));
        this.euphoriaRules.add(new ColorRule("_0EuphoriaPatches{.*}Error{.*}Shader", COLOR_MAP.get("red")));
        this.euphoriaRules.add(new ColorRule("Outdated", COLOR_MAP.get("red")));
        ConfigManager.registerUpdateListener(this);
        this.updateRules();
    }

    public static ShaderRecolorSystem getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ShaderRecolorSystem();
        }
        return INSTANCE;
    }

    public void updateRules() {
        boolean configChanged;
        List<String> recolorPatterns = IrisShaderFolder.getInstance().getRecolorPatterns();
        boolean bl = configChanged = !recolorPatterns.equals(this.lastRecolorPatterns);
        if (!configChanged && this.euphoriaRulesAdded) {
            return;
        }
        this.lastRecolorPatterns = new ArrayList<String>(recolorPatterns);
        this.recolorRules.clear();
        this.recolorCache.clear();
        this.loggedRecolors.clear();
        this.euphoriaRulesAdded = false;
        for (String rule : recolorPatterns) {
            if ((rule = rule.trim()).isEmpty() || rule.startsWith("#")) continue;
            try {
                String[] parts = rule.split("\\s*\\[\\|\\]\\s*");
                if (parts.length < 2) {
                    IrisShaderFolder.LOGGER.error("Invalid recolor rule format: {}", (Object)rule);
                    continue;
                }
                String shaderPattern = parts[0].trim();
                ArrayList<ColorRule> colorRulesList = new ArrayList<ColorRule>();
                for (int i = 1; i < parts.length; ++i) {
                    String[] colorParts = parts[i].split("\\s*\\[->\\]\\s*");
                    if (colorParts.length != 2) {
                        IrisShaderFolder.LOGGER.error("Invalid color rule format: {}", (Object)parts[i]);
                        continue;
                    }
                    String partPattern = colorParts[0].trim();
                    String colorName = colorParts[1].trim();
                    String colorCode = colorName.startsWith("\u00a7") ? colorName : COLOR_MAP.getOrDefault(colorName.toLowerCase(), "\u00a7f");
                    colorRulesList.add(new ColorRule(partPattern, colorCode));
                }
                if (colorRulesList.isEmpty()) continue;
                this.recolorRules.add(new RecolorRule(shaderPattern, colorRulesList));
                ShaderPatternUtil.logDebug("Added recolor rule for pattern: " + shaderPattern + " with " + colorRulesList.size() + " color rules");
            }
            catch (Exception e) {
                IrisShaderFolder.LOGGER.error("Error parsing recolor rule: " + rule, (Throwable)e);
            }
        }
        this.addDefaultEuphoriaRules();
        this.euphoriaRulesAdded = true;
    }

    private void addDefaultEuphoriaRules() {
        this.recolorRules.add(new RecolorRule(EUPHORIA_PATTERN, this.euphoriaRules));
        ShaderPatternUtil.logDebug("Added default recolor rule for Euphoria Patches");
    }

    private String applyEuphoriaColorRules(String input) {
        ShaderPatternUtil.logDebug("Applying Euphoria color rules to pre-colored content: " + (String)input);
        String strippedInput = ((String)input).replaceAll("\u00a7[0-9a-fklmnor]", "");
        ShaderPatternUtil.logDebug("Stripped input: " + strippedInput);
        for (ColorRule rule : this.euphoriaRules) {
            String coloredResult;
            String patternStr = rule.getPartPattern();
            String colorCode = rule.getColorCode();
            String regex = patternStr.contains("{version}") || patternStr.contains("{.*}") ? patternStr.replace("+ ", "\\+ ").replace("{version}", "[0-9.]+").replace("{.*}", ".*") : Pattern.quote(patternStr);
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(strippedInput);
            if (!matcher.find()) continue;
            String match = matcher.group();
            ShaderPatternUtil.logDebug("Found match for rule [" + patternStr + "]: " + match);
            int startIndex = strippedInput.indexOf(match);
            if (startIndex < 0) continue;
            int coloredStartIndex = this.findColoredPosition((String)input, strippedInput, startIndex);
            int coloredEndIndex = this.findColoredPosition((String)input, strippedInput, startIndex + match.length());
            if (coloredStartIndex < 0 || coloredEndIndex <= coloredStartIndex) continue;
            String before = ((String)input).substring(0, coloredStartIndex);
            String after = ((String)input).substring(coloredEndIndex);
            String targetSection = ((String)input).substring(coloredStartIndex, coloredEndIndex);
            if (targetSection.startsWith("\u00a7") && targetSection.length() >= 2) {
                targetSection = targetSection.replaceAll("^(\u00a7[0-9a-fklmnor])+", "");
                coloredResult = before + colorCode + targetSection + "\u00a7r" + after;
                ShaderPatternUtil.logDebug("Applied rule [" + patternStr + "] with color [" + colorCode + "] (replacing existing color):");
                ShaderPatternUtil.logDebug("  * Before: " + (String)input);
                ShaderPatternUtil.logDebug("  * After:  " + (String)coloredResult);
                input = coloredResult;
                continue;
            }
            coloredResult = before + colorCode + match + "\u00a7r" + after;
            ShaderPatternUtil.logDebug("Applied rule [" + patternStr + "] with color [" + colorCode + "]:");
            ShaderPatternUtil.logDebug("  * Before: " + (String)input);
            ShaderPatternUtil.logDebug("  * After:  " + coloredResult);
            input = coloredResult;
        }
        input = ((String)input).replaceAll("(\u00a7[0-9a-fklmnor])\\1+", "$1");
        return input;
    }

    private int findColoredPosition(String colored, String stripped, int strippedPos) {
        if (strippedPos == 0) {
            return 0;
        }
        if (strippedPos >= stripped.length()) {
            return colored.length();
        }
        int coloredPos = 0;
        int strippedIndex = 0;
        while (strippedIndex < strippedPos && coloredPos < colored.length()) {
            if (colored.charAt(coloredPos) == '\u00a7' && coloredPos + 1 < colored.length()) {
                coloredPos += 2;
                continue;
            }
            ++coloredPos;
            ++strippedIndex;
        }
        return coloredPos;
    }

    public String recolorShaderName(String name) {
        if (this.recolorCache.containsKey(name)) {
            return this.recolorCache.get(name);
        }
        String result = name;
        boolean modified = false;
        boolean hasEuphoriaContent = Pattern.compile(EUPHORIA_DETECTION).matcher(name).find();
        ShaderPatternUtil.logDebug("Processing shader name: [" + name + "]");
        if (hasEuphoriaContent) {
            ShaderPatternUtil.logDebug("- Contains Euphoria content (matches pattern: (EuphoriaPatches|Euphoria-Patches|EP_earlyDev|Complementary.* \\+ EP))");
        }
        ShaderPatternUtil.logDebug("--- FIRST PASS: Applying all rules ---");
        for (RecolorRule rule : this.recolorRules) {
            boolean isEuphoriaRule = rule.getShaderPattern().equals(EUPHORIA_PATTERN);
            ShaderPatternUtil.logDebug("- Checking rule with pattern: [" + rule.getShaderPattern() + (isEuphoriaRule ? "] (Euphoria rule)" : "]"));
            if (ShaderPatternUtil.matchesPattern(name, rule.getShaderPattern())) {
                ShaderPatternUtil.logDebug("  - Rule matches!");
                Iterator<ColorRule> iterator = rule.getColorRules().iterator();
                while (iterator.hasNext()) {
                    String before = result;
                    ColorRule colorRule = iterator.next();
                    if (!before.equals(result = this.applyColorRule(result, colorRule))) {
                        modified = true;
                        ShaderPatternUtil.logDebug("  - Applied color rule [" + colorRule.getPartPattern() + " -> " + colorRule.getColorCode() + "]");
                        ShaderPatternUtil.logDebug("    * Before: [" + before + "]");
                        ShaderPatternUtil.logDebug("    * After:  [" + result + "]");
                        continue;
                    }
                    ShaderPatternUtil.logDebug("  - Color rule [" + colorRule.getPartPattern() + "] had no effect");
                }
                continue;
            }
            ShaderPatternUtil.logDebug("  - Rule does not match");
        }
        if (hasEuphoriaContent) {
            ShaderPatternUtil.logDebug("--- SECOND PASS: Re-applying Euphoria rules ---");
            String before = result;
            result = this.applyEuphoriaColorRules(result);
            if (!before.equals(result)) {
                modified = true;
                ShaderPatternUtil.logDebug("Euphoria rules successfully applied in second pass");
            } else {
                ShaderPatternUtil.logDebug("No changes from Euphoria rules in second pass");
            }
        }
        this.recolorCache.put(name, result);
        if (modified) {
            ShaderPatternUtil.logDebug("=== FINAL RESULT ===");
            ShaderPatternUtil.logDebug("- Original: [" + name + "]");
            ShaderPatternUtil.logDebug("- Recolored: [" + result + "]");
        }
        return result;
    }

    private String applyColorRule(String input, ColorRule colorRule) {
        String pattern = colorRule.getPartPattern();
        String colorCode = colorRule.getColorCode();
        if (pattern.equals("{all}")) {
            return colorCode + input + "\u00a7r";
        }
        try {
            String regexPattern = ShaderPatternUtil.convertToRegex(pattern);
            Pattern compiledPattern = Pattern.compile(regexPattern);
            Matcher matcher = compiledPattern.matcher(input);
            StringBuffer result = new StringBuffer();
            while (matcher.find()) {
                String replacement = colorCode + matcher.group() + "\u00a7r";
                matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
            }
            matcher.appendTail(result);
            return result.toString();
        }
        catch (PatternSyntaxException e) {
            IrisShaderFolder.LOGGER.error("Invalid pattern in color rule: " + pattern, (Throwable)e);
            return input;
        }
    }

    public void clearCache() {
        this.recolorCache.clear();
        this.loggedRecolors.clear();
    }

    @Override
    public void onConfigUpdate() {
        this.updateRules();
    }

    static {
        COLOR_MAP = new HashMap<String, String>();
        COLOR_MAP.put("black", "\u00a70");
        COLOR_MAP.put("dark_blue", "\u00a71");
        COLOR_MAP.put("dark_green", "\u00a72");
        COLOR_MAP.put("dark_aqua", "\u00a73");
        COLOR_MAP.put("dark_red", "\u00a74");
        COLOR_MAP.put("dark_purple", "\u00a75");
        COLOR_MAP.put("gold", "\u00a76");
        COLOR_MAP.put("gray", "\u00a77");
        COLOR_MAP.put("dark_gray", "\u00a78");
        COLOR_MAP.put("blue", "\u00a79");
        COLOR_MAP.put("green", "\u00a7a");
        COLOR_MAP.put("aqua", "\u00a7b");
        COLOR_MAP.put("red", "\u00a7c");
        COLOR_MAP.put("light_purple", "\u00a7d");
        COLOR_MAP.put("yellow", "\u00a7e");
        COLOR_MAP.put("white", "\u00a7f");
        COLOR_MAP.put("bold", "\u00a7l");
        COLOR_MAP.put("italic", "\u00a7o");
        COLOR_MAP.put("underline", "\u00a7n");
        COLOR_MAP.put("strikethrough", "\u00a7m");
        COLOR_MAP.put("reset", "\u00a7r");
        COLOR_MAP.put("obfuscated", "\u00a7k");
    }

    private static class ColorRule {
        private final String partPattern;
        private final String colorCode;

        public ColorRule(String partPattern, String colorCode) {
            this.partPattern = partPattern;
            this.colorCode = colorCode;
        }

        public String getPartPattern() {
            return this.partPattern;
        }

        public String getColorCode() {
            return this.colorCode;
        }
    }

    private static class RecolorRule {
        private final String shaderPattern;
        private final List<ColorRule> colorRules;

        public RecolorRule(String shaderPattern, List<ColorRule> colorRules) {
            this.shaderPattern = shaderPattern;
            this.colorRules = colorRules;
        }

        public String getShaderPattern() {
            return this.shaderPattern;
        }

        public List<ColorRule> getColorRules() {
            return this.colorRules;
        }
    }
}

