/*
 * Decompiled with CFR 0.152.
 */
package com.spaceagle17.iris_shader_folder;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.spaceagle17.iris_shader_folder.ConfigManager;
import com.spaceagle17.iris_shader_folder.IrisShaderFolder;
import com.spaceagle17.iris_shader_folder.util.ShaderPatternUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ShaderTooltipSystem {
    private static ShaderTooltipSystem INSTANCE;
    private final Map<String, String> tooltipCache = new HashMap<String, String>();
    private final Map<String, String> packJsonDescriptionCache = new HashMap<String, String>();
    private List<TooltipRule> tooltipRules = new ArrayList<TooltipRule>();
    private List<String> lastTooltipPatterns = new ArrayList<String>();
    private static final Gson GSON;
    private long lastCacheRefreshTime = 0L;
    private static final long CACHE_REFRESH_INTERVAL = 5000L;
    private boolean rulesInitialized = false;

    private ShaderTooltipSystem() {
        this.updateRules();
    }

    public static ShaderTooltipSystem getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ShaderTooltipSystem();
        }
        return INSTANCE;
    }

    public void updateRules() {
        boolean configChanged;
        List<String> tooltipPatterns = IrisShaderFolder.getInstance().getTooltipPatterns();
        boolean bl = configChanged = !tooltipPatterns.equals(this.lastTooltipPatterns);
        if (!configChanged && this.rulesInitialized) {
            return;
        }
        this.lastTooltipPatterns = new ArrayList<String>(tooltipPatterns);
        this.tooltipRules.clear();
        this.clearCache();
        for (String rule : tooltipPatterns) {
            if ((rule = rule.trim()).isEmpty() || rule.startsWith("#")) continue;
            try {
                String[] parts = rule.split("\\s*\\[\\|\\]\\s*", 2);
                if (parts.length != 2) {
                    IrisShaderFolder.LOGGER.error("Invalid tooltip rule format: {}", (Object)rule);
                    continue;
                }
                String shaderPattern = parts[0].trim();
                String tooltipText = parts[1].trim();
                this.tooltipRules.add(new TooltipRule(shaderPattern, tooltipText));
                ShaderPatternUtil.logDebug("Added tooltip rule for pattern: " + shaderPattern);
            }
            catch (Exception e) {
                IrisShaderFolder.LOGGER.error("Error parsing tooltip rule: " + rule, (Throwable)e);
            }
        }
        this.rulesInitialized = true;
    }

    public String getTooltip(String shaderName) {
        ConfigManager.checkForUpdates();
        this.updateRules();
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastCacheRefreshTime > 5000L) {
            this.clearCache();
            this.lastCacheRefreshTime = currentTime;
        }
        if (this.tooltipCache.containsKey(shaderName)) {
            return this.tooltipCache.get(shaderName);
        }
        String packJsonDescription = this.getPackJsonDescription(shaderName);
        StringBuilder tooltipBuilder = new StringBuilder();
        if (packJsonDescription != null && !packJsonDescription.isEmpty()) {
            tooltipBuilder.append(packJsonDescription);
        }
        for (TooltipRule rule : this.tooltipRules) {
            if (!ShaderPatternUtil.matchesPattern(shaderName, rule.getShaderPattern())) continue;
            if (tooltipBuilder.length() > 0) {
                tooltipBuilder.append("\n");
            }
            tooltipBuilder.append(rule.getTooltipText());
        }
        String tooltip = tooltipBuilder.toString();
        this.tooltipCache.put(shaderName, tooltip);
        return tooltip;
    }

    private String getPackJsonDescription(String shaderName) {
        String description;
        block22: {
            if (this.packJsonDescriptionCache.containsKey(shaderName)) {
                return this.packJsonDescriptionCache.get(shaderName);
            }
            description = null;
            try {
                Path folderPath;
                Path packJsonPath;
                String baseName = shaderName;
                if (baseName.toLowerCase().endsWith(".zip")) {
                    baseName = baseName.replace(".zip", "");
                }
                if (Files.exists(packJsonPath = (folderPath = IrisShaderFolder.shaderpacks.resolve(baseName)).resolve("shaders/pack.json"), new LinkOption[0])) {
                    try {
                        String content = new String(Files.readAllBytes(packJsonPath));
                        description = this.extractDescription(content);
                    }
                    catch (IOException e) {
                        if (IrisShaderFolder.debugLoggingEnabled) {
                            IrisShaderFolder.LOGGER.error("Error reading pack.json from folder: " + folderPath, (Throwable)e);
                        }
                        break block22;
                    }
                }
                Path zipPath = IrisShaderFolder.shaderpacks.resolve(baseName + ".zip");
                if (!Files.exists(zipPath, new LinkOption[0])) break block22;
                try (ZipFile zipFile = new ZipFile(zipPath.toFile());){
                    ZipEntry packJsonEntry = zipFile.getEntry("shaders/pack.json");
                    if (packJsonEntry == null) break block22;
                    try (InputStreamReader reader = new InputStreamReader(zipFile.getInputStream(packJsonEntry));){
                        JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                        if (jsonObject.has("shaderDescription")) {
                            description = jsonObject.get("shaderDescription").getAsString();
                        }
                    }
                }
                catch (Exception e) {
                    if (IrisShaderFolder.debugLoggingEnabled) {
                        IrisShaderFolder.LOGGER.error("Error reading pack.json from zip: " + zipPath, (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                if (!IrisShaderFolder.debugLoggingEnabled) break block22;
                IrisShaderFolder.LOGGER.error("Error getting pack.json description for: " + shaderName, (Throwable)e);
            }
        }
        this.packJsonDescriptionCache.put(shaderName, description);
        return description;
    }

    private String extractDescription(String jsonContent) {
        block3: {
            try {
                JsonObject jsonObject = (JsonObject)GSON.fromJson(jsonContent, JsonObject.class);
                if (jsonObject.has("shaderDescription")) {
                    return jsonObject.get("shaderDescription").getAsString();
                }
            }
            catch (JsonParseException e) {
                if (!IrisShaderFolder.debugLoggingEnabled) break block3;
                IrisShaderFolder.LOGGER.error("Error parsing pack.json", (Throwable)e);
            }
        }
        return null;
    }

    public void clearCache() {
        this.tooltipCache.clear();
        this.packJsonDescriptionCache.clear();
    }

    static {
        GSON = new Gson();
    }

    private static class TooltipRule {
        private final String shaderPattern;
        private final String tooltipText;

        public TooltipRule(String shaderPattern, String tooltipText) {
            this.shaderPattern = shaderPattern;
            this.tooltipText = tooltipText;
        }

        public String getShaderPattern() {
            return this.shaderPattern;
        }

        public String getTooltipText() {
            return this.tooltipText;
        }
    }
}

