/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit;

import emanondev.itemedit.CooldownAPI;
import emanondev.itemedit.UpdateChecker;
import emanondev.itemedit.UtilsString;
import emanondev.itemedit.YMLConfig;
import emanondev.itemedit.command.AbstractCommand;
import emanondev.itemedit.compability.Metrics;
import emanondev.itemedit.plugin.PluginAdditionalInfo;
import emanondev.itemedit.utility.ReflectionUtils;
import emanondev.itemedit.utility.VersionUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class APlugin
extends JavaPlugin {
    private final Map<String, YMLConfig> configs = VersionUtils.hasFoliaAPI() ? new ConcurrentHashMap() : new HashMap();
    private final Map<String, YMLConfig> languageConfigs = VersionUtils.hasFoliaAPI() ? new ConcurrentHashMap() : new HashMap();
    private final PluginAdditionalInfo pluginAdditionalInfo = new PluginAdditionalInfo(this);
    private boolean useMultiLanguage;
    private String defaultLanguage;
    private CooldownAPI cooldownApi = null;
    private Metrics bstatsMetrics;

    protected APlugin() {
    }

    @NotNull
    public YMLConfig getConfig() {
        return this.getConfig("config.yml");
    }

    @NotNull
    public YMLConfig getConfig(@NotNull String fileName) {
        if (this.configs.containsKey(fileName = YMLConfig.fixName(fileName))) {
            return this.configs.get(fileName);
        }
        YMLConfig conf = new YMLConfig(this, fileName);
        this.configs.put(fileName, conf);
        return conf;
    }

    public void log(@NotNull String log) {
        Bukkit.getConsoleSender().sendMessage(UtilsString.fix(ChatColor.DARK_BLUE + "[" + ChatColor.WHITE + this.getName() + ChatColor.DARK_BLUE + "] " + ChatColor.WHITE + log, null, true, new String[0]));
    }

    public void log(@NotNull ChatColor color, @NotNull String prefix, @NotNull String log) {
        this.log(color + prefix + " " + ChatColor.WHITE + log);
    }

    public void registerListener(@NotNull Listener listener) {
        this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
    }

    public void registerCommand(@NotNull AbstractCommand executor, @Nullable List<String> aliases) {
        this.registerCommand(executor.getName(), executor, aliases);
    }

    public void registerCommand(@NotNull String commandName, @NotNull TabExecutor executor, @Nullable List<String> aliases) {
        PluginCommand command = this.getCommand(commandName);
        if (command == null) {
            this.log("&cUnable to register Command &e" + commandName);
            return;
        }
        command.setExecutor((CommandExecutor)executor);
        command.setTabCompleter((TabCompleter)executor);
        if (aliases != null) {
            command.setAliases(aliases);
        }
    }

    @NotNull
    public YMLConfig getLanguageConfig(@Nullable CommandSender sender) {
        String locale = this.getLocale(sender);
        if (this.languageConfigs.containsKey(locale)) {
            return this.languageConfigs.get(locale);
        }
        String fileName = "languages" + File.separator + locale + ".yml";
        if (locale.equals(this.defaultLanguage) || new File(this.getDataFolder(), fileName).exists() || this.getResource("languages/" + locale + ".yml") != null) {
            YMLConfig conf = new YMLConfig(this, fileName);
            this.languageConfigs.put(locale, conf);
            return conf;
        }
        YMLConfig conf = this.getLanguageConfig(null);
        this.languageConfigs.put(locale, conf);
        return conf;
    }

    public abstract void enable();

    public abstract void reload();

    public abstract void disable();

    protected void updateConfigurations(int oldConfigVersion) {
    }

    protected boolean addLanguagesMetrics() {
        return false;
    }

    @NotNull
    protected Predicate<Player> languagesMetricsIsAdmin() {
        return ServerOperator::isOp;
    }

    @NotNull
    protected Predicate<Player> languagesMetricsIsUser() {
        return player -> true;
    }

    protected void reloadConfigs() {
        boolean check = false;
        for (YMLConfig conf : this.configs.values()) {
            try {
                if (conf.getFile().exists()) {
                    conf.reload();
                    continue;
                }
                check = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (check) {
            ArrayList toRemove = new ArrayList();
            this.configs.forEach((k, v) -> {
                try {
                    if (!v.getFile().exists()) {
                        toRemove.add(k);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            for (String key : toRemove) {
                this.configs.remove(key);
            }
        }
        this.languageConfigs.clear();
        this.getLanguageConfig(null);
    }

    @NotNull
    public CooldownAPI getCooldownAPI() {
        if (this.cooldownApi == null) {
            this.cooldownApi = new CooldownAPI(this);
        }
        return this.cooldownApi;
    }

    @Deprecated
    public void onEnable() {
        try {
            long now = System.currentTimeMillis();
            if (!ReflectionUtils.isClassPresent("org.spigotmc.SpigotConfig")) {
                this.enableWithError("CraftBukkit is not supported!!! use Spigot or Paper");
                this.log(ChatColor.GREEN, "#", "Enabled (took &e" + (System.currentTimeMillis() - now) + "&f ms)");
                return;
            }
            if (!VersionUtils.isVersionAfter(1, 8)) {
                this.enableWithError("1.7.x is not supported!!! use 1.8+");
                this.log(ChatColor.GREEN, "#", "Enabled (took &e" + (System.currentTimeMillis() - now) + "&f ms)");
                return;
            }
            this.initLanguages();
            if (this.getPluginAdditionalInfo().getSpigotResourceId() != null && this.getConfig().getBoolean("check-updates", true)) {
                new UpdateChecker(this).logUpdates();
            }
            this.initConfigUpdater();
            this.initMetrics();
            this.enable();
            this.log(ChatColor.GREEN, "#", "Enabled (took &e" + (System.currentTimeMillis() - now) + "&f ms)");
        }
        catch (Throwable e) {
            this.log(ChatColor.RED + "Error while loading " + this.getName() + ", disabling it");
            e.printStackTrace();
            Bukkit.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public final void onReload() {
        long now = System.currentTimeMillis();
        this.useMultiLanguage = this.getConfig().getBoolean("language.use_multilanguage", true);
        this.defaultLanguage = this.getConfig().getString("language.default_language", "en");
        this.reloadConfigs();
        this.reload();
        this.log(ChatColor.GREEN, "#", "Reloaded (took &e" + (System.currentTimeMillis() - now) + "&f ms)");
    }

    public void onDisable() {
        this.disable();
    }

    protected final void enableWithError(@NotNull String error) {
        TabExecutorError exec = new TabExecutorError(ChatColor.RED + error);
        for (String command : this.getDescription().getCommands().keySet()) {
            this.registerCommand(command, exec, null);
        }
        this.log(ChatColor.RED + error);
    }

    @NotNull
    private String getLocale(@Nullable CommandSender sender) {
        String locale = !(sender instanceof Player) ? this.defaultLanguage : (VersionUtils.isVersionAfter(1, 12) && this.useMultiLanguage ? (((Player)sender).getLocale().equals("zh_tw") ? ((Player)sender).getLocale() : ((Player)sender).getLocale().split("_")[0]) : this.defaultLanguage);
        return locale;
    }

    private void initMetrics() {
        Integer pluginId = this.getPluginAdditionalInfo().getBstatsPluginId();
        if (pluginId == null) {
            this.bstatsMetrics = null;
            return;
        }
        try {
            this.bstatsMetrics = new Metrics(this, pluginId);
            if (this.addLanguagesMetrics()) {
                Predicate<Player> isAdmin = this.languagesMetricsIsAdmin();
                Predicate<Player> isUser = this.languagesMetricsIsUser();
                if (!VersionUtils.isVersionAfter(1, 12)) {
                    return;
                }
                this.bstatsMetrics.addCustomChart(new Metrics.DrilldownPie("admins_languages", () -> {
                    HashMap mainMap = new HashMap();
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!isAdmin.test(player)) continue;
                        String locale = player.getLocale().toLowerCase(Locale.ENGLISH);
                        String pre = locale.split("_")[0];
                        if (!mainMap.containsKey(pre)) {
                            mainMap.put(pre, new HashMap());
                        }
                        Map subMap = (Map)mainMap.get(pre);
                        subMap.put(locale, subMap.getOrDefault(locale, 0) + 1);
                    }
                    return mainMap;
                }));
                this.bstatsMetrics.addCustomChart(new Metrics.DrilldownPie("users_languages", () -> {
                    HashMap mainMap = new HashMap();
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!isUser.test(player)) continue;
                        String locale = player.getLocale().toLowerCase(Locale.ENGLISH);
                        String pre = locale.split("_")[0];
                        if (!mainMap.containsKey(pre)) {
                            mainMap.put(pre, new HashMap());
                        }
                        Map subMap = (Map)mainMap.get(pre);
                        subMap.put(locale, subMap.getOrDefault(locale, 0) + 1);
                    }
                    return mainMap;
                }));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.bstatsMetrics = null;
    }

    private void initConfigUpdater() {
        ConfigurationSection def = this.getConfig().getDefaultSection();
        int currentVersion = def == null ? 1 : def.getInt("config-version", 1);
        int oldVersion = this.getConfig().getInt("config-version", 1);
        if (oldVersion >= currentVersion) {
            return;
        }
        this.log("Updating configuration version (" + oldVersion + " -> " + currentVersion + ")");
        this.updateConfigurations(oldVersion);
        this.getConfig().set("config-version", currentVersion);
        this.log("Updated configuration version (" + oldVersion + " -> " + currentVersion + ")");
        this.getConfig().save();
    }

    private void initLanguages() {
        this.useMultiLanguage = this.getConfig().getBoolean("language.use_multilanguage", true);
        this.defaultLanguage = this.getConfig().getString("language.default", "en");
        if (this.getConfig().getBoolean("language.regen_files", true)) {
            YMLConfig version = this.getConfig("version.yml");
            if (!this.getDescription().getVersion().equals(version.loadMessage("previous_version", "1", new String[0]))) {
                File[] list;
                version.set("previous_version", this.getDescription().getVersion());
                version.save();
                File langFolder = new File(this.getDataFolder(), "languages");
                if (langFolder.exists() && (list = langFolder.listFiles()) != null) {
                    for (File file : list) {
                        if (this.getResource("languages/" + file.getName()) == null) continue;
                        this.saveResource("languages/" + file.getName(), true);
                    }
                }
            }
        }
        this.getLanguageConfig(null);
    }

    public PluginAdditionalInfo getPluginAdditionalInfo() {
        return this.pluginAdditionalInfo;
    }

    public Metrics getBstatsMetrics() {
        return this.bstatsMetrics;
    }

    protected final class TabExecutorError
    implements TabExecutor {
        private final String msg;

        public TabExecutorError(String msg) {
            this.msg = msg;
            for (int i = 0; i < 20; ++i) {
                APlugin.this.log(msg);
            }
        }

        public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
            return Collections.emptyList();
        }

        public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
            sender.sendMessage(this.msg);
            return true;
        }
    }
}

