/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit;

import emanondev.itemedit.APlugin;
import emanondev.itemedit.YMLConfig;
import emanondev.itemedit.utility.VersionUtils;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class CooldownAPI {
    private final YMLConfig conf;
    private final Map<UUID, Map<String, Long>> cooldowns = VersionUtils.hasFoliaAPI() ? new ConcurrentHashMap() : new HashMap();

    CooldownAPI(@NotNull APlugin plugin) {
        long now = System.currentTimeMillis();
        this.conf = plugin.getConfig("cooldownData.yml");
        for (String id : this.conf.getKeys(false)) {
            AbstractMap map = VersionUtils.hasFoliaAPI() ? new ConcurrentHashMap() : new HashMap();
            this.cooldowns.put(UUID.fromString(id), map);
            for (String cooldownId : this.conf.getKeys(id)) {
                try {
                    long value = this.conf.getLong(id + "." + cooldownId, 0L);
                    if (value <= now) continue;
                    map.put(cooldownId, value);
                }
                catch (Exception e) {
                    plugin.log("Corrupted path value for cooldown data on ");
                    e.printStackTrace();
                }
            }
        }
    }

    void save() {
        long now = System.currentTimeMillis();
        this.conf.getKeys(false).forEach(path -> this.conf.set((String)path, null));
        for (UUID uuid : this.cooldowns.keySet()) {
            Map<String, Long> values = this.cooldowns.get(uuid);
            for (String id : values.keySet()) {
                if (values.get(id) <= now) continue;
                this.conf.getLong(uuid.toString() + "." + id, values.get(id));
            }
        }
        this.conf.save();
    }

    public void setCooldown(@NotNull Block block, @NotNull String cooldownId, @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long duration, @NotNull TimeUnit timeUnit) {
        this.setCooldown(new UUID((long)block.getX() << 32 | (long)block.getY(), (long)block.getZ() << 32 | (long)block.getWorld().getName().hashCode()), cooldownId, duration, timeUnit);
    }

    public void addCooldown(@NotNull Block block, @NotNull String cooldownId, @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long duration, @NotNull TimeUnit timeUnit) {
        this.addCooldown(new UUID((long)block.getX() << 32 | (long)block.getY(), (long)block.getZ() << 32 | (long)block.getWorld().getName().hashCode()), cooldownId, duration, timeUnit);
    }

    public void reduceCooldown(@NotNull Block block, @NotNull String cooldownId, @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long duration, @NotNull TimeUnit timeUnit) {
        this.reduceCooldown(new UUID((long)block.getX() << 32 | (long)block.getY(), (long)block.getZ() << 32 | (long)block.getWorld().getName().hashCode()), cooldownId, duration, timeUnit);
    }

    public void removeCooldown(@NotNull Block block, @NotNull String cooldownId) {
        this.removeCooldown(new UUID((long)block.getX() << 32 | (long)block.getY(), (long)block.getZ() << 32 | (long)block.getWorld().getName().hashCode()), cooldownId);
    }

    public boolean hasCooldown(@NotNull Block block, @NotNull String cooldownId) {
        return this.hasCooldown(new UUID((long)block.getX() << 32 | (long)block.getY(), (long)block.getZ() << 32 | (long)block.getWorld().getName().hashCode()), cooldownId);
    }

    public long getCooldown(@NotNull Block block, @NotNull String cooldownId, @NotNull TimeUnit timeUnit) {
        return this.getCooldown(new UUID((long)block.getX() << 32 | (long)block.getY(), (long)block.getZ() << 32 | (long)block.getWorld().getName().hashCode()), cooldownId, timeUnit);
    }

    public void setCooldown(@NotNull OfflinePlayer player, @NotNull String cooldownId, @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long duration, @NotNull TimeUnit timeUnit) {
        this.setCooldown(player.getUniqueId(), cooldownId, duration, timeUnit);
    }

    public void addCooldown(@NotNull OfflinePlayer player, @NotNull String cooldownId, @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long duration, @NotNull TimeUnit timeUnit) {
        this.addCooldown(player.getUniqueId(), cooldownId, duration, timeUnit);
    }

    public void reduceCooldown(@NotNull OfflinePlayer player, @NotNull String cooldownId, @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long duration, @NotNull TimeUnit timeUnit) {
        this.reduceCooldown(player.getUniqueId(), cooldownId, duration, timeUnit);
    }

    public void removeCooldown(@NotNull OfflinePlayer player, @NotNull String cooldownId) {
        this.removeCooldown(player.getUniqueId(), cooldownId);
    }

    public boolean hasCooldown(@NotNull OfflinePlayer player, @NotNull String cooldownId) {
        return this.hasCooldown(player.getUniqueId(), cooldownId);
    }

    public long getCooldown(@NotNull OfflinePlayer player, @NotNull String cooldownId, @NotNull TimeUnit timeUnit) {
        return this.getCooldown(player.getUniqueId(), cooldownId, timeUnit);
    }

    public void setCooldown(@NotNull UUID uuid, @NotNull String cooldownId, @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long duration, @NotNull TimeUnit timeUnit) {
        if (timeUnit.compareTo(TimeUnit.MILLISECONDS) < 0) {
            throw new UnsupportedOperationException("Time unit must be at least MILLISECONDS.");
        }
        if (duration <= 0L && this.cooldowns.containsKey(uuid)) {
            this.cooldowns.get(uuid).remove(cooldownId);
        } else {
            this.cooldowns.computeIfAbsent(uuid, k -> VersionUtils.hasFoliaAPI() ? new ConcurrentHashMap() : new HashMap());
            this.cooldowns.get(uuid).put(cooldownId, System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(duration, timeUnit));
        }
    }

    public void addCooldown(@NotNull UUID uuid, @NotNull String cooldownId, @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long duration, @NotNull TimeUnit timeUnit) {
        if (timeUnit.compareTo(TimeUnit.MILLISECONDS) < 0) {
            throw new UnsupportedOperationException("Time unit must be at least MILLISECONDS.");
        }
        this.setCooldown(uuid, cooldownId, this.getCooldown(uuid, cooldownId, TimeUnit.MILLISECONDS) + TimeUnit.MILLISECONDS.convert(duration, timeUnit), TimeUnit.MILLISECONDS);
    }

    public void reduceCooldown(@NotNull UUID uuid, @NotNull String cooldownId, @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long duration, @NotNull TimeUnit timeUnit) {
        if (timeUnit.compareTo(TimeUnit.MILLISECONDS) < 0) {
            throw new UnsupportedOperationException();
        }
        this.setCooldown(uuid, cooldownId, this.getCooldown(uuid, cooldownId, TimeUnit.MILLISECONDS) - TimeUnit.MILLISECONDS.convert(duration, timeUnit), TimeUnit.MILLISECONDS);
    }

    public void removeCooldown(@NotNull UUID uuid, @NotNull String cooldownId) {
        if (this.cooldowns.get(uuid) != null) {
            this.cooldowns.get(uuid).remove(cooldownId);
        }
    }

    public boolean hasCooldown(@NotNull UUID player, @NotNull String cooldownId) {
        return this.getCooldown(player, cooldownId, TimeUnit.MILLISECONDS) > 0L;
    }

    public long getCooldown(@NotNull UUID uuid, @NotNull String cooldownId, @NotNull TimeUnit timeUnit) {
        if (timeUnit.compareTo(TimeUnit.MILLISECONDS) < 0) {
            throw new UnsupportedOperationException("Time unit must be at least MILLISECONDS.");
        }
        long cooldownMS = this.cooldowns.containsKey(uuid) ? Math.max(0L, this.cooldowns.get(uuid).getOrDefault(cooldownId, 0L) - System.currentTimeMillis()) : 0L;
        return timeUnit.convert(cooldownMS, TimeUnit.MILLISECONDS);
    }
}

