/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit;

import emanondev.itemedit.ItemEdit;
import emanondev.itemedit.compability.Hooks;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class Util {
    private Util() {
        throw new UnsupportedOperationException();
    }

    public static void sendMessage(@NotNull CommandSender sender, String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        sender.sendMessage(message);
    }

    public static void sendMessage(@NotNull CommandSender sender, BaseComponent ... message) {
        if (sender instanceof Player) {
            ((Player)sender).spigot().sendMessage(message);
        } else {
            sender.sendMessage(BaseComponent.toPlainText((BaseComponent[])message));
        }
    }

    public static void logToFile(String message) {
        try {
            File dataFolder = ItemEdit.get().getDataFolder();
            if (!dataFolder.exists()) {
                dataFolder.mkdir();
            }
            Date date = new Date();
            File saveTo = new File(ItemEdit.get().getDataFolder(), "logs" + File.separatorChar + new SimpleDateFormat(ItemEdit.get().getConfig().loadMessage("log.file-format", "yyyy.MM.dd", false, new String[0]), Locale.ENGLISH).format(date) + ".log");
            if (!saveTo.getParentFile().exists()) {
                saveTo.getParentFile().mkdirs();
            }
            if (!saveTo.exists()) {
                saveTo.createNewFile();
            }
            FileWriter fw = new FileWriter(saveTo, true);
            PrintWriter pw = new PrintWriter(fw);
            pw.println(new SimpleDateFormat(ItemEdit.get().getConfig().loadMessage("log.log-date-format", "[dd.MM.yyyy HH:mm:ss]", false, new String[0]), Locale.ENGLISH).format(date) + message);
            pw.flush();
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean hasBannedWords(@NotNull Player user, String text) {
        if (user.hasPermission("itemedit.bypass.censure")) {
            return false;
        }
        String message = ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)text.toLowerCase(Locale.ENGLISH)));
        for (String regex : ItemEdit.get().getConfig().getStringList("blocked.regex")) {
            if (!Pattern.compile(regex).matcher(message).find()) continue;
            if (ItemEdit.get().getConfig().getBoolean("blocked.log.console", true)) {
                Util.sendMessage((CommandSender)Bukkit.getConsoleSender(), "user: \u00a7e" + user.getName() + "\u00a7r attempt to write '" + text + "'\u00a7r (stripped by colors and lowcased) was blocked by regex: \u00a7e" + regex);
            }
            if (ItemEdit.get().getConfig().getBoolean("blocked.log.file", true)) {
                Util.logToFile("user: '" + user.getName() + "' attempt to write '" + text + "' (stripped by colors and lowcased to '" + message + "') was blocked by regex: '" + regex + "'");
            }
            Util.sendMessage((CommandSender)user, ItemEdit.get().getLanguageConfig((CommandSender)user).loadMessage("blocked-by-censure", "", null, true, new String[0]));
            return true;
        }
        for (String bannedWord : ItemEdit.get().getConfig().getStringList("blocked.words")) {
            if (!message.contains(bannedWord.toLowerCase(Locale.ENGLISH))) continue;
            if (ItemEdit.get().getConfig().getBoolean("blocked.log.console", true)) {
                Util.sendMessage((CommandSender)Bukkit.getConsoleSender(), "user: \u00a7e" + user.getName() + "\u00a7r attempt to write '" + text + "'\u00a7r (stripped by colors and lowcased) was blocked by word: \u00a7e" + bannedWord.toLowerCase(Locale.ENGLISH));
            }
            if (ItemEdit.get().getConfig().getBoolean("blocked.log.file", true)) {
                Util.logToFile("user: '" + user.getName() + "' attempt to write '" + text + "' (stripped by colors and lowcased to '" + message + "') was blocked by word: '" + bannedWord.toLowerCase(Locale.ENGLISH) + "'");
            }
            Util.sendMessage((CommandSender)user, ItemEdit.get().getLanguageConfig((CommandSender)user).loadMessage("blocked-by-censure", "", null, true, new String[0]));
            return true;
        }
        return false;
    }

    public static String formatText(CommandSender sender, String text, String basePermission) {
        if (Util.hasMiniMessageAPI() && sender.hasPermission(basePermission + ".minimessage")) {
            text = Hooks.getMiniMessageUtil().fromMiniToText(text);
        }
        text = ChatColor.translateAlternateColorCodes((char)'&', (String)text);
        if (basePermission != null) {
            for (ChatColor style : ChatColor.values()) {
                if (style.isFormat()) {
                    if (sender.hasPermission(basePermission + ".format." + style.name().toLowerCase(Locale.ENGLISH))) continue;
                    text = text.replaceAll(style.toString(), "");
                    continue;
                }
                if (sender.hasPermission(basePermission + ".color." + style.name().toLowerCase(Locale.ENGLISH))) continue;
                text = text.replaceAll(style.toString(), "");
            }
            if (sender.hasPermission(basePermission + ".color.hexa")) {
                try {
                    int from = 0;
                    while (text.indexOf("&#", from) >= 0) {
                        from = text.indexOf("&#", from) + 1;
                        text = text.replace(text.substring(from - 1, from + 7), net.md_5.bungee.api.ChatColor.of((String)text.substring(from, from + 7)).toString());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return text;
    }

    public static boolean isAllowedRenameItem(CommandSender sender, Material type) {
        if (sender.hasPermission("itemedit.bypass.rename_type_restriction")) {
            return true;
        }
        List values = ItemEdit.get().getConfig().getStringList("blocked.type-blocked-rename");
        if (values.isEmpty()) {
            return true;
        }
        String id = type.name();
        for (String name : values) {
            if (!id.equalsIgnoreCase(name)) continue;
            Util.sendMessage(sender, ItemEdit.get().getLanguageConfig(sender).loadMessage("blocked-by-type-restriction", "", null, true, new String[0]));
            return false;
        }
        return true;
    }

    public static ItemStack getDyeItemFromColor(DyeColor color) {
        try {
            return new ItemStack(Material.valueOf((String)(color.name() + "_DYE")));
        }
        catch (Exception e) {
            return new ItemStack(Material.valueOf((String)"INK_SACK"), 1, 0, Util.getDataByColor(color));
        }
    }

    public static ItemStack getWoolItemFromColor(DyeColor color) {
        try {
            return new ItemStack(Material.valueOf((String)(color.name() + "_WOOL")));
        }
        catch (Exception e) {
            return new ItemStack(Material.valueOf((String)"WOOL"), 1, 0, Util.getDataByColor(color));
        }
    }

    public static Material getBannerItemFromColor(DyeColor color) {
        try {
            return Material.valueOf((String)(color.name() + "_BANNER"));
        }
        catch (Exception e) {
            return Material.valueOf((String)"BANNER");
        }
    }

    public static DyeColor getColorFromBanner(ItemStack banner) {
        try {
            String name = banner.getType().name();
            return DyeColor.valueOf((String)name.substring(0, name.length() - 7));
        }
        catch (Exception e) {
            return Util.getColorByData((byte)banner.getDurability());
        }
    }

    public static DyeColor getColorByData(byte color) {
        switch (color) {
            case 0: {
                return DyeColor.BLACK;
            }
            case 4: {
                return DyeColor.BLUE;
            }
            case 3: {
                return DyeColor.BROWN;
            }
            case 6: {
                return DyeColor.CYAN;
            }
            case 8: {
                return DyeColor.GRAY;
            }
            case 2: {
                return DyeColor.GREEN;
            }
            case 12: {
                return DyeColor.LIGHT_BLUE;
            }
            case 10: {
                return DyeColor.LIME;
            }
            case 13: {
                return DyeColor.MAGENTA;
            }
            case 14: {
                return DyeColor.ORANGE;
            }
            case 9: {
                return DyeColor.PINK;
            }
            case 5: {
                return DyeColor.PURPLE;
            }
            case 1: {
                return DyeColor.RED;
            }
            case 7: {
                return DyeColor.LIGHT_GRAY;
            }
            case 15: {
                return DyeColor.WHITE;
            }
            case 11: {
                return DyeColor.YELLOW;
            }
        }
        throw new IllegalStateException();
    }

    public static Byte getDataByColor(DyeColor color) {
        switch (color.name()) {
            case "BLACK": {
                return (byte)0;
            }
            case "BLUE": {
                return (byte)4;
            }
            case "BROWN": {
                return (byte)3;
            }
            case "CYAN": {
                return (byte)6;
            }
            case "GRAY": {
                return (byte)8;
            }
            case "GREEN": {
                return (byte)2;
            }
            case "LIGHT_BLUE": {
                return (byte)12;
            }
            case "LIME": {
                return (byte)10;
            }
            case "MAGENTA": {
                return (byte)13;
            }
            case "ORANGE": {
                return (byte)14;
            }
            case "PINK": {
                return (byte)9;
            }
            case "PURPLE": {
                return (byte)5;
            }
            case "RED": {
                return (byte)1;
            }
            case "SILVER": 
            case "LIGHT_GRAY": {
                return (byte)7;
            }
            case "WHITE": {
                return (byte)15;
            }
            case "YELLOW": {
                return (byte)11;
            }
        }
        throw new IllegalStateException();
    }

    public static boolean isAllowedChangeLore(CommandSender sender, Material type) {
        if (sender.hasPermission("itemedit.bypass.lore_type_restriction")) {
            return true;
        }
        List values = ItemEdit.get().getConfig().getStringList("blocked.type-blocked-lore");
        if (values.isEmpty()) {
            return true;
        }
        String id = type.name();
        for (String name : values) {
            if (!id.equalsIgnoreCase(name)) continue;
            Util.sendMessage(sender, ItemEdit.get().getLanguageConfig(sender).loadMessage("blocked-by-type-restriction-lore", "", null, true, new String[0]));
            return false;
        }
        return true;
    }

    public static boolean hasMiniMessageAPI() {
        return Hooks.hasMiniMessage();
    }
}

