/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.command;

import emanondev.itemedit.APlugin;
import emanondev.itemedit.Util;
import emanondev.itemedit.YMLConfig;
import emanondev.itemedit.command.SubCmd;
import emanondev.itemedit.utility.CompleteUtility;
import emanondev.itemedit.utility.ItemUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCommand
implements TabExecutor {
    private final String PATH;
    private final String name;
    private final APlugin plugin;
    private final YMLConfig config;
    private final List<SubCmd> subCmds = new ArrayList<SubCmd>();
    private final HelpSubCommand helpSubCommand;

    public AbstractCommand(@NotNull String name, @NotNull APlugin plugin) {
        this(name, plugin, false);
    }

    public AbstractCommand(@NotNull String name, @NotNull APlugin plugin, boolean multiPageHelp) {
        this.name = name.toLowerCase(Locale.ENGLISH);
        this.plugin = plugin;
        this.PATH = this.getName();
        this.config = plugin.getConfig("commands.yml");
        this.helpSubCommand = multiPageHelp ? new HelpSubCommand(this) : null;
    }

    public void reload() {
        this.config.reload();
        for (SubCmd sub : this.subCmds) {
            sub.reload();
        }
        if (this.helpSubCommand != null) {
            this.helpSubCommand.reload();
        }
    }

    @NotNull
    public List<SubCmd> getAllowedSubCommands(@NotNull CommandSender sender) {
        ArrayList<SubCmd> list = new ArrayList<SubCmd>();
        this.subCmds.forEach(sub -> {
            if (sender.hasPermission(sub.getPermission())) {
                list.add((SubCmd)sub);
            }
        });
        if (this.helpSubCommand != null && !this.subCmds.isEmpty()) {
            list.add(this.helpSubCommand);
        }
        return list;
    }

    public void registerSubCommand(@NotNull SubCmd sub) {
        this.subCmds.add(sub);
    }

    public boolean registerSubCommand(@NotNull Supplier<SubCmd> sub) {
        try {
            SubCmd subCommand = sub.get();
            if (subCommand != null) {
                this.subCmds.add(subCommand);
                return true;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return false;
    }

    public boolean registerSubCommand(@NotNull Supplier<SubCmd> sub, boolean condition) {
        if (!condition) {
            return false;
        }
        return this.registerSubCommand(sub);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        SubCmd subCmd;
        SubCmd subCmd2 = subCmd = args.length > 0 ? this.getSubCmd(args[0], sender) : null;
        if (this.validateRequires(subCmd, sender, label)) {
            subCmd.onCommand(sender, label, args);
        }
        return true;
    }

    public void sendPermissionLackMessage(@NotNull String permission, @NotNull CommandSender sender) {
        Util.sendMessage(sender, this.getPlugin().getLanguageConfig(sender).loadMessage("lack-permission", "&cYou lack of permission %permission%", sender instanceof Player ? (Player)sender : null, true, "%permission%", permission));
    }

    public void sendPermissionLackGenericMessage(@NotNull CommandSender sender) {
        Util.sendMessage(sender, this.getPlugin().getLanguageConfig(sender).loadMessage("lack-permission-generic", "&cYou don't have permission to use this command", sender instanceof Player ? (Player)sender : null, true, new String[0]));
    }

    public void sendPlayerOnly(@NotNull CommandSender sender) {
        Util.sendMessage(sender, this.getPlugin().getLanguageConfig(sender).loadMessage("player-only", "&cCommand for Players only", sender instanceof Player ? (Player)sender : null, true, new String[0]));
    }

    public void sendNoItemInHand(@NotNull CommandSender sender) {
        Util.sendMessage(sender, this.getPlugin().getLanguageConfig(sender).loadMessage("no-item-on-hand", "&cYou need to hold an item in hand", sender instanceof Player ? (Player)sender : null, true, new String[0]));
    }

    @Contract(value="null,_,_-> false")
    private boolean validateRequires(@Nullable SubCmd sub, @NotNull CommandSender sender, @NotNull String alias) {
        ItemStack item;
        if (sub == null) {
            this.help(sender, alias);
            return false;
        }
        if (!sender.hasPermission(sub.getPermission()) && sub != this.helpSubCommand) {
            this.sendPermissionLackMessage(sub.getPermission(), sender);
            return false;
        }
        if (sub.isPlayerOnly() && !(sender instanceof Player)) {
            this.sendPlayerOnly(sender);
            return false;
        }
        if (sub.isPlayerOnly() && sub.checkNonNullItem() && ItemUtils.isAirOrNull(item = ItemUtils.getHandItem((Player)sender))) {
            this.sendNoItemInHand(sender);
            return false;
        }
        return true;
    }

    private void help(@NotNull CommandSender sender, @NotNull String alias) {
        if (this.helpSubCommand != null) {
            this.helpSubCommand.help(sender, alias, 1);
            return;
        }
        ComponentBuilder help = new ComponentBuilder(this.getLanguageString("help-header", "&3&l" + this.getName() + " - Help", sender, new String[0]) + "\n");
        boolean c = false;
        for (SubCmd cmd : this.subCmds) {
            if (!sender.hasPermission(cmd.getPermission())) continue;
            if (c) {
                help.append("\n");
            } else {
                c = true;
            }
            help = cmd.getHelp(help, sender, alias);
        }
        if (c) {
            Util.sendMessage(sender, help.create());
        } else {
            this.sendPermissionLackGenericMessage(sender);
        }
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        SubCmd subCmd;
        List<String> l = new ArrayList<String>();
        if (args.length == 1) {
            this.completeCmd(l, args[0], sender);
            return l;
        }
        if (args.length > 1 && (subCmd = this.getSubCmd(args[0], sender)) != null && sender.hasPermission(subCmd.getPermission())) {
            l = subCmd.onComplete(sender, args);
        }
        return l;
    }

    public SubCmd getSubCmd(@NotNull String cmd, @NotNull CommandSender sender) {
        for (SubCmd subCmd : this.subCmds) {
            if (!subCmd.getName().equalsIgnoreCase(cmd)) continue;
            return subCmd;
        }
        if (this.helpSubCommand != null && this.helpSubCommand.getName().equalsIgnoreCase(cmd) && !this.getAllowedSubCommands(sender).isEmpty()) {
            return this.helpSubCommand;
        }
        return null;
    }

    public void completeCmd(@NotNull List<String> l, @NotNull String prefix, @NotNull CommandSender sender) {
        String text = prefix.toLowerCase(Locale.ENGLISH);
        this.getAllowedSubCommands(sender).forEach(cmd -> {
            if (cmd.getName().startsWith(text)) {
                l.add(cmd.getName());
            }
        });
    }

    protected String getLanguageString(String path, String def, CommandSender sender, String ... holders) {
        return this.getPlugin().getLanguageConfig(sender).loadMessage(this.PATH + "." + path, def == null ? "" : def, sender instanceof Player ? (Player)sender : null, true, holders);
    }

    protected List<String> getLanguageStringList(String path, List<String> def, CommandSender sender, String ... holders) {
        return this.getPlugin().getLanguageConfig(sender).loadMultiMessage(this.PATH + "." + path, def == null ? new ArrayList<String>() : def, sender instanceof Player ? (Player)sender : null, true, holders);
    }

    protected String getConfString(String path) {
        return this.config.loadMessage(this.PATH + "." + path, "", true, new String[0]);
    }

    protected int getConfInt(String path) {
        return this.config.loadInteger(this.PATH + "." + path, 0);
    }

    protected long getConfLong(String path) {
        return this.config.loadLong(this.PATH + "." + path, 0L);
    }

    protected boolean getConfBoolean(String path) {
        return this.config.loadBoolean(this.PATH + "." + path, true);
    }

    public String getName() {
        return this.name;
    }

    public APlugin getPlugin() {
        return this.plugin;
    }

    private class HelpSubCommand
    extends SubCmd {
        private int commandPerPage;

        public HelpSubCommand(AbstractCommand cmd) {
            super("help", cmd, false, false);
            this.commandPerPage = Math.max(4, this.getConfigInt("commands_per_page"));
        }

        private int getMaxPageFor(int elements) {
            return elements / this.commandPerPage + (elements % this.commandPerPage == 0 ? 0 : 1);
        }

        @Override
        public void onCommand(@NotNull CommandSender sender, @NotNull String alias, String[] args) {
            int page;
            block3: {
                page = 1;
                if (args.length > 1) {
                    try {
                        page = Integer.parseInt(args[1]);
                    }
                    catch (Exception ignored) {
                        SubCmd sub = AbstractCommand.this.getSubCmd(args[1], sender);
                        if (sub == null) break block3;
                        this.help(sender, alias, sub);
                        return;
                    }
                }
            }
            this.help(sender, alias, page);
        }

        public void help(CommandSender sender, String alias, SubCmd sub) {
            ComponentBuilder help = new ComponentBuilder(this.getLanguageString("header-sub", "&3&l" + this.getName() + " %sub% - Help", sender, "%sub%", sub.getName()));
            help.append("\n");
            String helpTxt = ChatColor.DARK_GREEN + "/" + alias + " " + ChatColor.GREEN + sub.getName() + " ";
            help.append(helpTxt + sub.getLanguageString("params", "", sender, new String[0]).replace(ChatColor.RESET.toString(), ChatColor.GREEN.toString()));
            help.append("\n");
            help.append(sub.getDescription(sender));
            Util.sendMessage(sender, help.create());
        }

        public void help(CommandSender sender, String alias, int page) {
            List<SubCmd> cmds = AbstractCommand.this.getAllowedSubCommands(sender);
            if (!cmds.isEmpty()) {
                page = Math.max(1, Math.min(this.getMaxPageFor(cmds.size()), page));
                ComponentBuilder help = new ComponentBuilder("");
                this.injectClickablePages(help, this.getLanguageString("header", "&3&l" + this.getName() + " - Help", sender, new String[0]), sender, alias, page);
                help.append("\n");
                for (SubCmd cmd : cmds.subList(this.commandPerPage * (page - 1), Math.min(cmds.size(), this.commandPerPage * page))) {
                    help = cmd.getHelp(help, sender, alias);
                    help.append("\n");
                }
                this.injectClickablePages(help, this.getLanguageString("footer", "&3&l" + this.getName() + " - Help", sender, new String[0]), sender, alias, page);
                Util.sendMessage(sender, help.create());
            } else {
                AbstractCommand.this.sendPermissionLackGenericMessage(sender);
            }
        }

        private void injectClickablePages(ComponentBuilder comp, String text, CommandSender sender, String alias, int page) {
            String text12;
            String text11;
            String text2;
            String text1;
            int maxPage = this.getMaxPageFor(AbstractCommand.this.getAllowedSubCommands(sender).size());
            int index = (text = text.replace("%page%", String.valueOf(page)).replace("%max_page%", String.valueOf(maxPage))).indexOf("%prev_clickable%");
            if (index != -1) {
                text1 = text.substring(0, index);
                text2 = text.substring(index + "%prev_clickable%".length());
            } else {
                text1 = text;
                text2 = null;
            }
            String text21 = null;
            String text22 = null;
            index = text1.indexOf("%next_clickable%");
            if (index != -1) {
                text11 = text1.substring(0, index);
                text12 = text1.substring(index + "%next_clickable%".length());
            } else {
                text11 = text1;
                text12 = null;
            }
            if (text2 != null) {
                index = text2.indexOf("%next_clickable%");
                if (index != -1) {
                    text21 = text2.substring(0, index);
                    text22 = text2.substring(index + "%next_clickable%".length());
                } else {
                    text21 = text2;
                }
            }
            comp.retain(ComponentBuilder.FormatRetention.NONE).append(text11);
            if (text12 != null) {
                if (page < maxPage) {
                    comp.append(this.getLanguageString("next_text", ">>>>", sender, "%target%", String.valueOf(page + 1), "%page%", String.valueOf(page))).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + alias + " " + this.getName() + " " + (page + 1))).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(this.getLanguageString("next_hover", "Go to page %target%", sender, "%target%", String.valueOf(page + 1), "%page%", String.valueOf(page), "%max_page%", String.valueOf(maxPage))).create()));
                } else {
                    comp.append(this.getLanguageString("next_void", ">>>>", sender, "%page%", String.valueOf(page), "%max_page%", String.valueOf(maxPage)));
                }
                comp.append(text12).retain(ComponentBuilder.FormatRetention.FORMATTING);
            }
            if (text21 != null) {
                if (page > 1) {
                    comp.append(this.getLanguageString("prev_text", "<<<<", sender, "%target%", String.valueOf(page - 1), "%page%", String.valueOf(page))).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + alias + " " + this.getName() + " " + (page - 1))).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(this.getLanguageString("prev_hover", "Go to page %target%", sender, "%target%", String.valueOf(page - 1), "%page%", String.valueOf(page), "%max_page%", String.valueOf(maxPage))).create()));
                } else {
                    comp.append(this.getLanguageString("prev_void", "<<<<", sender, "%page%", String.valueOf(page), "%max_page%", String.valueOf(maxPage)));
                }
                comp.append(text21).retain(ComponentBuilder.FormatRetention.FORMATTING);
            }
            if (text22 != null) {
                if (page < maxPage) {
                    comp.append(this.getLanguageString("next_text", ">>>>", sender, "%target%", String.valueOf(page + 1), "%page%", String.valueOf(page))).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + alias + " " + this.getName() + " " + (page + 1))).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(this.getLanguageString("next_hover", "Go to page %target%", sender, "%target%", String.valueOf(page + 1), "%page%", String.valueOf(page), "%max_page%", String.valueOf(maxPage))).create()));
                } else {
                    comp.append(this.getLanguageString("next_void", ">>>>", sender, "%page%", String.valueOf(page), "%max_page%", String.valueOf(maxPage)));
                }
                comp.append(text22).retain(ComponentBuilder.FormatRetention.FORMATTING);
            }
        }

        @Override
        public List<String> onComplete(@NotNull CommandSender sender, String[] args) {
            if (args.length != 2) {
                return Collections.emptyList();
            }
            ArrayList<String> tabs = new ArrayList<String>();
            List<SubCmd> subs = AbstractCommand.this.getAllowedSubCommands(sender);
            for (int i = 0; i < this.getMaxPageFor(subs.size()); ++i) {
                tabs.add(String.valueOf(i + 1));
            }
            for (SubCmd sub : subs) {
                tabs.add(sub.getName());
            }
            return CompleteUtility.complete(args[1], tabs);
        }

        @Override
        public void reload() {
            super.reload();
            this.commandPerPage = Math.max(4, this.getConfigInt("commands_per_page"));
        }
    }
}

