/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.command.itemedit;

import emanondev.itemedit.command.ItemEditCommand;
import emanondev.itemedit.command.SubCmd;
import emanondev.itemedit.utility.CompleteUtility;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class Amount
extends SubCmd {
    public Amount(ItemEditCommand cmd) {
        super("amount", cmd, true, true);
    }

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull String alias, String[] args) {
        Player p = (Player)sender;
        ItemStack item = this.getItemInHand(p);
        try {
            if (args.length != 2) {
                throw new IllegalArgumentException("Wrong param number");
            }
            int amount = Integer.parseInt(args[1]);
            if (amount < 0) {
                item.setAmount(Math.max(0, item.getAmount() + amount));
            } else {
                if (amount > 127 || amount < 1) {
                    throw new IllegalArgumentException("Wrong amount number");
                }
                item.setAmount(amount);
            }
            this.updateView(p);
        }
        catch (Exception e) {
            this.onFail((CommandSender)p, alias);
        }
    }

    @Override
    public List<String> onComplete(@NotNull CommandSender sender, String[] args) {
        if (args.length == 2) {
            return CompleteUtility.complete(args[1], Arrays.asList("1", "10", "64", "100", "127"));
        }
        return Collections.emptyList();
    }
}

