/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.command.itemedit;

import emanondev.itemedit.Util;
import emanondev.itemedit.aliases.Aliases;
import emanondev.itemedit.command.ItemEditCommand;
import emanondev.itemedit.command.SubCmd;
import emanondev.itemedit.utility.CompleteUtility;
import emanondev.itemedit.utility.ItemUtils;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.AxolotlBucketMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class AxolotlVariant
extends SubCmd {
    public AxolotlVariant(ItemEditCommand cmd) {
        super("axolotlvariant", cmd, true, true);
    }

    @Override
    public void reload() {
        super.reload();
    }

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull String alias, String[] args) {
        Player p = (Player)sender;
        ItemStack item = this.getItemInHand(p);
        if (!(item.getItemMeta() instanceof AxolotlBucketMeta)) {
            Util.sendMessage((CommandSender)p, this.getLanguageString("wrong-type", null, sender, new String[0]));
            return;
        }
        try {
            if (args.length != 2) {
                throw new IllegalArgumentException("Wrong param number");
            }
            AxolotlBucketMeta meta = (AxolotlBucketMeta)ItemUtils.getMeta(item);
            Axolotl.Variant type = (Axolotl.Variant)Aliases.AXOLOTL_VARIANT.convertAlias(args[1]);
            if (type == null) {
                this.onWrongAlias("wrong-axolotl", (CommandSender)p, Aliases.AXOLOTL_VARIANT, new String[0]);
                this.onFail((CommandSender)p, alias);
                return;
            }
            meta.setVariant(type);
            item.setItemMeta((ItemMeta)meta);
            this.updateView(p);
        }
        catch (Exception e) {
            this.onFail((CommandSender)p, alias);
        }
    }

    @Override
    public List<String> onComplete(@NotNull CommandSender sender, String[] args) {
        if (args.length == 2) {
            return CompleteUtility.complete(args[1], Aliases.AXOLOTL_VARIANT);
        }
        return Collections.emptyList();
    }
}

