/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.command.itemedit;

import emanondev.itemedit.Util;
import emanondev.itemedit.command.ItemEditCommand;
import emanondev.itemedit.command.SubCmd;
import emanondev.itemedit.utility.ItemUtils;
import java.util.Collections;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.jetbrains.annotations.NotNull;

public class ColorOld
extends SubCmd {
    private final String leatherPerm = this.getPermission() + ".leather";
    private final String starsPerm = this.getPermission() + ".firework_star";

    public ColorOld(ItemEditCommand cmd) {
        super("color", cmd, true, true);
    }

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull String alias, String[] args) {
        Player p = (Player)sender;
        ItemStack item = this.getItemInHand(p);
        if (item.getItemMeta() instanceof LeatherArmorMeta) {
            if (!sender.hasPermission(this.leatherPerm)) {
                this.getCommand().sendPermissionLackMessage(this.leatherPerm, sender);
                return;
            }
            LeatherArmorMeta leatherMeta = (LeatherArmorMeta)ItemUtils.getMeta(item);
            try {
                if (args.length != 4) {
                    throw new IllegalArgumentException("Wrong param number");
                }
                Color color = Color.fromRGB((int)Integer.parseInt(args[1]), (int)Integer.parseInt(args[2]), (int)Integer.parseInt(args[3]));
                leatherMeta.setColor(color);
                item.setItemMeta((ItemMeta)leatherMeta);
                this.updateView(p);
            }
            catch (Exception e) {
                this.onFail((CommandSender)p, alias);
            }
            return;
        }
        ItemMeta rawMeta = ItemUtils.getMeta(item);
        if (rawMeta instanceof FireworkEffectMeta) {
            if (!sender.hasPermission(this.starsPerm)) {
                this.getCommand().sendPermissionLackMessage(this.starsPerm, sender);
                return;
            }
            FireworkEffectMeta starMeta = (FireworkEffectMeta)rawMeta;
            try {
                if (args.length != 4) {
                    throw new IllegalArgumentException("Wrong param number");
                }
                Color color = Color.fromRGB((int)Integer.parseInt(args[1]), (int)Integer.parseInt(args[2]), (int)Integer.parseInt(args[3]));
                FireworkEffect oldEffect = starMeta.getEffect();
                FireworkEffect.Builder newEffect = FireworkEffect.builder().flicker(oldEffect != null && oldEffect.hasFlicker()).trail(oldEffect != null && oldEffect.hasTrail()).withColor(color);
                if (oldEffect != null && oldEffect.getFadeColors() != null) {
                    newEffect.withFade((Iterable)oldEffect.getFadeColors());
                }
                starMeta.setEffect(newEffect.build());
                item.setItemMeta((ItemMeta)starMeta);
                this.updateView(p);
            }
            catch (Exception e) {
                this.onFail((CommandSender)p, alias);
            }
            return;
        }
        Util.sendMessage((CommandSender)p, this.getLanguageString("wrong-type", null, sender, new String[0]));
    }

    @Override
    public List<String> onComplete(@NotNull CommandSender sender, String[] args) {
        return Collections.emptyList();
    }
}

