/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.command.itemedit;

import emanondev.itemedit.Util;
import emanondev.itemedit.command.ItemEditCommand;
import emanondev.itemedit.command.SubCmd;
import emanondev.itemedit.utility.CompleteUtility;
import emanondev.itemedit.utility.ItemUtils;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.CompassMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class Compass
extends SubCmd {
    private static final String[] compassSub = new String[]{"clear", "set"};

    public Compass(ItemEditCommand cmd) {
        super("compass", cmd, true, true);
    }

    @Override
    public void reload() {
        super.reload();
    }

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull String alias, String[] args) {
        Player p = (Player)sender;
        ItemStack item = this.getItemInHand(p);
        if (!(item.getItemMeta() instanceof CompassMeta)) {
            Util.sendMessage((CommandSender)p, this.getLanguageString("wrong-type", null, sender, new String[0]));
            return;
        }
        if (args.length == 1) {
            this.onFail((CommandSender)p, alias);
            return;
        }
        switch (args[1].toLowerCase(Locale.ENGLISH)) {
            case "set": {
                this.compassSet(p, item, args);
                return;
            }
            case "clear": {
                this.compassClear(p, item, args);
                return;
            }
        }
        this.onFail((CommandSender)p, alias);
    }

    @Override
    public List<String> onComplete(@NotNull CommandSender sender, String[] args) {
        if (args.length == 2) {
            return CompleteUtility.complete(args[1], compassSub);
        }
        return Collections.emptyList();
    }

    private void compassSet(Player p, ItemStack item, String[] args) {
        CompassMeta meta = (CompassMeta)ItemUtils.getMeta(item);
        meta.setLodestoneTracked(false);
        meta.setLodestone(p.getLocation());
        item.setItemMeta((ItemMeta)meta);
        this.getLanguageString("set.feedback", null, (CommandSender)p, "%world%", p.getLocation().getWorld().getName(), "%x%", String.valueOf(p.getLocation().getBlockX()), "%y%", String.valueOf(p.getLocation().getBlockY()), "%z%", String.valueOf(p.getLocation().getBlockZ()));
        this.updateView(p);
    }

    private void compassClear(Player p, ItemStack item, String[] args) {
        CompassMeta meta = (CompassMeta)ItemUtils.getMeta(item);
        meta.setLodestoneTracked(true);
        meta.setLodestone(p.getLocation());
        item.setItemMeta((ItemMeta)meta);
        Util.sendMessage((CommandSender)p, this.getLanguageString("clear.feedback", null, (CommandSender)p, new String[0]));
        this.updateView(p);
    }
}

