/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.command.itemedit;

import emanondev.itemedit.command.ItemEditCommand;
import emanondev.itemedit.command.SubCmd;
import emanondev.itemedit.utility.CompleteUtility;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class Damage
extends SubCmd {
    public Damage(ItemEditCommand cmd) {
        super("damage", cmd, true, true);
    }

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull String alias, String[] args) {
        Player p = (Player)sender;
        ItemStack item = this.getItemInHand(p);
        try {
            if (args.length != 2) {
                throw new IllegalArgumentException("Wrong param number");
            }
            short amount = Short.parseShort(args[1]);
            amount = (short)Math.max(0, Math.min(amount, item.getType().getMaxDurability()));
            item.setDurability(amount);
            this.updateView(p);
        }
        catch (Exception e) {
            this.onFail((CommandSender)p, alias);
        }
    }

    @Override
    public List<String> onComplete(@NotNull CommandSender sender, String[] args) {
        ItemStack item;
        if (args.length == 2 && sender instanceof Player && (item = this.getItemInHand((Player)sender)) != null && item.getType().getMaxDurability() > 1) {
            short max = item.getType().getMaxDurability();
            return CompleteUtility.complete(args[1], "0", String.valueOf(max), String.valueOf(max / 2), String.valueOf(max / 4), String.valueOf(max / 4 * 3));
        }
        return Collections.emptyList();
    }
}

