/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.command.itemedit;

import emanondev.itemedit.aliases.Aliases;
import emanondev.itemedit.command.ItemEditCommand;
import emanondev.itemedit.command.SubCmd;
import emanondev.itemedit.utility.CompleteUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class Enchant
extends SubCmd {
    public Enchant(ItemEditCommand cmd) {
        super("enchant", cmd, true, true);
    }

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull String alias, String[] args) {
        Player p = (Player)sender;
        ItemStack item = this.getItemInHand(p);
        try {
            if (args.length != 2 && args.length != 3) {
                throw new IllegalArgumentException("Wrong argument Number");
            }
            int lv = 1;
            Enchantment ench = (Enchantment)Aliases.ENCHANT.convertAlias(args[1]);
            if (ench == null) {
                this.onWrongAlias("wrong-enchant", (CommandSender)p, Aliases.ENCHANT, new String[0]);
                this.onFail((CommandSender)p, alias);
                return;
            }
            if (args.length == 3) {
                lv = Integer.parseInt(args[2]);
            }
            if (lv == 0) {
                item.removeEnchantment(ench);
            } else {
                if (!p.hasPermission(this.getPermission() + ".bypass_max_level")) {
                    lv = Math.min(ench.getMaxLevel(), lv);
                }
                item.addUnsafeEnchantment(ench, lv);
            }
            this.updateView(p);
        }
        catch (Exception e) {
            this.onFail((CommandSender)p, alias);
        }
    }

    @Override
    public List<String> onComplete(@NotNull CommandSender sender, String[] args) {
        if (args.length == 2) {
            return CompleteUtility.complete(args[1], Aliases.ENCHANT);
        }
        Enchantment ench = (Enchantment)Aliases.ENCHANT.convertAlias(args[2]);
        if (ench == null) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i <= ench.getMaxLevel(); ++i) {
            list.add(String.valueOf(i));
        }
        return list;
    }
}

