/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.command.itemedit;

import emanondev.itemedit.Util;
import emanondev.itemedit.aliases.Aliases;
import emanondev.itemedit.command.ItemEditCommand;
import emanondev.itemedit.command.SubCmd;
import emanondev.itemedit.utility.CompleteUtility;
import emanondev.itemedit.utility.ItemUtils;
import emanondev.itemedit.utility.TagContainer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.EquippableComponent;
import org.jetbrains.annotations.NotNull;

public class Equipment
extends SubCmd {
    private final String[] subCommands = new String[]{"slot", "swappable", "allowedentities", "equipsound", "equiponinteract", "dispensable", "damageonhurt", "cameraoverlay", "canshear", "shearsound", "clear", "model"};

    public Equipment(@NotNull ItemEditCommand command) {
        super("equipment", command, true, true);
    }

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull String alias, String[] args) {
        Player p = (Player)sender;
        ItemStack item = this.getItemInHand(p);
        if (args.length == 1) {
            this.onFail((CommandSender)p, alias);
            return;
        }
        switch (args[1].toLowerCase(Locale.ENGLISH)) {
            case "clear": {
                this.equipmentClear(p, item, alias, args);
                return;
            }
            case "slot": {
                this.equipmentSlot(p, item, alias, args);
                return;
            }
            case "swappable": {
                this.equipmentSwappable(p, item, alias, args);
                return;
            }
            case "allowedentities": {
                this.equipmentAllowedEntities(p, item, alias, args);
                return;
            }
            case "equipsound": {
                this.equipmentEquipSound(p, item, alias, args);
                return;
            }
            case "equiponinteract": {
                this.equipmentEquipOnInteract(p, item, alias, args);
                return;
            }
            case "dispensable": {
                this.equipmentDispensable(p, item, alias, args);
                return;
            }
            case "damageonhurt": {
                this.equipmentDamageOnHurt(p, item, alias, args);
                return;
            }
            case "cameraoverlay": {
                this.equipmentCameraOverlay(p, item, alias, args);
                return;
            }
            case "canshear": {
                this.equipmentCanShear(p, item, alias, args);
                return;
            }
            case "shearsound": {
                this.equipmentShearSound(p, item, alias, args);
                return;
            }
            case "model": {
                this.equipmentModel(p, item, alias, args);
                return;
            }
        }
        this.onFail((CommandSender)p, alias);
    }

    private void equipmentModel(Player p, ItemStack item, @NotNull String alias, String[] args) {
        try {
            if (args.length == 2) {
                ItemMeta meta = ItemUtils.getMeta(item);
                if (!meta.hasEquippable()) {
                    this.sendCustomFeedbackForSub((CommandSender)p, "model", "feedback-reset", new String[0]);
                    return;
                }
                EquippableComponent comp = meta.getEquippable();
                comp.setModel(null);
                meta.setEquippable(comp);
                item.setItemMeta(meta);
                this.updateView(p);
                this.sendCustomFeedbackForSub((CommandSender)p, "model", "feedback-reset", new String[0]);
                return;
            }
            if (args.length != 3) {
                throw new IllegalArgumentException("Wrong param number");
            }
            String[] rawKey = args[2].toLowerCase(Locale.ENGLISH).split(":");
            NamespacedKey key = rawKey.length == 1 ? new NamespacedKey("minecraft", rawKey[0]) : new NamespacedKey(rawKey[0], rawKey[1]);
            ItemMeta meta = ItemUtils.getMeta(item);
            EquippableComponent comp = meta.getEquippable();
            comp.setModel(key);
            meta.setEquippable(comp);
            item.setItemMeta(meta);
            this.updateView(p);
            this.sendFeedbackForSub((CommandSender)p, "model", "%key%", key.toString());
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.sendFailFeedbackForSub((CommandSender)p, alias, "model");
        }
    }

    private void equipmentShearSound(Player p, ItemStack item, String alias, String[] args) {
        try {
            Sound value;
            if (args.length != 2 && args.length != 3) {
                this.sendFailFeedbackForSub((CommandSender)p, alias, "shearsound");
                return;
            }
            ItemMeta meta = ItemUtils.getMeta(item);
            EquippableComponent comp = meta.getEquippable();
            Sound sound = value = args.length == 2 ? null : (Sound)Aliases.SOUND.convertAlias(args[2]);
            if (args.length == 3 && value == null) {
                this.onWrongAlias("wrong-sound", (CommandSender)p, Aliases.SOUND, new String[0]);
                this.sendFailFeedbackForSub((CommandSender)p, alias, "shearsound");
                return;
            }
            comp.setShearingSound(value);
            meta.setEquippable(comp);
            item.setItemMeta(meta);
            item.setItemMeta(meta);
            if (value != null) {
                this.sendFeedbackForSub((CommandSender)p, "shearsound", "%value%", args[2]);
            } else {
                this.sendCustomFeedbackForSub((CommandSender)p, "shearsound", "feedback-reset", new String[0]);
            }
        }
        catch (NoSuchMethodError e) {
            this.sendCustomFeedbackForSub((CommandSender)p, "canshear", "unsupported-version", "%value%", Bukkit.getVersion());
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.sendFailFeedbackForSub((CommandSender)p, alias, "shearsound");
        }
    }

    private void equipmentCanShear(Player p, ItemStack item, String alias, String[] args) {
        try {
            Boolean value;
            if (args.length != 2 && args.length != 3) {
                this.sendFailFeedbackForSub((CommandSender)p, alias, "canshear");
                return;
            }
            ItemMeta meta = ItemUtils.getMeta(item);
            EquippableComponent comp = meta.getEquippable();
            Boolean bl = args.length == 3 ? Aliases.BOOLEAN.convertAlias(args[2]) : (value = Boolean.valueOf(!comp.isCanBeSheared()));
            if (args.length == 3 && value == null) {
                this.onWrongAlias("wrong-boolean", (CommandSender)p, Aliases.BOOLEAN, new String[0]);
                this.sendFailFeedbackForSub((CommandSender)p, alias, "canshear");
                return;
            }
            comp.setCanBeSheared(value.booleanValue());
            meta.setEquippable(comp);
            item.setItemMeta(meta);
            this.sendFeedbackForSub((CommandSender)p, "canshear", "%value%", String.valueOf(value));
        }
        catch (NoSuchMethodError e) {
            this.sendCustomFeedbackForSub((CommandSender)p, "canshear", "unsupported-version", "%value%", Bukkit.getVersion());
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.sendFailFeedbackForSub((CommandSender)p, alias, "canshear");
        }
    }

    private void equipmentCameraOverlay(Player p, ItemStack item, String alias, String[] args) {
        try {
            NamespacedKey key;
            if (args.length != 2 && args.length != 3) {
                this.sendFailFeedbackForSub((CommandSender)p, alias, "cameraoverlay");
                return;
            }
            ItemMeta meta = ItemUtils.getMeta(item);
            EquippableComponent comp = meta.getEquippable();
            String rawkey = args.length == 2 ? null : args[2];
            NamespacedKey namespacedKey = key = rawkey == null ? null : NamespacedKey.fromString((String)rawkey);
            if (args.length == 3 && key == null) {
                this.sendCustomFeedbackForSub((CommandSender)p, "cameraoverlay", "invalid-namespacedkey", "%value%", args[2]);
                return;
            }
            comp.setCameraOverlay(key);
            meta.setEquippable(comp);
            item.setItemMeta(meta);
            if (key != null) {
                this.sendFeedbackForSub((CommandSender)p, "cameraoverlay", "%value%", key.toString());
            } else {
                this.sendCustomFeedbackForSub((CommandSender)p, "cameraoverlay", "feedback-reset", new String[0]);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.sendFailFeedbackForSub((CommandSender)p, alias, "cameraoverlay");
        }
    }

    private void equipmentDamageOnHurt(Player p, ItemStack item, String alias, String[] args) {
        try {
            String msg;
            Boolean value;
            if (args.length != 2 && args.length != 3) {
                this.sendFailFeedbackForSub((CommandSender)p, alias, "damageonhurt");
                return;
            }
            ItemMeta meta = ItemUtils.getMeta(item);
            EquippableComponent comp = meta.getEquippable();
            Boolean bl = args.length == 3 ? Aliases.BOOLEAN.convertAlias(args[2]) : (value = Boolean.valueOf(!comp.isDamageOnHurt()));
            if (args.length == 3 && value == null) {
                this.onWrongAlias("wrong-boolean", (CommandSender)p, Aliases.BOOLEAN, new String[0]);
                this.sendFailFeedbackForSub((CommandSender)p, alias, "damageonhurt");
                return;
            }
            comp.setDamageOnHurt(value.booleanValue());
            meta.setEquippable(comp);
            item.setItemMeta(meta);
            this.sendFeedbackForSub((CommandSender)p, "damageonhurt", "%value%", String.valueOf(value));
            if (value.booleanValue() && (meta.hasMaxStackSize() ? meta.getMaxStackSize() > 1 : item.getType().getMaxStackSize() > 1) && (msg = this.getLanguageString("damageonhurt.warning-maxstacksize", null, (CommandSender)p, new String[0])) != null && !msg.isEmpty()) {
                ComponentBuilder compMsg = new ComponentBuilder(msg).event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/" + alias + " maxstacksize 1"));
                Util.sendMessage((CommandSender)p, compMsg.create());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.sendFailFeedbackForSub((CommandSender)p, alias, "damageonhurt");
        }
    }

    private void equipmentDispensable(Player p, ItemStack item, String alias, String[] args) {
        try {
            Boolean value;
            if (args.length != 2 && args.length != 3) {
                this.sendFailFeedbackForSub((CommandSender)p, alias, "dispensable");
                return;
            }
            ItemMeta meta = ItemUtils.getMeta(item);
            EquippableComponent comp = meta.getEquippable();
            Boolean bl = args.length == 3 ? Aliases.BOOLEAN.convertAlias(args[2]) : (value = Boolean.valueOf(!comp.isDamageOnHurt()));
            if (args.length == 3 && value == null) {
                this.onWrongAlias("wrong-boolean", (CommandSender)p, Aliases.BOOLEAN, new String[0]);
                this.sendFailFeedbackForSub((CommandSender)p, alias, "dispensable");
                return;
            }
            comp.setDamageOnHurt(value.booleanValue());
            meta.setEquippable(comp);
            item.setItemMeta(meta);
            this.sendFeedbackForSub((CommandSender)p, "dispensable", "%value%", String.valueOf(value));
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.sendFailFeedbackForSub((CommandSender)p, alias, "dispensable");
        }
    }

    private void equipmentEquipOnInteract(Player p, ItemStack item, String alias, String[] args) {
        try {
            Boolean value;
            if (args.length != 2 && args.length != 3) {
                this.sendFailFeedbackForSub((CommandSender)p, alias, "equiponinteract");
                return;
            }
            ItemMeta meta = ItemUtils.getMeta(item);
            EquippableComponent comp = meta.getEquippable();
            Boolean bl = args.length == 3 ? Aliases.BOOLEAN.convertAlias(args[2]) : (value = Boolean.valueOf(!comp.isEquipOnInteract()));
            if (args.length == 3 && value == null) {
                this.onWrongAlias("wrong-boolean", (CommandSender)p, Aliases.BOOLEAN, new String[0]);
                this.sendFailFeedbackForSub((CommandSender)p, alias, "equiponinteract");
                return;
            }
            comp.setEquipOnInteract(value.booleanValue());
            meta.setEquippable(comp);
            item.setItemMeta(meta);
            this.sendFeedbackForSub((CommandSender)p, "equiponinteract", "%value%", String.valueOf(value));
        }
        catch (NoSuchMethodError e) {
            this.sendCustomFeedbackForSub((CommandSender)p, "canshear", "unsupported-version", "%value%", Bukkit.getVersion());
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.sendFailFeedbackForSub((CommandSender)p, alias, "equiponinteract");
        }
    }

    private void equipmentSwappable(Player p, ItemStack item, String alias, String[] args) {
        try {
            Boolean value;
            if (args.length != 2 && args.length != 3) {
                this.sendFailFeedbackForSub((CommandSender)p, alias, "swappable");
                return;
            }
            ItemMeta meta = ItemUtils.getMeta(item);
            EquippableComponent comp = meta.getEquippable();
            Boolean bl = args.length == 3 ? Aliases.BOOLEAN.convertAlias(args[2]) : (value = Boolean.valueOf(!comp.isSwappable()));
            if (args.length == 3 && value == null) {
                this.onWrongAlias("wrong-boolean", (CommandSender)p, Aliases.BOOLEAN, new String[0]);
                this.sendFailFeedbackForSub((CommandSender)p, alias, "swappable");
                return;
            }
            comp.setSwappable(value.booleanValue());
            meta.setEquippable(comp);
            item.setItemMeta(meta);
            this.sendFeedbackForSub((CommandSender)p, "swappable", "%value%", String.valueOf(value));
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.sendFailFeedbackForSub((CommandSender)p, alias, "swappable");
        }
    }

    private void equipmentAllowedEntities(Player p, ItemStack item, String alias, String[] args) {
        try {
            ItemMeta meta = ItemUtils.getMeta(item);
            EquippableComponent comp = meta.getEquippable();
            if (args.length == 2) {
                comp.setAllowedEntities((EntityType)null);
                meta.setEquippable(comp);
                item.setItemMeta(meta);
                this.sendCustomFeedbackForSub((CommandSender)p, "allowedentities", "feedback-reset", new String[0]);
                return;
            }
            HashSet<EntityType> types = new HashSet<EntityType>();
            for (String arg : Arrays.copyOfRange(args, 2, args.length)) {
                EntityType entity = Aliases.ENTITY_TYPE.convertAlias(arg);
                if (entity != null && entity.isAlive()) {
                    types.add(entity);
                    continue;
                }
                TagContainer<EntityType> tag = Aliases.ENTITY_GROUPS.convertAlias(arg);
                if (tag != null && tag.getValues().stream().anyMatch(EntityType::isAlive)) {
                    types.addAll(tag.getValues().stream().filter(EntityType::isAlive).collect(Collectors.toList()));
                    continue;
                }
                this.onWrongAlias("wrong-entitytype", (CommandSender)p, Aliases.ENTITY_TYPE, new String[0]);
                this.onWrongAlias("wrong-entitygroup", (CommandSender)p, Aliases.ENTITY_GROUPS, new String[0]);
                this.sendCustomFeedbackForSub((CommandSender)p, "allowedentities", "invalid-type", "%value%", arg);
                return;
            }
            comp.setAllowedEntities(types);
            meta.setEquippable(comp);
            item.setItemMeta(meta);
            this.sendFeedbackForSub((CommandSender)p, "allowedentities", "%value%", types.stream().map(Enum::name).collect(Collectors.joining(", ")));
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.sendFailFeedbackForSub((CommandSender)p, alias, "allowedentities");
        }
    }

    private void equipmentEquipSound(Player p, ItemStack item, String alias, String[] args) {
        try {
            Sound value;
            if (args.length != 2 && args.length != 3) {
                this.sendFailFeedbackForSub((CommandSender)p, alias, "equipsound");
                return;
            }
            ItemMeta meta = ItemUtils.getMeta(item);
            EquippableComponent comp = meta.getEquippable();
            Sound sound = value = args.length == 2 ? null : (Sound)Aliases.SOUND.convertAlias(args[2]);
            if (args.length == 3 && value == null) {
                this.onWrongAlias("wrong-sound", (CommandSender)p, Aliases.SOUND, new String[0]);
                this.sendFailFeedbackForSub((CommandSender)p, alias, "equipsound");
                return;
            }
            comp.setEquipSound(value);
            meta.setEquippable(comp);
            item.setItemMeta(meta);
            if (value != null) {
                this.sendFeedbackForSub((CommandSender)p, "equipsound", "%value%", args[2]);
            } else {
                this.sendCustomFeedbackForSub((CommandSender)p, "equipsound", "feedback-reset", new String[0]);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.sendFailFeedbackForSub((CommandSender)p, alias, "equipsound");
        }
    }

    private void equipmentSlot(Player p, ItemStack item, String alias, String[] args) {
        try {
            if (args.length != 3) {
                this.sendFailFeedbackForSub((CommandSender)p, alias, "slot");
                return;
            }
            ItemMeta meta = ItemUtils.getMeta(item);
            EquippableComponent comp = meta.getEquippable();
            EquipmentSlot slot = Aliases.EQUIPMENT_SLOTS.convertAlias(args[2]);
            if (slot == null) {
                this.onWrongAlias("wrong-slot", (CommandSender)p, Aliases.SOUND, new String[0]);
                this.sendFailFeedbackForSub((CommandSender)p, alias, "slot");
                return;
            }
            comp.setSlot(slot);
            meta.setEquippable(comp);
            item.setItemMeta(meta);
            this.sendFeedbackForSub((CommandSender)p, "slot", "%value%", args[2]);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.sendFailFeedbackForSub((CommandSender)p, alias, "slot");
        }
    }

    private void equipmentClear(Player p, ItemStack item, String alias, String[] args) {
        try {
            if (args.length != 2) {
                this.sendFailFeedbackForSub((CommandSender)p, alias, "clear");
                return;
            }
            ItemMeta meta = ItemUtils.getMeta(item);
            meta.setEquippable(null);
            item.setItemMeta(meta);
            this.sendFeedbackForSub((CommandSender)p, "clear", new String[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.sendFailFeedbackForSub((CommandSender)p, alias, "clear");
        }
    }

    @Override
    public void onFail(@NotNull CommandSender target, @NotNull String alias) {
        Util.sendMessage(target, new ComponentBuilder(this.getLanguageString("help-header", "", target, new String[0])).create());
        for (String sub : this.subCommands) {
            Util.sendMessage(target, new ComponentBuilder(ChatColor.DARK_GREEN + "/" + alias + " " + this.getName() + ChatColor.GREEN + " " + sub + " " + this.getLanguageString(sub + ".params", "", target, new String[0])).event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/" + alias + " " + this.getName() + " " + sub + " ")).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(String.join((CharSequence)"\n", this.getLanguageStringList(sub + ".description", null, target, new String[0])))})).create());
        }
    }

    @Override
    public List<String> onComplete(@NotNull CommandSender sender, String[] args) {
        switch (args.length) {
            case 2: {
                return CompleteUtility.complete(args[1], this.subCommands);
            }
            case 3: {
                switch (args[1].toLowerCase(Locale.ENGLISH)) {
                    case "slot": {
                        return CompleteUtility.complete(args[2], Aliases.EQUIPMENT_SLOTS);
                    }
                    case "swappable": 
                    case "dispensable": 
                    case "damageonhurt": 
                    case "equiponinteract": 
                    case "canshear": {
                        return CompleteUtility.complete(args[2], Aliases.BOOLEAN);
                    }
                    case "equipsound": 
                    case "shearsound": {
                        return CompleteUtility.complete(args[2], Aliases.SOUND);
                    }
                    case "allowedentities": {
                        List<String> res = CompleteUtility.complete(args[2], Aliases.ENTITY_TYPE, EntityType::isAlive);
                        res.addAll(CompleteUtility.complete(args[2], Aliases.ENTITY_GROUPS, tag -> tag.getValues().stream().anyMatch(EntityType::isAlive)));
                        return res;
                    }
                    case "cameraoverlay": {
                        return CompleteUtility.complete(args[2], "minecraft:misc/pumpkinblur");
                    }
                }
            }
        }
        if (args[1].equalsIgnoreCase("allowedentities")) {
            List<String> res = CompleteUtility.complete(args[args.length - 1], Aliases.ENTITY_TYPE, EntityType::isAlive);
            res.addAll(CompleteUtility.complete(args[args.length - 1], Aliases.ENTITY_GROUPS, tag -> tag.getValues().stream().anyMatch(EntityType::isAlive)));
            return res;
        }
        return Collections.emptyList();
    }
}

