/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.command.itemedit;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import emanondev.itemedit.ItemEdit;
import emanondev.itemedit.aliases.Aliases;
import emanondev.itemedit.command.ItemEditCommand;
import emanondev.itemedit.command.SubCmd;
import emanondev.itemedit.utility.CompleteUtility;
import emanondev.itemedit.utility.ItemUtils;
import emanondev.itemedit.utility.VersionUtils;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class Hide
extends SubCmd {
    public Hide(ItemEditCommand cmd) {
        super("hide", cmd, true, true);
    }

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull String alias, String[] args) {
        Player p = (Player)sender;
        ItemStack item = this.getItemInHand(p);
        try {
            if (args.length != 3 && args.length != 2) {
                throw new IllegalArgumentException("Wrong param number");
            }
            ItemMeta itemMeta = ItemUtils.getMeta(item);
            ItemFlag flag = Aliases.FLAG_TYPE.convertAlias(args[1]);
            if (flag == null) {
                this.onWrongAlias("wrong-flag", (CommandSender)p, Aliases.FLAG_TYPE, new String[0]);
                this.onFail((CommandSender)p, alias);
                return;
            }
            boolean add = args.length == 3 ? Aliases.BOOLEAN.convertAlias(args[2]) : !itemMeta.hasItemFlag(flag);
            this.handleFlagChange(add, flag, item, itemMeta);
            if (add) {
                itemMeta.addItemFlags(new ItemFlag[]{flag});
            } else {
                itemMeta.removeItemFlags(new ItemFlag[]{flag});
            }
            item.setItemMeta(itemMeta);
            this.updateView(p);
        }
        catch (Exception e) {
            this.onFail((CommandSender)p, alias);
        }
    }

    private void handleFlagChange(boolean put, ItemFlag flag, ItemStack item, ItemMeta meta) {
        if (!(VersionUtils.hasPaperAPI() && VersionUtils.isVersionAfter(1, 20, 5) && ItemEdit.get().getConfig().loadBoolean("itemedit.paper_hide_fix", true).booleanValue())) {
            return;
        }
        if (flag != ItemFlag.HIDE_ATTRIBUTES) {
            return;
        }
        if (put) {
            if (meta.getAttributeModifiers() != null) {
                return;
            }
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                item.getType().getDefaultAttributeModifiers(slot).forEach((arg_0, arg_1) -> ((ItemMeta)meta).addAttributeModifier(arg_0, arg_1));
            }
            return;
        }
        Multimap mods = meta.getAttributeModifiers();
        if (mods == null) {
            return;
        }
        HashMultimap mods2 = HashMultimap.create();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            mods2.putAll(item.getType().getDefaultAttributeModifiers(slot));
        }
        if (mods.equals((Object)mods2)) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                meta.removeAttributeModifier(slot);
            }
        }
    }

    @Override
    public List<String> onComplete(@NotNull CommandSender sender, String[] args) {
        if (args.length == 2) {
            return CompleteUtility.complete(args[1], Aliases.FLAG_TYPE);
        }
        if (args.length == 3) {
            return CompleteUtility.complete(args[2], Aliases.BOOLEAN);
        }
        return Collections.emptyList();
    }
}

