/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.command.itemedit;

import emanondev.itemedit.ItemEdit;
import emanondev.itemedit.Util;
import emanondev.itemedit.UtilsString;
import emanondev.itemedit.YMLConfig;
import emanondev.itemedit.command.ItemEditCommand;
import emanondev.itemedit.command.SubCmd;
import emanondev.itemedit.utility.CompleteUtility;
import emanondev.itemedit.utility.ItemUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class Lore
extends SubCmd {
    private static final String[] loreSub = new String[]{"add", "set", "remove", "reset", "insert", "copy", "copybook", "copyfile", "paste", "replace"};
    private final Map<UUID, List<String>> copies = new HashMap<UUID, List<String>>();
    private final YMLConfig loreCopy = ItemEdit.get().getConfig("loreCopy");
    private int lineLimit = this.getPlugin().getConfig().getInt("blocked.lore-line-limit", 16);
    private int lengthLimit = this.getPlugin().getConfig().getInt("blocked.lore-length-limit", 120);

    public Lore(ItemEditCommand cmd) {
        super("lore", cmd, true, true);
    }

    @Override
    public void reload() {
        super.reload();
        this.lineLimit = this.getPlugin().getConfig().getInt("blocked.lore-line-limit", 16);
        this.lengthLimit = this.getPlugin().getConfig().getInt("blocked.lore-length-limit", 120);
    }

    private boolean allowedLineLimit(Player who, int lines) {
        if (this.lineLimit < 0 || who.hasPermission("itemedit.bypass.lore_line_limit")) {
            return true;
        }
        return lines <= this.lineLimit;
    }

    private boolean allowedLengthLimit(Player who, String text) {
        if (this.lengthLimit < 0 || who.hasPermission("itemedit.bypass.lore_length_limit")) {
            return true;
        }
        return text.length() <= this.lengthLimit;
    }

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull String alias, String[] args) {
        Player p = (Player)sender;
        ItemStack item = this.getItemInHand(p);
        if (args.length == 1) {
            this.onFail((CommandSender)p, alias);
            return;
        }
        switch (args[1].toLowerCase(Locale.ENGLISH)) {
            case "set": {
                if (!Util.isAllowedChangeLore(sender, item.getType())) {
                    return;
                }
                this.loreSet(p, item, alias, args);
                return;
            }
            case "add": {
                if (!Util.isAllowedChangeLore(sender, item.getType())) {
                    return;
                }
                this.loreAdd(p, item, alias, args);
                return;
            }
            case "insert": {
                if (!Util.isAllowedChangeLore(sender, item.getType())) {
                    return;
                }
                this.loreInsert(p, item, alias, args);
                return;
            }
            case "reset": {
                if (!Util.isAllowedChangeLore(sender, item.getType())) {
                    return;
                }
                this.loreReset(p, item, alias, args);
                return;
            }
            case "remove": {
                if (!Util.isAllowedChangeLore(sender, item.getType())) {
                    return;
                }
                this.loreRemove(p, item, alias, args);
                return;
            }
            case "copy": {
                if (!sender.hasPermission(this.getPermission() + ".copy")) {
                    this.getCommand().sendPermissionLackMessage(this.getPermission() + ".copy", sender);
                    return;
                }
                this.loreCopy(p, item, alias, args);
                return;
            }
            case "copybook": {
                if (!sender.hasPermission(this.getPermission() + ".copy")) {
                    this.getCommand().sendPermissionLackMessage(this.getPermission() + ".copy", sender);
                    return;
                }
                this.loreCopyBook(p, item, alias, args);
                return;
            }
            case "copyfile": {
                if (!sender.hasPermission(this.getPermission() + ".copy")) {
                    this.getCommand().sendPermissionLackMessage(this.getPermission() + ".copy", sender);
                    return;
                }
                this.loreCopyFile(p, item, alias, args);
                return;
            }
            case "paste": {
                if (!sender.hasPermission(this.getPermission() + ".copy")) {
                    this.getCommand().sendPermissionLackMessage(this.getPermission() + ".copy", sender);
                    return;
                }
                if (!Util.isAllowedChangeLore(sender, item.getType())) {
                    return;
                }
                this.lorePaste(p, item, alias, args);
                return;
            }
            case "replace": {
                if (!Util.isAllowedChangeLore(sender, item.getType())) {
                    return;
                }
                this.loreReplace(p, item, alias, args);
                return;
            }
        }
        this.onFail((CommandSender)p, alias);
    }

    private void loreReplace(Player p, ItemStack item, String alias, String[] args) {
        try {
            String to;
            String from;
            if (args.length < 4) {
                this.sendFailFeedbackForSub((CommandSender)p, alias, "replace");
                return;
            }
            if (!item.hasItemMeta()) {
                return;
            }
            ItemMeta meta = ItemUtils.getMeta(item);
            if (!meta.hasLore()) {
                return;
            }
            List lore = meta.getLore();
            if (args.length == 4) {
                from = args[2];
                to = args[3];
            } else {
                StringBuilder raw = new StringBuilder();
                for (int i = 2; i < args.length; ++i) {
                    raw.append(" ").append(args[i]);
                }
                String rawText = raw.substring(1);
                int i1 = rawText.indexOf("{");
                if (i1 != 0) {
                    this.sendFailFeedbackForSub((CommandSender)p, alias, "replace");
                    return;
                }
                int i2 = rawText.indexOf("}", i1);
                if (i2 == -1) {
                    this.sendFailFeedbackForSub((CommandSender)p, alias, "replace");
                    return;
                }
                int i3 = rawText.indexOf("{", i2);
                if (i3 == -1 || i2 + 2 != i3) {
                    this.sendFailFeedbackForSub((CommandSender)p, alias, "replace");
                    return;
                }
                int i4 = rawText.indexOf("}", i3);
                if (i4 != rawText.length() - 1) {
                    this.sendFailFeedbackForSub((CommandSender)p, alias, "replace");
                    return;
                }
                from = rawText.substring(1, i2);
                to = rawText.substring(i3 + 1, i4);
            }
            from = UtilsString.fix(from, null, true, new String[0]);
            to = UtilsString.fix(to, null, true, new String[0]);
            for (String s : lore) {
                String text = s.replace(from, to);
                if (this.allowedLengthLimit(p, ChatColor.stripColor((String)text))) continue;
                Util.sendMessage((CommandSender)p, ItemEdit.get().getLanguageConfig((CommandSender)p).loadMessage("blocked-by-lore-length-limit", "", null, true, "%limit%", String.valueOf(this.lengthLimit)));
                return;
            }
            for (int i = 0; i < lore.size(); ++i) {
                lore.set(i, ((String)lore.get(i)).replace(from, to));
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
            this.updateView(p);
        }
        catch (Exception e) {
            this.sendFailFeedbackForSub((CommandSender)p, alias, "replace");
        }
    }

    private void lorePaste(Player p, ItemStack item, String alias, String[] args) {
        if (!this.copies.containsKey(p.getUniqueId())) {
            Util.sendMessage((CommandSender)p, this.getLanguageString("paste.no-copy", null, (CommandSender)p, new String[0]));
            return;
        }
        ItemMeta meta = ItemUtils.getMeta(item);
        meta.setLore(this.copies.get(p.getUniqueId()));
        item.setItemMeta(meta);
        Util.sendMessage((CommandSender)p, this.getLanguageString("paste.feedback", null, (CommandSender)p, new String[0]));
        this.updateView(p);
    }

    private void loreCopy(Player p, ItemStack item, String alias, String[] args) {
        ItemMeta itemMeta;
        ArrayList lore = item.hasItemMeta() ? ((itemMeta = ItemUtils.getMeta(item)).hasLore() ? new ArrayList(itemMeta.getLore()) : new ArrayList()) : new ArrayList();
        this.copies.put(p.getUniqueId(), lore);
        Util.sendMessage((CommandSender)p, this.getLanguageString("copy.feedback", null, (CommandSender)p, new String[0]));
    }

    private void loreCopyBook(Player p, ItemStack item, String alias, String[] args) {
        ArrayList<String> lore;
        if (item.hasItemMeta()) {
            ItemMeta itemMeta = ItemUtils.getMeta(item);
            if (!(itemMeta instanceof BookMeta)) {
                Util.sendMessage((CommandSender)p, this.getLanguageString("copyBook.wrong-type", null, (CommandSender)p, new String[0]));
                return;
            }
            BookMeta meta = (BookMeta)itemMeta;
            List pages = meta.getPages();
            lore = new ArrayList();
            if (pages != null) {
                for (String page : pages) {
                    if (page == null) continue;
                    lore.addAll(Arrays.asList(page.split("\n")));
                }
            }
        } else {
            lore = new ArrayList<String>();
        }
        for (int i = 0; i < lore.size(); ++i) {
            lore.set(i, Util.formatText((CommandSender)p, (String)lore.get(i), this.getPermission()));
        }
        this.copies.put(p.getUniqueId(), lore);
        Util.sendMessage((CommandSender)p, this.getLanguageString("copyBook.feedback", null, (CommandSender)p, new String[0]));
    }

    private void loreCopyFile(Player p, ItemStack item, String alias, String[] args) {
        if (args.length < 2) {
            Util.sendMessage((CommandSender)p, this.getLanguageString("copyFile.no-path", null, (CommandSender)p, new String[0]));
            return;
        }
        if (!this.loreCopy.contains(args[2])) {
            Util.sendMessage((CommandSender)p, this.getLanguageString("copyFile.wrong-path", null, (CommandSender)p, new String[0]));
            return;
        }
        ArrayList<String> lore = new ArrayList<String>(this.loreCopy.getStringList(args[2]));
        for (int i = 0; i < lore.size(); ++i) {
            lore.set(i, Util.formatText((CommandSender)p, (String)lore.get(i), this.getPermission()));
        }
        this.copies.put(p.getUniqueId(), lore);
        Util.sendMessage((CommandSender)p, this.getLanguageString("copyFile.feedback", null, (CommandSender)p, new String[0]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> onComplete(@NotNull CommandSender sender, String[] args) {
        switch (args.length) {
            case 2: {
                return CompleteUtility.complete(args[1], loreSub);
            }
            case 3: {
                switch (args[1].toLowerCase(Locale.ENGLISH)) {
                    case "remove": 
                    case "set": {
                        if (!(sender instanceof Player)) {
                            return Collections.emptyList();
                        }
                        Player player = (Player)sender;
                        ItemStack item = this.getItemInHand(player);
                        if (ItemUtils.isAirOrNull(item)) {
                            return Collections.emptyList();
                        }
                        if (!item.hasItemMeta()) {
                            return CompleteUtility.complete(args[2], Arrays.asList("1", "last"));
                        }
                        ItemMeta meta = ItemUtils.getMeta(item);
                        if (!meta.hasLore()) {
                            return CompleteUtility.complete(args[2], Arrays.asList("1", "last"));
                        }
                        ArrayList<String> list = new ArrayList<String>();
                        int i = 0;
                        while (true) {
                            if (i >= meta.getLore().size()) {
                                list.add("last");
                                return CompleteUtility.complete(args[2], list);
                            }
                            list.add(String.valueOf(i + 1));
                            ++i;
                        }
                    }
                    case "copyfile": {
                        return CompleteUtility.complete(args[2], this.loreCopy.getKeys(false));
                    }
                }
                return Collections.emptyList();
            }
            case 4: {
                switch (args[1].toLowerCase(Locale.ENGLISH)) {
                    case "set": {
                        ItemMeta meta;
                        ItemStack item;
                        if (!(sender instanceof Player) || (item = this.getItemInHand((Player)sender)) == null || !item.hasItemMeta() || !(meta = ItemUtils.getMeta(item)).hasLore()) return Collections.emptyList();
                        List lore = meta.getLore();
                        try {
                            int line;
                            int n = line = args[2].equalsIgnoreCase("last") ? lore.size() - 1 : Integer.parseInt(args[2]) - 1;
                            if (line < 0 || line >= lore.size()) return Collections.emptyList();
                            return CompleteUtility.complete(args[3], ((String)lore.get(line)).replace('\u00a7', '&'));
                        }
                        catch (NumberFormatException e) {
                            return Collections.emptyList();
                        }
                    }
                }
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    private void loreAdd(Player p, ItemStack item, String alias, String[] args) {
        ItemMeta itemMeta;
        ArrayList<String> lore;
        StringBuilder text = new StringBuilder();
        if (args.length > 2) {
            text = new StringBuilder(args[2]);
            for (int i = 3; i < args.length; ++i) {
                text.append(" ").append(args[i]);
            }
        }
        if (!this.allowedLineLimit(p, (lore = (itemMeta = ItemUtils.getMeta(item)).hasLore() ? new ArrayList(itemMeta.getLore()) : new ArrayList<String>()).size() + 1)) {
            Util.sendMessage((CommandSender)p, ItemEdit.get().getLanguageConfig((CommandSender)p).loadMessage("blocked-by-lore-line-limit", "", null, true, "%limit%", String.valueOf(this.lineLimit)));
            return;
        }
        String lineText = Util.formatText((CommandSender)p, text.toString(), this.getPermission());
        if (!this.allowedLengthLimit(p, ChatColor.stripColor((String)lineText))) {
            Util.sendMessage((CommandSender)p, ItemEdit.get().getLanguageConfig((CommandSender)p).loadMessage("blocked-by-lore-length-limit", "", null, true, "%limit%", String.valueOf(this.lengthLimit)));
            return;
        }
        if (Util.hasBannedWords(p, lineText)) {
            return;
        }
        lore.add(lineText);
        itemMeta.setLore(lore);
        item.setItemMeta(itemMeta);
        this.updateView(p);
    }

    private void loreInsert(Player p, ItemStack item, String alias, String[] args) {
        try {
            int line;
            if (args.length < 3) {
                throw new IllegalArgumentException("Wrong param number");
            }
            StringBuilder text = new StringBuilder();
            if (args.length > 3) {
                text = new StringBuilder(args[3]);
                for (int i = 4; i < args.length; ++i) {
                    text.append(" ").append(args[i]);
                }
            }
            if ((line = Integer.parseInt(args[2]) - 1) < 0) {
                throw new IllegalArgumentException("Wrong line number");
            }
            ItemMeta itemMeta = ItemUtils.getMeta(item);
            ArrayList<String> lore = itemMeta.hasLore() ? new ArrayList(itemMeta.getLore()) : new ArrayList<String>();
            if (!this.allowedLineLimit(p, Math.max(lore.size() + 1, line + 1))) {
                Util.sendMessage((CommandSender)p, ItemEdit.get().getLanguageConfig((CommandSender)p).loadMessage("blocked-by-lore-line-limit", "", null, true, "%limit%", String.valueOf(this.lineLimit)));
                return;
            }
            String lineText = Util.formatText((CommandSender)p, text.toString(), this.getPermission());
            if (!this.allowedLengthLimit(p, ChatColor.stripColor((String)lineText))) {
                Util.sendMessage((CommandSender)p, ItemEdit.get().getLanguageConfig((CommandSender)p).loadMessage("blocked-by-lore-length-limit", "", null, true, "%limit%", String.valueOf(this.lengthLimit)));
                return;
            }
            for (int i = lore.size(); i < line; ++i) {
                lore.add("");
            }
            if (Util.hasBannedWords(p, lineText)) {
                return;
            }
            lore.add(line, lineText);
            itemMeta.setLore(lore);
            item.setItemMeta(itemMeta);
            this.updateView(p);
        }
        catch (Exception e) {
            this.sendFailFeedbackForSub((CommandSender)p, alias, "insert");
        }
    }

    private void loreSet(Player p, ItemStack item, String alias, String[] args) {
        try {
            int line;
            if (args.length < 3) {
                throw new IllegalArgumentException("Wrong param number");
            }
            StringBuilder text = new StringBuilder();
            if (args.length > 3) {
                text = new StringBuilder(args[3]);
                for (int i = 4; i < args.length; ++i) {
                    text.append(" ").append(args[i]);
                }
            }
            String lineText = Util.formatText((CommandSender)p, text.toString(), this.getPermission());
            ItemMeta itemMeta = ItemUtils.getMeta(item);
            ArrayList<String> lore = itemMeta.hasLore() ? new ArrayList(itemMeta.getLore()) : new ArrayList<String>();
            int n = line = args[2].equalsIgnoreCase("last") ? lore.size() - 1 : Integer.parseInt(args[2]) - 1;
            if (line < 0) {
                throw new IllegalArgumentException("Wrong line number");
            }
            if (lore.size() <= line && !this.allowedLineLimit(p, line + 1)) {
                Util.sendMessage((CommandSender)p, ItemEdit.get().getLanguageConfig((CommandSender)p).loadMessage("blocked-by-lore-line-limit", "", null, true, "%limit%", String.valueOf(this.lineLimit)));
                return;
            }
            if (!this.allowedLengthLimit(p, ChatColor.stripColor((String)lineText))) {
                Util.sendMessage((CommandSender)p, ItemEdit.get().getLanguageConfig((CommandSender)p).loadMessage("blocked-by-lore-length-limit", "", null, true, "%limit%", String.valueOf(this.lengthLimit)));
                return;
            }
            for (int i = lore.size(); i <= line; ++i) {
                lore.add("");
            }
            if (Util.hasBannedWords(p, lineText)) {
                return;
            }
            lore.set(line, lineText);
            itemMeta.setLore(lore);
            item.setItemMeta(itemMeta);
            this.updateView(p);
        }
        catch (Exception e) {
            this.sendFailFeedbackForSub((CommandSender)p, alias, "set");
        }
    }

    private void loreRemove(Player p, ItemStack item, String alias, String[] args) {
        try {
            if (args.length < 3) {
                throw new IllegalArgumentException("Wrong param number");
            }
            if (!item.hasItemMeta()) {
                return;
            }
            ItemMeta itemMeta = ItemUtils.getMeta(item);
            if (!itemMeta.hasLore() || itemMeta.getLore().isEmpty()) {
                return;
            }
            ArrayList lore = new ArrayList(itemMeta.getLore());
            int line = args[2].equalsIgnoreCase("last") ? lore.size() - 1 : Integer.parseInt(args[2]) - 1;
            if (line < 0) {
                throw new IllegalArgumentException("Wrong line number");
            }
            if (lore.size() < line) {
                return;
            }
            lore.remove(line);
            itemMeta.setLore(lore);
            item.setItemMeta(itemMeta);
            this.updateView(p);
        }
        catch (Exception e) {
            this.sendFailFeedbackForSub((CommandSender)p, alias, "remove");
        }
    }

    private void loreReset(Player p, ItemStack item, String alias, String[] args) {
        ItemMeta meta = ItemUtils.getMeta(item);
        meta.setLore(null);
        item.setItemMeta(meta);
        this.updateView(p);
    }
}

