/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.command.itemedit;

import emanondev.itemedit.Util;
import emanondev.itemedit.UtilLegacy;
import emanondev.itemedit.aliases.Aliases;
import emanondev.itemedit.command.ItemEditCommand;
import emanondev.itemedit.command.SubCmd;
import emanondev.itemedit.utility.CompleteUtility;
import emanondev.itemedit.utility.ItemUtils;
import emanondev.itemedit.utility.VersionUtils;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SuspiciousStewMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class PotionEffectEditor
extends SubCmd {
    private static final String[] subCommands = new String[]{"add", "remove", "reset"};

    public PotionEffectEditor(ItemEditCommand cmd) {
        super("potioneffect", cmd, true, true);
    }

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull String alias, String[] args) {
        Player p = (Player)sender;
        ItemStack item = this.getItemInHand(p);
        if (!(ItemUtils.getMeta(item) instanceof PotionMeta || !VersionUtils.isVersionUpTo(1, 14) && ItemUtils.getMeta(item) instanceof SuspiciousStewMeta)) {
            String msg;
            Util.sendMessage((CommandSender)p, this.getLanguageString("wrong-type", null, sender, new String[0]));
            if (p.hasPermission("itemedit.admin") && (msg = this.getLanguageString("itemtag-tip", null, sender, new String[0])) != null && !msg.isEmpty()) {
                Util.sendMessage((CommandSender)p, new ComponentBuilder(msg).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(String.join((CharSequence)"\n", this.getLanguageStringList("itemtag-tip-hover", null, (CommandSender)p, new String[0]))).create())).event(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://modrinth.com/plugin/itemtag")).create());
            }
            return;
        }
        try {
            if (args.length < 2) {
                throw new IllegalArgumentException("Wrong param number");
            }
            switch (args[1].toLowerCase(Locale.ENGLISH)) {
                case "reset": {
                    this.potioneffectClear(p, item, alias, args);
                    return;
                }
                case "add": {
                    this.potioneffectAdd(p, item, alias, args);
                    return;
                }
                case "remove": {
                    this.potioneffectRemove(p, item, alias, args);
                    return;
                }
            }
            throw new IllegalArgumentException();
        }
        catch (Exception e) {
            this.onFail((CommandSender)p, alias);
            return;
        }
    }

    @Override
    public List<String> onComplete(@NotNull CommandSender sender, String[] args) {
        switch (args.length) {
            case 2: {
                return CompleteUtility.complete(args[1], subCommands);
            }
            case 3: {
                if (args[1].equalsIgnoreCase("add") || args[1].equalsIgnoreCase("remove")) {
                    return CompleteUtility.complete(args[2], Aliases.POTION_EFFECT);
                }
                return Collections.emptyList();
            }
            case 4: {
                if (args[1].equalsIgnoreCase("add")) {
                    return CompleteUtility.complete(args[3], "infinite", "instant", "\u221e", "90", "180", "480");
                }
                return Collections.emptyList();
            }
            case 5: {
                if (args[1].equalsIgnoreCase("add")) {
                    return CompleteUtility.complete(args[4], "1", "2", "3");
                }
                return Collections.emptyList();
            }
            case 6: 
            case 7: {
                if (args[1].equalsIgnoreCase("add")) {
                    return CompleteUtility.complete(args[args.length - 1], Aliases.BOOLEAN);
                }
                return Collections.emptyList();
            }
            case 8: {
                if (VersionUtils.isVersionAfter(1, 13) && args[1].equalsIgnoreCase("add")) {
                    return CompleteUtility.complete(args[args.length - 1], Aliases.BOOLEAN);
                }
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    private void potioneffectRemove(Player p, ItemStack item, String alias, String[] args) {
        try {
            if (args.length != 3) {
                throw new IllegalArgumentException("Wrong param number");
            }
            PotionEffectType effect = Aliases.POTION_EFFECT.convertAlias(args[2].toUpperCase());
            if (effect == null) {
                this.onWrongAlias("wrong-effect", (CommandSender)p, Aliases.POTION_EFFECT, new String[0]);
                this.sendFailFeedbackForSub((CommandSender)p, alias, "remove");
                return;
            }
            ItemMeta rawMeta = ItemUtils.getMeta(item);
            if (rawMeta instanceof PotionMeta) {
                PotionMeta meta = (PotionMeta)rawMeta;
                meta.removeCustomEffect(effect);
                item.setItemMeta((ItemMeta)meta);
            } else {
                SuspiciousStewMeta meta = (SuspiciousStewMeta)rawMeta;
                meta.removeCustomEffect(effect);
                item.setItemMeta((ItemMeta)meta);
            }
            this.updateView(p);
        }
        catch (Exception e) {
            this.sendFailFeedbackForSub((CommandSender)p, alias, "remove");
        }
    }

    private void potioneffectAdd(Player p, ItemStack item, String alias, String[] args) {
        try {
            ItemMeta rawMeta;
            if (args.length != 4 && args.length != 5 && args.length != 6 && args.length != 7 && args.length != 8) {
                throw new IllegalArgumentException("Wrong param number");
            }
            int level = 0;
            PotionEffectType effect = Aliases.POTION_EFFECT.convertAlias(args[2]);
            if (effect == null) {
                this.onWrongAlias("wrong-effect", (CommandSender)p, Aliases.POTION_EFFECT, new String[0]);
                this.sendFailFeedbackForSub((CommandSender)p, alias, "add");
                return;
            }
            int duration = UtilLegacy.readPotionEffectDurationSecondsToTicks(args[3]);
            if (args.length >= 5 && ((level = Integer.parseInt(args[4]) - 1) < 0 || level > 127)) {
                throw new IllegalArgumentException();
            }
            boolean particles = true;
            if (args.length >= 6) {
                particles = Aliases.BOOLEAN.convertAlias(args[5]);
            }
            boolean ambient = false;
            if (args.length >= 7) {
                ambient = Aliases.BOOLEAN.convertAlias(args[6]);
            }
            boolean icon = true;
            if (VersionUtils.isVersionAfter(1, 13) && args.length == 8) {
                icon = Aliases.BOOLEAN.convertAlias(args[7]);
            }
            if (!p.hasPermission(this.getPermission() + ".bypass_limits")) {
                level = Math.min(level, 1);
            }
            if ((rawMeta = ItemUtils.getMeta(item)) instanceof PotionMeta) {
                PotionMeta meta = (PotionMeta)rawMeta;
                if (VersionUtils.isVersionAfter(1, 13)) {
                    meta.addCustomEffect(new PotionEffect(effect, duration, level, ambient, particles, icon), true);
                } else {
                    meta.addCustomEffect(new PotionEffect(effect, duration, level, ambient, particles), true);
                }
                item.setItemMeta((ItemMeta)meta);
            } else {
                SuspiciousStewMeta meta = (SuspiciousStewMeta)rawMeta;
                meta.addCustomEffect(new PotionEffect(effect, duration, level, ambient, particles, icon), true);
                item.setItemMeta((ItemMeta)meta);
            }
            this.updateView(p);
        }
        catch (Exception e) {
            this.sendFailFeedbackForSub((CommandSender)p, alias, "add");
        }
    }

    private void potioneffectClear(Player p, ItemStack item, String alias, String[] args) {
        try {
            ItemMeta rawMeta = ItemUtils.getMeta(item);
            if (rawMeta instanceof PotionMeta) {
                PotionMeta meta = (PotionMeta)rawMeta;
                meta.clearCustomEffects();
                item.setItemMeta((ItemMeta)meta);
            } else {
                SuspiciousStewMeta meta = (SuspiciousStewMeta)rawMeta;
                meta.clearCustomEffects();
                item.setItemMeta((ItemMeta)meta);
            }
            this.updateView(p);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

