/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.command.itemedit;

import emanondev.itemedit.ItemEdit;
import emanondev.itemedit.Util;
import emanondev.itemedit.command.ItemEditCommand;
import emanondev.itemedit.command.SubCmd;
import emanondev.itemedit.utility.CompleteUtility;
import emanondev.itemedit.utility.ItemUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class Rename
extends SubCmd {
    private final Map<UUID, String> copies = new HashMap<UUID, String>();
    private int lengthLimit = this.getPlugin().getConfig().getInt("blocked.rename-length-limit", 120);

    public Rename(@NotNull ItemEditCommand cmd) {
        super("rename", cmd, true, true);
    }

    @Override
    public void reload() {
        super.reload();
        this.lengthLimit = this.getPlugin().getConfig().getInt("blocked.rename-length-limit", 120);
    }

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull String alias, String[] args) {
        Player p = (Player)sender;
        ItemStack item = this.getItemInHand(p);
        if (!Util.isAllowedRenameItem(sender, item.getType())) {
            return;
        }
        ItemMeta itemMeta = ItemUtils.getMeta(item);
        if (args.length == 1) {
            itemMeta.setDisplayName(" ");
            item.setItemMeta(itemMeta);
            this.updateView(p);
            return;
        }
        if (args.length == 2 && args[1].equalsIgnoreCase("-clear")) {
            itemMeta.setDisplayName(null);
            item.setItemMeta(itemMeta);
            this.updateView(p);
            return;
        }
        if (args.length == 2 && args[1].equalsIgnoreCase("-copy")) {
            this.copies.put(p.getUniqueId(), itemMeta.getDisplayName());
            this.updateView(p);
            return;
        }
        if (args.length == 2 && args[1].equalsIgnoreCase("-paste")) {
            itemMeta.setDisplayName(this.copies.get(p.getUniqueId()));
            item.setItemMeta(itemMeta);
            this.updateView(p);
            return;
        }
        StringBuilder bname = new StringBuilder(args[1]);
        for (int i = 2; i < args.length; ++i) {
            bname.append(" ").append(args[i]);
        }
        String name = Util.formatText((CommandSender)p, bname.toString(), this.getPermission());
        if (Util.hasBannedWords(p, name)) {
            return;
        }
        if (!this.allowedLengthLimit(p, ChatColor.stripColor((String)name))) {
            Util.sendMessage((CommandSender)p, ItemEdit.get().getLanguageConfig((CommandSender)p).loadMessage("blocked-by-rename-length-limit", "", null, true, "%limit%", String.valueOf(this.lengthLimit)));
            return;
        }
        itemMeta.setDisplayName(name);
        item.setItemMeta(itemMeta);
        this.updateView(p);
    }

    @Override
    public List<String> onComplete(@NotNull CommandSender sender, String[] args) {
        ItemMeta meta;
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        if (args.length != 2) {
            return Collections.emptyList();
        }
        ItemStack item = this.getItemInHand((Player)sender);
        if (item != null && item.hasItemMeta() && (meta = ItemUtils.getMeta(item)).hasDisplayName()) {
            return CompleteUtility.complete(args[1], meta.getDisplayName().replace('\u00a7', '&'), "-clear", "-paste", "-copy");
        }
        return Collections.emptyList();
    }

    private boolean allowedLengthLimit(Player who, String text) {
        if (this.lengthLimit < 0 || who.hasPermission("itemedit.bypass.rename_length_limit")) {
            return true;
        }
        return text.length() <= this.lengthLimit;
    }
}

