/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.command.itemedit;

import emanondev.itemedit.aliases.Aliases;
import emanondev.itemedit.command.ItemEditCommand;
import emanondev.itemedit.command.SubCmd;
import emanondev.itemedit.utility.CompleteUtility;
import emanondev.itemedit.utility.ItemUtils;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class Unbreakable
extends SubCmd {
    public Unbreakable(ItemEditCommand cmd) {
        super("unbreakable", cmd, true, true);
    }

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull String alias, String[] args) {
        Player p = (Player)sender;
        ItemStack item = this.getItemInHand(p);
        if (args.length > 2) {
            this.onFail((CommandSender)p, alias);
            return;
        }
        try {
            ItemMeta meta = ItemUtils.getMeta(item);
            boolean value = args.length == 2 ? Aliases.BOOLEAN.convertAlias(args[1]) : !ItemUtils.isUnbreakable(meta);
            ItemUtils.setUnbreakable(meta, value);
            item.setItemMeta(meta);
            this.updateView(p);
        }
        catch (Exception e) {
            this.onFail((CommandSender)p, alias);
        }
    }

    @Override
    public List<String> onComplete(@NotNull CommandSender sender, String[] args) {
        if (args.length == 2) {
            return CompleteUtility.complete(args[1], Aliases.BOOLEAN);
        }
        return Collections.emptyList();
    }
}

