/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.compability;

import emanondev.itemedit.ItemEdit;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ISkillMechanic;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.bukkit.BukkitAdapter;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

class DropServerItemMechanic
implements ISkillMechanic,
ITargetedEntitySkill,
ITargetedLocationSkill {
    private final String id;
    private final int amount;
    private final int diff;
    private final double chance;

    public DropServerItemMechanic(MythicLineConfig mlc) {
        this.id = mlc.getString(new String[]{"id", "name", "type", "serveritem"}, null, new String[0]);
        if (this.id == null) {
            ItemEdit.get().log("&9[&fMythicMobs&9] &fMissing item id on mechanic, use {&eid&f='<your_id>' ....}");
            throw new IllegalArgumentException();
        }
        if (ItemEdit.get().getServerStorage().getItem(this.id) == null) {
            ItemEdit.get().log("&9[&fMythicMobs&9] &fInvalid id, '" + this.id + "' is not a registered serveritem");
            throw new IllegalArgumentException();
        }
        this.amount = mlc.getInteger(new String[]{"amount", "a"}, 1);
        this.diff = mlc.getInteger(new String[]{"amountmax", "amount-max", "amax"}, this.amount) - this.amount;
        this.chance = mlc.getDouble(new String[]{"chance", "c"}, 1.0);
        if (this.chance <= 0.0) {
            ItemEdit.get().log("&9[&fMythicMobs&9] &fInvalid chance, should be from ]0 to 1]");
            throw new IllegalArgumentException();
        }
        if (this.amount <= 0) {
            ItemEdit.get().log("&9[&fMythicMobs&9] &fInvalid amount, should be from [1 to +inf[");
            throw new IllegalArgumentException();
        }
        if (this.diff < 0) {
            ItemEdit.get().log("&9[&fMythicMobs&9] &fInvalid max amount, should be from [amount to +inf[");
            throw new IllegalArgumentException();
        }
    }

    public ThreadSafetyLevel getThreadSafetyLevel() {
        return ThreadSafetyLevel.SYNC_ONLY;
    }

    public SkillResult castAtEntity(SkillMetadata data, final AbstractEntity target) {
        if (Math.random() > this.chance) {
            return SkillResult.CONDITION_FAILED;
        }
        if (Bukkit.isPrimaryThread()) {
            this.drop(target.getLocation());
        } else {
            new BukkitRunnable(){

                public void run() {
                    DropServerItemMechanic.this.drop(target.getLocation());
                }
            }.runTask((Plugin)ItemEdit.get());
        }
        return SkillResult.SUCCESS;
    }

    public void drop(AbstractLocation location) {
        Location loc = BukkitAdapter.adapt((AbstractLocation)location);
        ItemStack item = ItemEdit.get().getServerStorage().getItem(this.id);
        if (item == null) {
            ItemEdit.get().log("&9[&fMythicMobs&9] &fInvalid id, '" + this.id + "' is not a registered serveritem");
            return;
        }
        item.setAmount((int)((double)this.amount + Math.random() * (double)this.diff));
        loc.getWorld().dropItem(loc, item);
    }

    public SkillResult castAtLocation(SkillMetadata data, final AbstractLocation location) {
        if (Math.random() > this.chance) {
            return SkillResult.CONDITION_FAILED;
        }
        if (Bukkit.isPrimaryThread()) {
            this.drop(location);
        } else {
            new BukkitRunnable(){

                public void run() {
                    DropServerItemMechanic.this.drop(location);
                }
            }.runTask((Plugin)ItemEdit.get());
        }
        return SkillResult.SUCCESS;
    }
}

