/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.compability;

import emanondev.itemedit.compability.MiniMessagePaper;
import emanondev.itemedit.compability.MiniMessageUtil;
import emanondev.itemedit.utility.VersionUtils;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Hooks {
    private static final MiniMessageUtil miniMessage = Hooks.initMiniMessage();

    public static boolean isVault() {
        return Hooks.isEnabled("Vault");
    }

    public static boolean isVanishEnabled() {
        return Hooks.isEnabled("SuperVanish") || Hooks.isEnabled("PremiumVanish");
    }

    public static boolean isPAPIEnabled() {
        return Hooks.isEnabled("PlaceholderAPI");
    }

    public static boolean isNBTAPIEnabled() {
        return Hooks.isEnabled("NBTAPI");
    }

    public static boolean isShopGuiPlusEnabled() {
        return Hooks.isEnabled("ShopGuiPlus");
    }

    public static boolean isEnabled(@NotNull String pluginName) {
        return Bukkit.getPluginManager().isPluginEnabled(pluginName);
    }

    public static Plugin getPlugin(@NotNull String pluginName) {
        return Bukkit.getPluginManager().getPlugin(pluginName);
    }

    public static String getPluginVersion(@NotNull String pluginName) {
        return Hooks.getPluginVersion(pluginName, null);
    }

    public static String getPluginVersion(@NotNull String pluginName, @Nullable String ifMissing) {
        Plugin plugin = Hooks.getPlugin(pluginName);
        if (plugin == null) {
            return ifMissing;
        }
        return plugin.getDescription().getVersion();
    }

    public static boolean isMythicMobsEnabled() {
        return Hooks.isEnabled("MythicMobs");
    }

    public static boolean isItemBridgeEnabled() {
        return Hooks.isEnabled("ItemBridge");
    }

    public static boolean isDungeonMMOEnabled() {
        return Hooks.isEnabled("DungeonMMO");
    }

    private static MiniMessageUtil initMiniMessage() {
        try {
            MiniMessagePaper inst;
            if (VersionUtils.hasPaperAPI() && VersionUtils.isVersionAfter(1, 16, 5) && !(inst = MiniMessagePaper.getInstance()).fromMiniToText("<red>this is a test</red>").equals("<red>this is a test</red>")) {
                return inst;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static boolean hasMiniMessage() {
        return miniMessage != null;
    }

    public static MiniMessageUtil getMiniMessageUtil() {
        return miniMessage;
    }
}

