/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.compability;

import emanondev.itemedit.ItemEdit;
import emanondev.itemedit.utility.ItemUtils;
import emanondev.itemedit.utility.VersionUtils;
import java.util.Locale;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class Placeholders
extends PlaceholderExpansion {
    public Placeholders() {
        ItemEdit.get().log("placeholders:");
        ItemEdit.get().log("  &e%itemedit_amount_&6<{itemid}>&e_&6[{slot}]&e_&6[{player}]&e%");
        ItemEdit.get().log("    shows how many &6itemid player &fhas on &6slot");
        ItemEdit.get().log("    <{itemid}> for item id on serveritem");
        ItemEdit.get().log("    [{slot}] for the slot where the item should be counted, by default &ainventory");
        ItemEdit.get().log("      Values: &einventory&f (include offhand), &eequip&f (include offhand), &einventoryandequip&f (include offhand), &ehand&f, &eoffhand&f, &ehead&f, &echest&f, &elegs&f, &efeet");
        ItemEdit.get().log("    [{player}] for the player, by default &aself");
        ItemEdit.get().log("    example: %itemedit_amount_{&6my_item_id&f}_{&6hand&f}%");
    }

    @NotNull
    public String getAuthor() {
        return "emanon";
    }

    @NotNull
    public String getIdentifier() {
        return "itemedit";
    }

    public String getRequiredPlugin() {
        return ItemEdit.get().getName();
    }

    @NotNull
    public String getVersion() {
        return "1.0";
    }

    public String onPlaceholderRequest(Player player, @NotNull String value) {
        if (player == null) {
            return "";
        }
        try {
            String[] args = value.split("_");
            switch (args[0].toLowerCase(Locale.ENGLISH)) {
                case "amount": {
                    return this.amount(player, value.substring("amount_".length()));
                }
            }
            throw new IllegalStateException();
        }
        catch (Exception e) {
            ItemEdit.get().log("&c! &fWrong PlaceHolderValue %" + this.getIdentifier() + "_" + ChatColor.YELLOW + value + ChatColor.WHITE + "% " + e.getMessage());
            return null;
        }
    }

    private String amount(Player player, String value) {
        String slot = "inventory";
        int amount = 0;
        int indexStart = value.indexOf("{");
        int indexEnd = value.indexOf("}", indexStart);
        if (indexStart != 0 || indexEnd == -1) {
            throw new IllegalStateException("item id not closed inside { }");
        }
        String id = value.substring(indexStart + 1, indexEnd);
        ItemStack item = ItemEdit.get().getServerStorage().getItem(id, player);
        if (item == null) {
            throw new IllegalStateException("item id '" + id + "' is invalid or doesn't exist");
        }
        if (!(value = value.substring(indexEnd + 1)).isEmpty()) {
            indexStart = value.indexOf("{");
            indexEnd = value.indexOf("}");
            if (indexStart != 1) {
                throw new IllegalStateException("bad formatting");
            }
            if (indexEnd == -1) {
                throw new IllegalStateException("slot value not closed inside { }");
            }
            slot = value.substring(indexStart + 1, indexEnd).toLowerCase(Locale.ENGLISH);
            ItemEdit.get().log(id + " " + slot + " " + player.getName());
            value = value.substring(indexEnd + 1);
            indexStart = value.indexOf("{", indexEnd);
            indexEnd = value.indexOf("}", indexStart);
            if (indexStart > indexEnd) {
                throw new IllegalStateException();
            }
            if (indexStart != -1) {
                player = Bukkit.getPlayer((String)value.substring(indexStart + 1, indexEnd));
            }
            if (player == null) {
                throw new IllegalStateException();
            }
        }
        switch (slot.toLowerCase(Locale.ENGLISH)) {
            case "main_hand": 
            case "mainhand": 
            case "hand": {
                ItemStack copy = ItemUtils.getHandItem(player);
                if (!item.isSimilar(copy)) break;
                amount += copy.getAmount();
                break;
            }
            case "off_hand": 
            case "offhand": {
                ItemStack copy = player.getEquipment().getItemInOffHand();
                if (!item.isSimilar(copy)) break;
                amount += copy.getAmount();
                break;
            }
            case "legs": {
                ItemStack copy = player.getEquipment().getLeggings();
                if (!item.isSimilar(copy)) break;
                amount += copy.getAmount();
                break;
            }
            case "chest": {
                ItemStack copy = player.getEquipment().getChestplate();
                if (!item.isSimilar(copy)) break;
                amount += copy.getAmount();
                break;
            }
            case "head": {
                ItemStack copy = player.getEquipment().getHelmet();
                if (!item.isSimilar(copy)) break;
                amount += copy.getAmount();
                break;
            }
            case "feet": {
                ItemStack copy = player.getEquipment().getBoots();
                if (!item.isSimilar(copy)) break;
                amount += copy.getAmount();
                break;
            }
            case "inventory": {
                for (ItemStack copy : player.getInventory().getStorageContents()) {
                    if (!item.isSimilar(copy)) continue;
                    amount += copy.getAmount();
                }
                if (!VersionUtils.isVersionAfter(1, 9) || !item.isSimilar(player.getInventory().getItemInOffHand())) break;
                amount += player.getInventory().getItemInOffHand().getAmount();
                break;
            }
            case "equip": {
                for (ItemStack copy : player.getInventory().getArmorContents()) {
                    if (!item.isSimilar(copy)) continue;
                    amount += copy.getAmount();
                }
                if (!VersionUtils.isVersionAfter(1, 9) || !item.isSimilar(player.getInventory().getItemInOffHand())) break;
                amount += player.getInventory().getItemInOffHand().getAmount();
                break;
            }
            case "inventoryandequip": {
                for (ItemStack copy : player.getInventory().getStorageContents()) {
                    if (!item.isSimilar(copy)) continue;
                    amount += copy.getAmount();
                }
                for (ItemStack copy : player.getInventory().getArmorContents()) {
                    if (!item.isSimilar(copy)) continue;
                    amount += copy.getAmount();
                }
                if (!VersionUtils.isVersionAfter(1, 9) || !item.isSimilar(player.getInventory().getItemInOffHand())) break;
                amount += player.getInventory().getItemInOffHand().getAmount();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return String.valueOf(amount);
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }
}

