/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.storage;

import emanondev.itemedit.ItemEdit;
import java.util.Set;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PlayerStorage {
    @Nullable
    public ItemStack getItem(@NotNull OfflinePlayer var1, @NotNull String var2);

    public void setItem(@NotNull OfflinePlayer var1, @NotNull String var2, @NotNull ItemStack var3);

    public void remove(@NotNull OfflinePlayer var1, @NotNull String var2);

    public void clear(@NotNull OfflinePlayer var1);

    @NotNull
    public Set<String> getIds(@NotNull OfflinePlayer var1);

    @NotNull
    public Set<OfflinePlayer> getPlayers();

    default public boolean storeByUUID() {
        return ItemEdit.get().getConfig().loadBoolean("storage.store-by-uuid", true);
    }

    default public void validateID(@Nullable String id) {
        if (id == null || id.contains(" ") || id.contains(".") || id.isEmpty()) {
            throw new IllegalArgumentException();
        }
    }

    default public void reload() {
    }
}

