/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.storage.mongo;

import com.mongodb.CursorType;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.UpdateOptions;
import emanondev.itemedit.storage.PlayerStorage;
import emanondev.itemedit.storage.mongo.MongoStorage;
import emanondev.itemedit.utility.ItemUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MongoPlayerStorage
implements PlayerStorage {
    @NotNull
    private final MongoStorage mongoStorage;
    @NotNull
    private final Logger logger;

    public MongoPlayerStorage(@NotNull MongoStorage mongoStorage, @NotNull Logger logger) {
        this.mongoStorage = mongoStorage;
        this.logger = logger;
    }

    private String getStore(OfflinePlayer player) {
        return this.storeByUUID() ? player.getUniqueId().toString() : player.getName();
    }

    @Override
    @Nullable
    public ItemStack getItem(@NotNull OfflinePlayer player, @NotNull String id) {
        this.validateID(id);
        id = id.toLowerCase(Locale.ENGLISH);
        Document document = (Document)this.mongoStorage.getPlayerStorage().find(Filters.eq((String)"store", (Object)this.getStore(player))).cursorType(CursorType.NonTailable).first();
        if (document == null) {
            return null;
        }
        Map serializedItem = (Map)document.get((Object)("items." + id), Document.class);
        if (serializedItem == null) {
            return null;
        }
        ItemStack item = ItemStack.deserialize((Map)serializedItem);
        return item.clone();
    }

    @Override
    public void setItem(@NotNull OfflinePlayer player, @NotNull String id, @NotNull ItemStack item) {
        this.validateID(id);
        id = id.toLowerCase(Locale.ENGLISH);
        if (ItemUtils.isAirOrNull(item)) {
            throw new IllegalArgumentException();
        }
        item.setAmount(1);
        Map serializedItem = item.serialize();
        String store = this.getStore(player);
        this.mongoStorage.getPlayerStorage().updateOne(Filters.eq((String)"store", (Object)store), (Bson)new Document().append("$setOnInsert", (Object)new Document("store", (Object)store)).append("$set", (Object)new Document("items." + id, (Object)serializedItem)), new UpdateOptions().upsert(true));
    }

    @Override
    public void remove(@NotNull OfflinePlayer player, @NotNull String id) {
        this.validateID(id);
        id = id.toLowerCase(Locale.ENGLISH);
        this.mongoStorage.getPlayerStorage().updateOne(Filters.eq((String)"store", (Object)this.getStore(player)), (Bson)new Document("$unset", (Object)new Document("items." + id, (Object)"")));
    }

    @Override
    public void clear(@NotNull OfflinePlayer player) {
        String store = this.getStore(player);
        this.mongoStorage.getPlayerStorage().deleteOne(Filters.eq((String)"store", (Object)store));
    }

    @Override
    @NotNull
    public Set<String> getIds(@NotNull OfflinePlayer player) {
        Document document = (Document)this.mongoStorage.getPlayerStorage().find(Filters.eq((String)"store", (Object)this.getStore(player))).cursorType(CursorType.NonTailable).first();
        if (document == null) {
            return Collections.emptySet();
        }
        Document itemsDocument = (Document)document.get((Object)"items", Document.class);
        return itemsDocument != null ? itemsDocument.keySet() : Collections.emptySet();
    }

    @Override
    @NotNull
    public Set<OfflinePlayer> getPlayers() {
        Set playerData = (Set)this.mongoStorage.getPlayerStorage().find().cursorType(CursorType.NonTailable).projection(Projections.include((String[])new String[]{"store"})).map(document -> document.getString((Object)"store")).into(new HashSet());
        HashSet<OfflinePlayer> players = new HashSet<OfflinePlayer>();
        boolean uuid = this.storeByUUID();
        for (String store : playerData) {
            UUID uniqueId;
            try {
                uniqueId = uuid ? UUID.fromString(store) : null;
            }
            catch (IllegalArgumentException e) {
                this.logger.log(Level.SEVERE, "Failed to validate uuid " + store + ", skipped player.", e);
                continue;
            }
            players.add(uuid ? Bukkit.getOfflinePlayer((UUID)uniqueId) : Bukkit.getOfflinePlayer((String)store));
        }
        return players;
    }
}

