/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.storage.mongo;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import org.bson.Document;
import org.jetbrains.annotations.NotNull;

public class MongoStorage {
    @NotNull
    private final MongoDatabase mongoDatabase;
    @NotNull
    private final MongoClient mongoClient;
    @NotNull
    private final String collectionPrefix;

    public MongoStorage(@NotNull String connectionString, @NotNull String database, @NotNull String collectionPrefix) {
        this.mongoClient = MongoClients.create((String)connectionString);
        this.mongoDatabase = this.mongoClient.getDatabase(database);
        this.collectionPrefix = collectionPrefix;
    }

    public void close() {
        this.mongoClient.close();
    }

    @NotNull
    public MongoCollection<Document> getPlayerStorage() {
        return this.mongoDatabase.getCollection(this.collectionPrefix + "player-storage");
    }

    @NotNull
    public MongoCollection<Document> getServerStorage() {
        return this.mongoDatabase.getCollection(this.collectionPrefix + "server-storage");
    }
}

