/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.storage.yaml;

import emanondev.itemedit.ItemEdit;
import emanondev.itemedit.YMLConfig;
import emanondev.itemedit.storage.ServerStorage;
import emanondev.itemedit.utility.ItemUtils;
import emanondev.itemedit.utility.VersionUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YmlServerStorage
implements ServerStorage {
    private final YMLConfig database = ItemEdit.get().getConfig("database" + File.separatorChar + "server-database.yml");
    private final Map<ItemStack, String> reversedMap = VersionUtils.hasFoliaAPI() ? new ConcurrentHashMap() : new HashMap();

    public YmlServerStorage() {
        this.reload();
    }

    @Override
    public ItemStack getItem(@NotNull String id) {
        this.validateID(id);
        id = id.toLowerCase(Locale.ENGLISH);
        ItemStack item = this.database.getItemStack(id + ".item", null);
        return item == null ? null : item.clone();
    }

    @Override
    public String getNick(@NotNull String id) {
        this.validateID(id);
        id = id.toLowerCase(Locale.ENGLISH);
        String nick = this.database.getMessage(id + ".nick", null, true, new String[0]);
        if (nick != null) {
            return nick;
        }
        if (!this.database.contains(id)) {
            return null;
        }
        ItemStack item = this.getItem(id);
        if (!item.hasItemMeta()) {
            return item.getType().name().toLowerCase(Locale.ENGLISH);
        }
        ItemMeta meta = ItemUtils.getMeta(item);
        if (!meta.hasDisplayName()) {
            return item.getType().name().toLowerCase(Locale.ENGLISH);
        }
        return meta.getDisplayName();
    }

    @Override
    public void remove(@NotNull String id) {
        this.validateID(id);
        id = id.toLowerCase(Locale.ENGLISH);
        this.reversedMap.remove(this.getItem(id));
        this.database.set(id, null);
        this.database.save();
    }

    @Override
    public void clear() {
        for (String key : this.database.getKeys(false)) {
            this.database.set(key, null);
        }
        this.reversedMap.clear();
        this.database.save();
    }

    @Override
    @NotNull
    public Set<String> getIds() {
        return this.database.getKeys(false);
    }

    @Override
    public void setItem(@NotNull String id, @NotNull ItemStack item) {
        this.validateID(id);
        id = id.toLowerCase(Locale.ENGLISH);
        if (ItemUtils.isAirOrNull(item)) {
            throw new IllegalArgumentException();
        }
        item.setAmount(1);
        this.database.set(id + ".item", item);
        this.reversedMap.put(item, id);
        this.database.save();
    }

    @Override
    public void setNick(@NotNull String id, String nick) {
        this.validateID(id);
        if (!this.database.contains(id)) {
            return;
        }
        id = id.toLowerCase(Locale.ENGLISH);
        this.database.set(id + ".nick", nick);
        this.database.save();
    }

    @Override
    @Nullable
    public String getId(ItemStack item) {
        if (item == null) {
            return null;
        }
        int amount = item.getAmount();
        if (item.getAmount() != 1) {
            item.setAmount(1);
        }
        String id = this.reversedMap.get(item);
        if (amount != 1) {
            item.setAmount(amount);
        }
        return id;
    }

    @Override
    public void reload() {
        this.reversedMap.clear();
        for (String id : this.database.getKeys(false)) {
            try {
                this.validateID(id);
            }
            catch (Exception e) {
                continue;
            }
            this.reversedMap.put(this.database.getItemStack(id + ".item", null), id);
        }
    }
}

