/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.utility;

import emanondev.itemedit.ItemEdit;
import emanondev.itemedit.utility.ReflectionUtils;
import emanondev.itemedit.utility.SchedulerUtils;
import emanondev.itemedit.utility.VersionUtils;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public final class InventoryUtils {
    private static final Map<Class<?>, Method> getTopInventory = VersionUtils.hasFoliaAPI() ? new ConcurrentHashMap() : new HashMap();
    private static final Map<Class<?>, Method> getBottomInventory = VersionUtils.hasFoliaAPI() ? new ConcurrentHashMap() : new HashMap();
    private static final Set<EquipmentSlot> playerEquipmentSlots = InventoryUtils.loadPlayerEquipmentSlot();

    private InventoryUtils() {
        throw new UnsupportedOperationException();
    }

    public static Inventory getTopInventory(@NotNull InventoryEvent event) {
        if (VersionUtils.isVersionAfter(1, 21)) {
            return event.getView().getTopInventory();
        }
        return InventoryUtils.getTopInventoryP(event.getView());
    }

    public static Inventory getTopInventory(@NotNull Player player) {
        if (VersionUtils.isVersionAfter(1, 21)) {
            return player.getOpenInventory().getTopInventory();
        }
        return InventoryUtils.getTopInventoryP(player.getOpenInventory());
    }

    private static Inventory getTopInventoryP(@NotNull Object view) {
        Method method = getTopInventory.get(view.getClass());
        if (method == null) {
            method = ReflectionUtils.getMethod(view.getClass(), "getTopInventory", new Class[0]);
            getTopInventory.put(view.getClass(), method);
        }
        return (Inventory)ReflectionUtils.invokeMethod(view, method, new Object[0]);
    }

    public static Inventory getBottomInventory(@NotNull InventoryEvent event) {
        if (VersionUtils.isVersionAfter(1, 21)) {
            return event.getView().getBottomInventory();
        }
        return InventoryUtils.getBottomInventoryP(event.getView());
    }

    private static Inventory getBottomInventoryP(@NotNull Object view) {
        Method method = getBottomInventory.get(view.getClass());
        if (method == null) {
            method = ReflectionUtils.getMethod(view.getClass(), "getBottomInventory", new Class[0]);
            getBottomInventory.put(view.getClass(), method);
        }
        return (Inventory)ReflectionUtils.invokeMethod(view, method, new Object[0]);
    }

    public static void updateView(@NotNull Player player) {
        SchedulerUtils.run((Plugin)ItemEdit.get(), player, () -> ((Player)player).updateInventory());
    }

    public static void updateViewDelayed(@NotNull Player player) {
        SchedulerUtils.runLater((Plugin)ItemEdit.get(), player, 1L, () -> ((Player)player).updateInventory());
    }

    public static int giveAmount(@NotNull HumanEntity player, @NotNull ItemStack item, @Range(from=0L, to=0x7FFFFFFFL) int amount, @NotNull ExcessMode mode) {
        int remains;
        ItemStack itemClone = item.clone();
        if (amount == 0) {
            return 0;
        }
        for (remains = amount; remains > 0; remains -= Math.min(itemClone.getMaxStackSize(), remains)) {
            itemClone.setAmount(Math.min(itemClone.getMaxStackSize(), remains));
            HashMap map = player.getInventory().addItem(new ItemStack[]{itemClone});
            if (map.isEmpty()) continue;
            remains += ((ItemStack)map.get(0)).getAmount();
            break;
        }
        if (player instanceof Player) {
            InventoryUtils.updateViewDelayed((Player)player);
        }
        if (remains == 0) {
            return amount;
        }
        switch (mode.ordinal()) {
            case 1: {
                return amount - remains;
            }
            case 0: {
                while (remains > 0) {
                    int drop = Math.min(remains, 64);
                    itemClone.setAmount(drop);
                    ItemStack itemCopy = new ItemStack(itemClone);
                    Location loc = player.getEyeLocation();
                    SchedulerUtils.run((Plugin)ItemEdit.get(), loc, () -> player.getWorld().dropItem(loc, itemCopy));
                    remains -= drop;
                }
                return amount;
            }
            case 2: {
                InventoryUtils.removeAmount(player, itemClone, amount - remains, LackMode.REMOVE_MAX_POSSIBLE);
                return 0;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static int removeAmount(@NotNull HumanEntity player, @NotNull ItemStack item, @Range(from=0L, to=0x7FFFFFFFL) int amount, @NotNull LackMode mode) {
        ItemStack itemClone = item.clone();
        if (amount == 0) {
            return 0;
        }
        if (player instanceof Player) {
            InventoryUtils.updateViewDelayed((Player)player);
        }
        switch (mode.ordinal()) {
            case 0: {
                itemClone.setAmount(amount);
                HashMap map = player.getInventory().removeItem(new ItemStack[]{itemClone});
                if (map.isEmpty()) {
                    return amount;
                }
                int left = ((ItemStack)map.get(0)).getAmount();
                if (VersionUtils.isVersionAfter(1, 9)) {
                    ItemStack[] extras = player.getInventory().getExtraContents();
                    for (int i = 0; i < extras.length; ++i) {
                        ItemStack extra = extras[i];
                        if (extra == null || !itemClone.isSimilar(extra)) continue;
                        int toRemove = Math.min(left, extra.getAmount());
                        left -= toRemove;
                        if (toRemove == extra.getAmount()) {
                            extras[i] = null;
                            continue;
                        }
                        extra.setAmount(extra.getAmount() - toRemove);
                        extras[i] = extra;
                    }
                    player.getInventory().setExtraContents(extras);
                }
                return amount - left;
            }
            case 1: {
                if (player.getInventory().containsAtLeast(itemClone, amount)) {
                    itemClone.setAmount(amount);
                    HashMap map = player.getInventory().removeItem(new ItemStack[]{itemClone});
                    if (map.isEmpty()) {
                        return amount;
                    }
                    return amount - ((ItemStack)map.get(0)).getAmount();
                }
                return 0;
            }
        }
        throw new UnsupportedOperationException();
    }

    private static Set<EquipmentSlot> loadPlayerEquipmentSlot() {
        EnumSet<EquipmentSlot> slots = EnumSet.noneOf(EquipmentSlot.class);
        slots.add(EquipmentSlot.HEAD);
        slots.add(EquipmentSlot.CHEST);
        slots.add(EquipmentSlot.LEGS);
        slots.add(EquipmentSlot.FEET);
        slots.add(EquipmentSlot.HAND);
        try {
            slots.add(EquipmentSlot.valueOf((String)"OFF_HAND"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Collections.unmodifiableSet(slots);
    }

    @NotNull
    public static Set<EquipmentSlot> getPlayerEquipmentSlots() {
        return playerEquipmentSlots;
    }

    @Nullable
    public static ItemStack getItem(@NotNull Player player, @NotNull EquipmentSlot slot) {
        try {
            return player.getInventory().getItem(slot);
        }
        catch (Throwable throwable) {
            EntityEquipment equip = player.getEquipment();
            if (equip != null) {
                switch (slot.name()) {
                    case "HAND": {
                        return equip.getItemInHand();
                    }
                    case "LEGS": {
                        return equip.getLeggings();
                    }
                    case "CHEST": {
                        return equip.getChestplate();
                    }
                    case "HEAD": {
                        return equip.getHelmet();
                    }
                    case "FEET": {
                        return equip.getBoots();
                    }
                    case "OFF_HAND": {
                        return equip.getItemInOffHand();
                    }
                }
                throw new UnsupportedOperationException();
            }
            return null;
        }
    }

    public static enum ExcessMode {
        DROP_EXCESS,
        DELETE_EXCESS,
        CANCEL;

    }

    public static enum LackMode {
        REMOVE_MAX_POSSIBLE,
        CANCEL;

    }
}

