/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.utility;

import emanondev.itemedit.utility.ReflectionUtils;
import emanondev.itemedit.utility.VersionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.banner.PatternType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemUtils {
    private ItemUtils() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static ItemMeta getMeta(@NotNull ItemStack item) {
        return Objects.requireNonNull(item.getItemMeta(), "ItemMeta cannot be null");
    }

    @NotNull
    public static ItemStack getHandItem(@NotNull Player player) {
        return player.getInventory().getItemInHand();
    }

    public static void setHandItem(@NotNull Player player, @Nullable ItemStack item) {
        player.getInventory().setItemInHand(item);
    }

    @Contract(value="null -> true")
    public static boolean isAirOrNull(@Nullable ItemStack item) {
        return item == null || item.getType() == Material.AIR;
    }

    public static boolean isUnbreakable(@NotNull ItemStack item) {
        return ItemUtils.isUnbreakable(ItemUtils.getMeta(item));
    }

    public static boolean isUnbreakable(@Nullable ItemMeta meta) {
        if (meta == null) {
            return false;
        }
        if (VersionUtils.isVersionAfter(1, 11)) {
            return meta.isUnbreakable();
        }
        Object spigotMeta = Objects.requireNonNull(ReflectionUtils.invokeMethod(meta, "spigot"));
        Boolean result = (Boolean)ReflectionUtils.invokeMethod(spigotMeta, "isUnbreakable");
        return result != null && result != false;
    }

    public static void setUnbreakable(@NotNull ItemStack item, boolean value) {
        ItemMeta meta = ItemUtils.getMeta(item);
        ItemUtils.setUnbreakable(meta, value);
        item.setItemMeta(meta);
    }

    public static void setUnbreakable(@Nullable ItemMeta meta, boolean value) {
        if (meta == null) {
            return;
        }
        if (VersionUtils.isVersionAfter(1, 11)) {
            meta.setUnbreakable(value);
            return;
        }
        Object spigotMeta = Objects.requireNonNull(ReflectionUtils.invokeMethod(meta, "spigot"));
        ReflectionUtils.invokeMethod(spigotMeta, "setUnbreakable", Boolean.TYPE, value);
    }

    public static AttributeModifier createAttributeModifier(double amount, @NotNull AttributeModifier.Operation operation, @Nullable String slot) {
        if (VersionUtils.isVersionAfter(1, 20, 6)) {
            EquipmentSlotGroup group;
            if (slot == null) {
                group = EquipmentSlotGroup.ANY;
            } else {
                group = EquipmentSlotGroup.getByName((String)slot.toUpperCase(Locale.ENGLISH));
                if (group == null) {
                    group = EquipmentSlot.valueOf((String)slot.toUpperCase(Locale.ENGLISH)).getGroup();
                }
            }
            if (VersionUtils.isVersionAfter(1, 21, 2)) {
                return new AttributeModifier(Objects.requireNonNull(NamespacedKey.fromString((String)UUID.randomUUID().toString())), amount, operation, group);
            }
            UUID uuid = UUID.randomUUID();
            return ReflectionUtils.invokeConstructor(AttributeModifier.class, UUID.class, uuid, String.class, uuid.toString(), Double.TYPE, amount, AttributeModifier.Operation.class, operation, EquipmentSlotGroup.class, group);
        }
        UUID uuid = UUID.randomUUID();
        if (VersionUtils.isVersionAfter(1, 13, 2)) {
            return ReflectionUtils.invokeConstructor(AttributeModifier.class, UUID.class, uuid, String.class, uuid.toString(), Double.TYPE, amount, AttributeModifier.Operation.class, operation, EquipmentSlot.class, slot == null ? null : EquipmentSlot.valueOf((String)slot.toUpperCase(Locale.ENGLISH)));
        }
        return ReflectionUtils.invokeConstructor(AttributeModifier.class, UUID.class, uuid, String.class, uuid.toString(), Double.TYPE, amount, AttributeModifier.Operation.class, operation);
    }

    public static PatternType[] getPatternTypes() {
        try {
            if (VersionUtils.isVersionAfter(1, 20, 6)) {
                ArrayList result = new ArrayList();
                Registry.BANNER_PATTERN.forEach(result::add);
                return result.toArray(new PatternType[0]);
            }
        }
        catch (Throwable result) {
            // empty catch block
        }
        PatternType[] result = Objects.requireNonNull((PatternType[])ReflectionUtils.invokeStaticMethod(PatternType.class, "values", new Object[0]));
        return Arrays.copyOfRange(result, 1, result.length);
    }

    public static PatternType[] getPatternTypesFiltered() {
        PatternType[] val = ItemUtils.getPatternTypes();
        ArrayList<PatternType> list = new ArrayList<PatternType>(Arrays.asList(val));
        list.remove(PatternType.BASE);
        if (VersionUtils.isVersionAfter(1, 20, 6) && !VersionUtils.isVersionAfter(1, 21)) {
            list.remove(PatternType.FLOW);
            list.remove(PatternType.GUSTER);
        }
        return list.toArray(new PatternType[0]);
    }

    public static boolean isItem(@NotNull Material material) {
        if (VersionUtils.isVersionUpTo(1, 12, 99)) {
            return true;
        }
        if (material.name().startsWith("LEGACY_")) {
            return false;
        }
        return material.isItem();
    }

    public static ItemMeta setColor(@NotNull ItemMeta meta, @NotNull Color color) {
        if (meta instanceof PotionMeta) {
            ((PotionMeta)meta).setColor(color);
            return meta;
        }
        try {
            if (meta instanceof LeatherArmorMeta) {
                LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)meta;
                leatherArmorMeta.setColor(color);
                return meta;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return meta;
    }

    public static Color getColor(@NotNull ItemMeta meta) {
        if (meta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)meta;
            return potionMeta.getColor() == null ? ItemUtils.toColor(65, 85, 255) : potionMeta.getColor();
        }
        try {
            if (meta instanceof LeatherArmorMeta) {
                LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)meta;
                leatherArmorMeta.getColor();
                return leatherArmorMeta.getColor();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ItemUtils.toColor(0, 0, 0);
    }

    private static Color toColor(int red, int green, int blue) {
        return Color.fromRGB((int)ItemUtils.limit(red), (int)ItemUtils.limit(green), (int)ItemUtils.limit(blue));
    }

    private static int limit(int color) {
        return Math.max(0, Math.min(255, color));
    }
}

