/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit;

import emanondev.itemedit.compability.Hooks;
import emanondev.itemedit.utility.ItemUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UtilsString {
    private UtilsString() {
        throw new UnsupportedOperationException();
    }

    public static void updateDescription(@Nullable ItemStack item, @Nullable List<String> desc, @Nullable Player p, boolean color, String ... holders) {
        ArrayList<String> lore;
        String title;
        if (item == null) {
            return;
        }
        if (desc == null || desc.isEmpty()) {
            title = " ";
            lore = null;
        } else if (desc.size() == 1) {
            title = desc.get(0) != null ? (!desc.get(0).startsWith(ChatColor.RESET + "") ? ChatColor.RESET + desc.get(0) : desc.get(0)) : null;
            lore = null;
        } else {
            title = !desc.get(0).startsWith(ChatColor.RESET + "") ? ChatColor.RESET + desc.get(0) : desc.get(0);
            lore = new ArrayList();
            for (int i = 1; i < desc.size(); ++i) {
                if (desc.get(i) != null) {
                    if (!desc.get(i).startsWith(ChatColor.RESET + "")) {
                        lore.add(ChatColor.RESET + desc.get(i));
                        continue;
                    }
                    lore.add(desc.get(i));
                    continue;
                }
                lore.add("");
            }
        }
        title = UtilsString.fix(title, p, color, holders);
        lore = UtilsString.fix(lore, p, color, holders);
        ItemMeta meta = ItemUtils.getMeta(item);
        meta.setDisplayName(title);
        meta.setLore(lore);
        item.setItemMeta(meta);
    }

    @Contract(value="!null, _, _, _ -> !null")
    @Nullable
    public static ArrayList<String> fix(@Nullable List<String> list, @Nullable Player player, boolean color, String ... holders) {
        if (list == null) {
            return null;
        }
        ArrayList<String> newList = new ArrayList<String>();
        for (String line : list) {
            newList.add(UtilsString.fix(line, player, color, holders));
        }
        return newList;
    }

    public static ItemStack setDescription(@Nullable ItemStack item, @Nullable List<String> description, @Nullable Player player, boolean color, String ... holders) {
        if (ItemUtils.isAirOrNull(item)) {
            return null;
        }
        ItemStack itemCopy = new ItemStack(item);
        UtilsString.updateDescription(itemCopy, description, player, color, holders);
        return itemCopy;
    }

    @Contract(value="!null, _, _, _ -> !null")
    public static String fix(@Nullable String text, @Nullable Player player, boolean color, String ... holders) {
        if (text == null) {
            return null;
        }
        if (holders != null && holders.length % 2 != 0) {
            throw new IllegalArgumentException("holder without replacer");
        }
        if (holders != null && holders.length > 0) {
            for (int i = 0; i < holders.length; i += 2) {
                text = text.replace(holders[i], holders[i + 1]);
            }
        }
        if (player != null && Hooks.isPAPIEnabled()) {
            text = PlaceholderAPI.setPlaceholders((Player)player, (String)text);
        }
        if (Hooks.hasMiniMessage()) {
            text = Hooks.getMiniMessageUtil().fromMiniToText(text);
        }
        if (color) {
            text = ChatColor.translateAlternateColorCodes((char)'&', (String)text);
        }
        return text;
    }

    @Contract(value="!null -> !null")
    @Nullable
    public static String revertColors(@Nullable String text) {
        if (text == null) {
            return null;
        }
        return text.replace("\u00a7", "&");
    }

    @Contract(value="!null -> !null")
    @Nullable
    public static String clearColors(@Nullable String text) {
        if (text == null) {
            return null;
        }
        return ChatColor.stripColor((String)text);
    }

    @NotNull
    public static String formatNumber(double value, int decimals, boolean optional) {
        DecimalFormat df = new DecimalFormat("0");
        df.setMaximumFractionDigits(decimals);
        df.setMinimumFractionDigits(optional ? 0 : decimals);
        return df.format(value);
    }
}

