/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit;

import emanondev.itemedit.UtilsString;
import emanondev.itemedit.utility.VersionUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YMLConfig
extends YamlConfiguration {
    private final JavaPlugin plugin;
    private final File file;
    private final String fileName;
    private boolean multiThreadSupport = false;

    public YMLConfig(@NotNull JavaPlugin plugin, @NotNull String fileName) {
        this.plugin = plugin;
        this.fileName = fileName = YMLConfig.fixName(fileName);
        this.file = new File(plugin.getDataFolder(), fileName);
        this.reload();
        if (VersionUtils.hasFoliaAPI()) {
            this.multiThreadSupport = true;
        }
    }

    public static String fixName(@NotNull String name) {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("YAML file must have a name!");
        }
        if (!name.endsWith(".yml")) {
            name = name + ".yml";
        }
        return name;
    }

    public boolean reload() {
        boolean existed = this.file.exists();
        if (!this.file.exists()) {
            if (!this.file.getParentFile().exists() && !this.file.getParentFile().mkdirs()) {
                new Exception("unable to create parent folder").printStackTrace();
            }
            if (this.plugin.getResource(this.fileName.replace('\\', '/')) != null) {
                this.plugin.saveResource(this.fileName, true);
            } else {
                try {
                    if (!this.file.createNewFile()) {
                        new Exception("unable to create file").printStackTrace();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            this.load(this.file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        InputStream resource = this.plugin.getResource(this.fileName.replace('\\', '/'));
        if (resource != null) {
            this.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(resource, StandardCharsets.UTF_8)));
        }
        return existed;
    }

    public void save() {
        try {
            this.save(this.file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @NotNull
    public Set<String> getKeys(@NotNull String path) {
        ConfigurationSection section = this.getConfigurationSection(path);
        if (section == null) {
            return new LinkedHashSet<String>();
        }
        return section.getKeys(false);
    }

    @Contract(value="_, !null, _ -> !null")
    public <T> T load(String path, T def, Class<T> clazz) {
        Object value = this.get(path, null);
        if (value == null) {
            Object object = value = this.getDefaults() == null ? null : this.getDefaults().get(path);
            if (value == null) {
                if (def == null) {
                    return null;
                }
                this.set(path, def);
                this.save();
                return def;
            }
            if (!clazz.isInstance(value)) {
                this.set(path, def);
                this.save();
                return def;
            }
            this.set(path, value);
            this.save();
            return (T)value;
        }
        if (!clazz.isInstance(value)) {
            this.set(path, def);
            this.save();
            return def;
        }
        return (T)value;
    }

    @Contract(value="_, !null, _ -> !null")
    public <T> T get(String path, T def, Class<T> clazz) {
        Object value = this.get(path);
        if (value == null) {
            return def;
        }
        if (!clazz.isInstance(value)) {
            return def;
        }
        return (T)value;
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    public Double loadDouble(@NotNull String path, @Nullable Double def) {
        Number val = this.load(path, def, Number.class);
        return val == null ? null : Double.valueOf(val.doubleValue());
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    public Boolean loadBoolean(@NotNull String path, @Nullable Boolean def) {
        return this.load(path, def, Boolean.class);
    }

    @Deprecated
    public int loadInt(@NotNull String path, @Nullable Integer def) {
        Number val = this.load(path, def, Number.class);
        return val == null ? 0 : val.intValue();
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    public Integer loadInteger(@NotNull String path, @Nullable Integer def) {
        Number val = this.load(path, def, Number.class);
        return val == null ? null : Integer.valueOf(val.intValue());
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    public Integer getInteger(@NotNull String path, @Nullable Integer def) {
        Number val = this.load(path, def, Number.class);
        return val == null ? null : Integer.valueOf(val.intValue());
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    public Long loadLong(@NotNull String path, @Nullable Long def) {
        Number val = this.load(path, def, Number.class);
        return val == null ? null : Long.valueOf(val.longValue());
    }

    @Contract(value="_, !null, _, _ -> !null")
    @Nullable
    public String loadMessage(@NotNull String path, @Nullable String def, boolean color, String ... args) {
        return this.loadMessage(path, def, null, color, args);
    }

    @Contract(value="_, !null, _ -> !null")
    @Nullable
    public String loadMessage(@NotNull String path, @Nullable String def, String ... args) {
        return this.loadMessage(path, def, null, true, args);
    }

    @Contract(value="_, !null, _, _, _ -> !null")
    @Nullable
    public String loadMessage(@NotNull String path, @Nullable String def, @Nullable Player target, boolean color, String ... args) {
        if (args.length > 0 && VersionUtils.isVersionAfter(1, 18, 1) && this.getComments(path).isEmpty()) {
            StringBuilder build = new StringBuilder();
            for (int i = 0; i < args.length; i += 2) {
                build.append(args[i]).append(" ");
            }
            this.setComments(path, Collections.singletonList(build.substring(0, build.length() - 1)));
        }
        return UtilsString.fix(this.load(path, def, String.class), target, color, args);
    }

    @Contract(value="_, !null, _, _, _ -> !null")
    @Nullable
    public String getMessage(@NotNull String path, @Nullable String def, @Nullable Player target, boolean color, String ... args) {
        if (args.length > 0 && VersionUtils.isVersionAfter(1, 18, 1) && this.getComments(path).isEmpty()) {
            StringBuilder build = new StringBuilder();
            for (int i = 0; i < args.length; i += 2) {
                build.append(args[i]).append(" ");
            }
            this.setComments(path, Collections.singletonList(build.substring(0, build.length() - 1)));
        }
        return UtilsString.fix(this.get(path, def, String.class), target, color, args);
    }

    @Contract(value="_, !null, _, _ -> !null")
    @Nullable
    public String getMessage(@NotNull String path, @Nullable String def, boolean color, String ... args) {
        return this.getMessage(path, def, null, color, args);
    }

    @Contract(value="_, !null, _ -> !null")
    @Nullable
    public String getMessage(@NotNull String path, @Nullable String def, String ... args) {
        return this.getMessage(path, def, null, true, args);
    }

    @Contract(value="_, !null, _ -> !null")
    @Nullable
    public List<String> loadMultiMessage(@NotNull String path, @Nullable List<String> def, String ... holders) {
        return this.loadMultiMessage(path, def, null, true, holders);
    }

    @Contract(value="_, !null, _, _ -> !null")
    @Nullable
    public List<String> loadMultiMessage(@NotNull String path, @Nullable List<String> def, boolean color, String ... holders) {
        return this.loadMultiMessage(path, def, null, color, holders);
    }

    @Contract(value="_, !null, _, _, _ -> !null")
    @Nullable
    public List<String> loadMultiMessage(@NotNull String path, @Nullable List<String> def, @Nullable Player target, boolean color, String ... holders) {
        if (holders.length > 0 && VersionUtils.isVersionAfter(1, 18, 1) && this.getComments(path).isEmpty()) {
            if (this.contains(path + "_HOLDERS")) {
                this.set(path + "_HOLDERS", null);
            }
            StringBuilder build = new StringBuilder();
            for (int i = 0; i < holders.length; i += 2) {
                build.append(holders[i]).append(" ");
            }
            this.setComments(path, Collections.singletonList(build.substring(0, build.length() - 1)));
        }
        try {
            return UtilsString.fix(this.load(path, def, List.class), target, color, holders);
        }
        catch (Exception e) {
            e.printStackTrace();
            return UtilsString.fix(def, target, color, holders);
        }
    }

    @Contract(value="_, !null, _ -> !null")
    @Nullable
    public List<String> getMultiMessage(@NotNull String path, @Nullable List<String> def, String ... holders) {
        return this.getMultiMessage(path, def, null, true, holders);
    }

    @Contract(value="_, !null, _, _ -> !null")
    @Nullable
    public List<String> getMultiMessage(@NotNull String path, @Nullable List<String> def, boolean color, String ... holders) {
        return this.getMultiMessage(path, def, null, color, holders);
    }

    @Contract(value="_, !null, _, _, _ -> !null")
    @Nullable
    public List<String> getMultiMessage(@NotNull String path, @Nullable List<String> def, @Nullable Player target, boolean color, String ... holders) {
        if (holders.length > 0 && VersionUtils.isVersionAfter(1, 18, 1) && this.getComments(path).isEmpty()) {
            if (this.contains(path + "_HOLDERS")) {
                this.set(path + "_HOLDERS", null);
            }
            StringBuilder build = new StringBuilder();
            for (int i = 0; i < holders.length; i += 2) {
                build.append(holders[i]).append(" ");
            }
            this.setComments(path, Collections.singletonList(build.substring(0, build.length() - 1)));
        }
        try {
            return UtilsString.fix(this.get(path, def, List.class), target, color, holders);
        }
        catch (Exception e) {
            e.printStackTrace();
            return UtilsString.fix(def, target, color, holders);
        }
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    public ItemStack loadItemStack(@NotNull String path, @Nullable ItemStack def) {
        return this.load(path, def, ItemStack.class);
    }

    @Contract(value="_, !null, _ -> !null")
    @Nullable
    public <T extends Enum<T>> T loadEnum(@NotNull String path, @Nullable T def, @NotNull Class<T> clazz) {
        return this.stringToEnum(this.loadMessage(path, def == null ? null : def.name(), false, new String[0]), def, clazz, path);
    }

    @Contract(value="_, !null, _ -> !null")
    @Nullable
    public <T extends Enum<T>> T getEnum(@NotNull String path, @Nullable T def, @NotNull Class<T> clazz) {
        return this.stringToEnum(this.getString(path, def == null ? null : def.name()), def, clazz, path);
    }

    @Contract(value="_, !null, _, _ -> !null")
    @Nullable
    private <T extends Enum<T>> T stringToEnum(@Nullable String value, @Nullable T def, @NotNull Class<T> clazz, @NotNull String errorPath) {
        try {
            if (value == null || value.isEmpty()) {
                return def;
            }
            return Enum.valueOf(clazz, value);
        }
        catch (IllegalArgumentException e) {
            try {
                return Enum.valueOf(clazz, value.toUpperCase());
            }
            catch (IllegalArgumentException e2) {
                e2.printStackTrace();
                new IllegalArgumentException(this.getError(errorPath) + "; can't find value for '" + value + "' from enum '" + clazz.getName() + "' using default").printStackTrace();
                return def;
            }
        }
    }

    @NotNull
    public <T extends Enum<T>> List<T> loadEnumList(@NotNull String path, @Nullable Collection<T> def, @NotNull Class<T> clazz) {
        return this.stringListToEnumCollection(new ArrayList(), this.loadMultiMessage(path, this.enumCollectionToStringList(def), false, new String[0]), clazz, path);
    }

    @NotNull
    public <T extends Enum<T>> EnumSet<T> loadEnumSet(@NotNull String path, @Nullable Collection<T> def, @NotNull Class<T> clazz) {
        return this.stringListToEnumCollection(EnumSet.noneOf(clazz), this.loadMultiMessage(path, this.enumCollectionToStringList(def), false, new String[0]), clazz, path);
    }

    @Contract(value="!null -> !null; null -> null")
    private <T extends Enum<T>> ArrayList<String> enumCollectionToStringList(@Nullable Collection<T> enums) {
        if (enums == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Enum enumValue : enums) {
            list.add(enumValue.name());
        }
        return list;
    }

    private <T extends Enum<T>, K extends Collection<T>> K stringListToEnumCollection(K destination, Collection<String> from, Class<T> clazz, String errPath) {
        if (from == null || from.isEmpty()) {
            return destination;
        }
        for (String value : from) {
            Object val = this.stringToEnum(value, null, clazz, errPath);
            if (val == null) continue;
            destination.add(val);
        }
        return destination;
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    public <T> Map<String, T> loadMap(@NotNull String path, @Nullable Map<String, T> def) {
        try {
            if (!this.contains(path)) {
                this.set(path, def);
                this.save();
                return def;
            }
            Map subMap = ((ConfigurationSection)this.get(path)).getValues(true);
            try {
                return subMap;
            }
            catch (Exception exception) {
                LinkedHashMap result = new LinkedHashMap();
                for (String key : subMap.keySet()) {
                    try {
                        result.put(key, subMap.get(key));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return def;
        }
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    public Material loadMaterial(@NotNull String path, @Nullable Material def) {
        return this.loadEnum(path, def, Material.class);
    }

    @NotNull
    public List<Material> loadMaterialList(@NotNull String path, @Nullable Collection<Material> def) {
        return this.loadEnumList(path, def, Material.class);
    }

    @NotNull
    public EnumSet<Material> loadMaterialSet(@NotNull String path, @Nullable Collection<Material> def) {
        return this.loadEnumSet(path, def, Material.class);
    }

    @NotNull
    public ItemFlag[] loadItemFlags(@NotNull String path, ItemFlag[] def) {
        return this.loadEnumSet(path, def == null ? null : Arrays.asList(def), ItemFlag.class).toArray(new ItemFlag[0]);
    }

    @NotNull
    private String getError(String path) {
        return "Value has wrong type or wrong value at '" + path + ":' on file " + this.file.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="_, !null -> !null")
    @Nullable
    public Object get(@NotNull String path, @Nullable Object def) {
        if (this.multiThreadSupport) {
            YMLConfig yMLConfig = this;
            synchronized (yMLConfig) {
                return super.get(path, def);
            }
        }
        return super.get(path, def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(@NotNull String path, @Nullable Object value) {
        if (this.multiThreadSupport) {
            YMLConfig yMLConfig = this;
            synchronized (yMLConfig) {
                super.set(path, value);
                return;
            }
        }
        super.set(path, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ConfigurationSection createSection(@NotNull String path) {
        if (this.multiThreadSupport) {
            YMLConfig yMLConfig = this;
            synchronized (yMLConfig) {
                return super.createSection(path);
            }
        }
        return super.createSection(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mapChildrenKeys(@NotNull Set<String> output, @NotNull ConfigurationSection section, boolean deep) {
        if (this.multiThreadSupport) {
            YMLConfig yMLConfig = this;
            synchronized (yMLConfig) {
                super.mapChildrenKeys(output, section, deep);
                return;
            }
        }
        super.mapChildrenKeys(output, section, deep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mapChildrenValues(@NotNull Map<String, Object> output, @NotNull ConfigurationSection section, boolean deep) {
        if (this.multiThreadSupport) {
            YMLConfig yMLConfig = this;
            synchronized (yMLConfig) {
                super.mapChildrenValues(output, section, deep);
                return;
            }
        }
        super.mapChildrenValues(output, section, deep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<String> getComments(@NotNull String path) {
        if (this.multiThreadSupport) {
            YMLConfig yMLConfig = this;
            synchronized (yMLConfig) {
                return super.getComments(path);
            }
        }
        return super.getComments(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<String> getInlineComments(@NotNull String path) {
        if (this.multiThreadSupport) {
            YMLConfig yMLConfig = this;
            synchronized (yMLConfig) {
                return super.getInlineComments(path);
            }
        }
        return super.getInlineComments(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComments(@NotNull String path, @Nullable List<String> comments) {
        if (this.multiThreadSupport) {
            YMLConfig yMLConfig = this;
            synchronized (yMLConfig) {
                super.setComments(path, comments);
                return;
            }
        }
        super.setComments(path, comments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInlineComments(@NotNull String path, @Nullable List<String> comments) {
        if (this.multiThreadSupport) {
            YMLConfig yMLConfig = this;
            synchronized (yMLConfig) {
                super.setInlineComments(path, comments);
                return;
            }
        }
        super.setInlineComments(path, comments);
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public File getFile() {
        return this.file;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isMultiThreadSupport() {
        return this.multiThreadSupport;
    }

    public void setMultiThreadSupport(boolean multiThreadSupport) {
        this.multiThreadSupport = multiThreadSupport;
    }
}

