/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.aliases;

import emanondev.itemedit.ItemEdit;
import emanondev.itemedit.YMLConfig;
import emanondev.itemedit.aliases.IAliasSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public abstract class AliasSet<T>
implements IAliasSet<T> {
    private static final YMLConfig config = ItemEdit.get().getConfig("aliases.yml");
    private final String path;
    private final HashMap<String, T> map = new HashMap();

    public AliasSet(String path) {
        this.path = path.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String getID() {
        return this.path;
    }

    @Override
    public void reload() {
        this.map.clear();
        for (T value : this.getValues()) {
            String path = this.path + "." + this.getPathName(value);
            String val = config.getString(path, null);
            boolean ok = true;
            if (val == null || val.isEmpty()) {
                val = this.getDefaultName(value);
                ok = false;
            }
            if (val == null) {
                new NullPointerException(value == null ? "null value" : value + " of " + value.getClass().getSimpleName() + " has null name").printStackTrace();
                continue;
            }
            if (val.contains(" ") || !val.equals(val.toLowerCase(Locale.ENGLISH))) {
                val = val.toLowerCase(Locale.ENGLISH).replace(" ", "_");
                ok = false;
            }
            if (this.map.containsKey(val)) {
                int index = 1;
                while (this.map.containsKey(val + index)) {
                    ++index;
                }
                val = val + index;
                ok = false;
            }
            this.map.put(val, value);
            if (ok) continue;
            config.set(path, val);
            config.save();
        }
    }

    @Override
    public String getDefaultName(T value) {
        return this.getPathName(value);
    }

    @Override
    @Deprecated
    public abstract String getName(T var1);

    @Override
    public String getPathName(T value) {
        return this.getName(value);
    }

    @Override
    public abstract Collection<T> getValues();

    protected void set(String alias, T obj) {
        String path;
        if (obj == null || alias == null) {
            throw new NullPointerException();
        }
        if (alias.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if ((alias = alias.replace(" ", "_").toLowerCase(Locale.ENGLISH)).equals(config.get(path = this.path + "." + this.getPathName(obj)))) {
            return;
        }
        if (this.map.containsKey(alias)) {
            throw new IllegalArgumentException("Alias " + alias + " is already used, check aliases.yml avoid using the same alias for different things");
        }
        this.map.remove(config.get(path));
        this.map.put(alias, obj);
        config.set(path, alias);
        config.save();
    }

    @Override
    public List<String> getAliases() {
        return new ArrayList<String>(this.map.keySet());
    }

    @Override
    @Nullable
    public T convertAlias(String alias) {
        return this.map.get(alias.toLowerCase(Locale.ENGLISH));
    }
}

