/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.aliases;

import emanondev.itemedit.aliases.AliasSet;
import emanondev.itemedit.aliases.AttributeAliases;
import emanondev.itemedit.aliases.AttributeAliasesNew;
import emanondev.itemedit.aliases.AttributeAliasesOld;
import emanondev.itemedit.aliases.AxolotlVariantAliases;
import emanondev.itemedit.aliases.BannerPatternAliasesNew;
import emanondev.itemedit.aliases.BannerPatternAliasesOld;
import emanondev.itemedit.aliases.EggTypeAliases;
import emanondev.itemedit.aliases.EnchAliases;
import emanondev.itemedit.aliases.EnchAliasesOld;
import emanondev.itemedit.aliases.EnumAliasSet;
import emanondev.itemedit.aliases.EquipmentSlotGroupAliases;
import emanondev.itemedit.aliases.GenAliases;
import emanondev.itemedit.aliases.GoatHornSoundAliases;
import emanondev.itemedit.aliases.IAliasSet;
import emanondev.itemedit.aliases.OperationAliases;
import emanondev.itemedit.aliases.RarityAliases;
import emanondev.itemedit.aliases.SoundAliases;
import emanondev.itemedit.aliases.TagAliasSet;
import emanondev.itemedit.aliases.TrimMaterialAliases;
import emanondev.itemedit.aliases.TrimMaterialAliasesNew;
import emanondev.itemedit.aliases.TrimMaterialAliasesOld;
import emanondev.itemedit.aliases.TrimPatternAliases;
import emanondev.itemedit.aliases.TrimPatternAliasesNew;
import emanondev.itemedit.aliases.TrimPatternAliasesOld;
import emanondev.itemedit.aliases.TropicalFishPatternAliases;
import emanondev.itemedit.utility.TagContainer;
import emanondev.itemedit.utility.VersionUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.block.banner.PatternType;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Aliases {
    public static final EnchAliases ENCHANT = Aliases.getEnchAliases();
    public static final AliasSet<PatternType> PATTERN_TYPE = Aliases.getPatternAlias();
    public static final GenAliases BOOK_TYPE = Aliases.getGenAliases();
    public static final AliasSet<PotionEffectType> POTION_EFFECT = new AliasSet<PotionEffectType>("potion_effect"){
        private final Collection<PotionEffectType> values = this.grabValues();

        @Override
        public String getName(PotionEffectType type) {
            String name = type.getName().toLowerCase(Locale.ENGLISH);
            if (name.startsWith("minecraft:")) {
                name = name.substring(10);
            }
            return name;
        }

        private Collection<PotionEffectType> grabValues() {
            HashSet<PotionEffectType> set = new HashSet<PotionEffectType>();
            for (PotionEffectType val : PotionEffectType.values()) {
                if (val == null) continue;
                set.add(val);
            }
            return set;
        }

        @Override
        public Collection<PotionEffectType> getValues() {
            return this.values;
        }
    };
    public static final AliasSet<DyeColor> COLOR = new EnumAliasSet<DyeColor>("color", DyeColor.class);
    public static final AliasSet<String> ANIMATION = VersionUtils.isVersionAfter(1, 20, 5) ? new AliasSet<String>("animations"){
        private final LinkedHashSet<String> values = new LinkedHashSet<String>(this.craftValues());

        @Override
        public String getName(String type) {
            return type.toLowerCase(Locale.ENGLISH);
        }

        private List<String> craftValues() {
            return Arrays.asList("drink", "eat", "crossbow", "none", "block", "bow", "spear", "spyglass", "toot_horn", "brush");
        }

        @Override
        public Collection<String> getValues() {
            return this.values;
        }
    } : null;
    public static final EggTypeAliases EGG_TYPE = Aliases.getEggTypeAliases();
    public static final AliasSet<ItemFlag> FLAG_TYPE = new EnumAliasSet<ItemFlag>("flag_type", ItemFlag.class){

        @Override
        public String getName(ItemFlag type) {
            String name = type.name().toLowerCase(Locale.ENGLISH);
            if (name.startsWith("hide_")) {
                name = name.substring("hide_".length());
            }
            return name;
        }
    };
    public static final AliasSet<Boolean> BOOLEAN = new AliasSet<Boolean>("boolean"){

        @Override
        public String getName(Boolean value) {
            return value != false ? "true" : "false";
        }

        @Override
        public Collection<Boolean> getValues() {
            return Arrays.asList(Boolean.FALSE, Boolean.TRUE);
        }
    };
    public static final AliasSet<EquipmentSlot> EQUIPMENT_SLOTS = new EnumAliasSet<EquipmentSlot>("equip_slot", EquipmentSlot.class);
    public static final AttributeAliases ATTRIBUTE = Aliases.getAttributeAliases();
    public static final OperationAliases OPERATIONS = Aliases.getAttributeOperationAliases();
    public static final RarityAliases RARITY = Aliases.getRarityAliases();
    public static final TropicalFishPatternAliases TROPICALPATTERN = Aliases.getTropicalPatternAliases();
    public static final TrimMaterialAliases TRIM_MATERIAL = Aliases.getTrimMaterialAliases();
    public static final TrimPatternAliases TRIM_PATTERN = Aliases.getTrimPatternAliases();
    public static final EnumAliasSet<FireworkEffect.Type> FIREWORK_TYPE = new EnumAliasSet<FireworkEffect.Type>("firework_type", FireworkEffect.Type.class);
    public static final AxolotlVariantAliases AXOLOTL_VARIANT = Aliases.getAxolotlVariantAliases();
    public static final GoatHornSoundAliases GOAT_HORN_SOUND = Aliases.getGoatHornSoundAliases();
    public static final EquipmentSlotGroupAliases EQUIPMENT_SLOTGROUPS = VersionUtils.isVersionAfter(1, 21) ? new EquipmentSlotGroupAliases() : null;
    public static final SoundAliases SOUND = Aliases.getSoundAliases();
    public static final AliasSet<EntityType> ENTITY_TYPE = new EnumAliasSet<EntityType>(EntityType.class);
    public static final AliasSet<TagContainer<EntityType>> ENTITY_GROUPS = VersionUtils.isVersionAfter(1, 21) ? new TagAliasSet<EntityType>("entitygroups", EntityType.class, "entity_types") : null;
    private static final Map<String, IAliasSet<?>> types = new HashMap();
    private static boolean loaded = false;

    private static AliasSet<PatternType> getPatternAlias() {
        try {
            if (VersionUtils.isVersionAfter(1, 20, 6)) {
                return new BannerPatternAliasesNew();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new BannerPatternAliasesOld();
    }

    private static TrimMaterialAliases getTrimMaterialAliases() {
        if (VersionUtils.isVersionUpTo(1, 19, 4)) {
            return null;
        }
        try {
            if (VersionUtils.isVersionAfter(1, 20, 2)) {
                return new TrimMaterialAliasesNew();
            }
            return new TrimMaterialAliasesOld();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static TrimPatternAliases getTrimPatternAliases() {
        if (VersionUtils.isVersionUpTo(1, 19, 4)) {
            return null;
        }
        try {
            if (VersionUtils.isVersionAfter(1, 20, 2)) {
                return new TrimPatternAliasesNew();
            }
            return new TrimPatternAliasesOld();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void loadTypesMap() {
        Aliases.registerAliasType(ENCHANT);
        Aliases.registerAliasType(PATTERN_TYPE);
        Aliases.registerAliasType(BOOK_TYPE);
        Aliases.registerAliasType(POTION_EFFECT);
        Aliases.registerAliasType(COLOR);
        Aliases.registerAliasType(EGG_TYPE);
        Aliases.registerAliasType(FLAG_TYPE);
        Aliases.registerAliasType(BOOLEAN);
        Aliases.registerAliasType(EQUIPMENT_SLOTS);
        Aliases.registerAliasType(FIREWORK_TYPE);
        Aliases.registerAliasType(ATTRIBUTE);
        Aliases.registerAliasType(OPERATIONS);
        Aliases.registerAliasType(TROPICALPATTERN);
        Aliases.registerAliasType(AXOLOTL_VARIANT);
        Aliases.registerAliasType(GOAT_HORN_SOUND);
        Aliases.registerAliasType(TRIM_MATERIAL);
        Aliases.registerAliasType(TRIM_PATTERN);
        Aliases.registerAliasType(RARITY);
        Aliases.registerAliasType(EQUIPMENT_SLOTGROUPS);
        Aliases.registerAliasType(ANIMATION);
        Aliases.registerAliasType(SOUND);
        Aliases.registerAliasType(ENTITY_TYPE);
        Aliases.registerAliasType(ENTITY_GROUPS);
    }

    public static <T> void registerAliasType(@Nullable IAliasSet<T> set) {
        Aliases.registerAliasType(set, false);
    }

    public static <T> void registerAliasType(@Nullable IAliasSet<T> set, boolean forced) {
        if (set == null) {
            return;
        }
        if (!forced && types.containsKey(set.getID())) {
            throw new IllegalArgumentException("Duplicate id");
        }
        types.put(set.getID(), set);
    }

    public static IAliasSet<?> getAliasType(@NotNull String id) {
        return types.get(id);
    }

    public static void reload() {
        if (!loaded) {
            loaded = true;
            Aliases.loadTypesMap();
        }
        for (IAliasSet<?> set : types.values()) {
            set.reload();
        }
    }

    public static Map<String, IAliasSet<?>> getTypes() {
        return Collections.unmodifiableMap(types);
    }

    private static EggTypeAliases getEggTypeAliases() {
        if (VersionUtils.isVersionInRange(1, 11, 1, 12)) {
            return new EggTypeAliases();
        }
        return null;
    }

    private static TropicalFishPatternAliases getTropicalPatternAliases() {
        if (VersionUtils.isVersionUpTo(1, 12)) {
            return null;
        }
        return new TropicalFishPatternAliases();
    }

    private static GenAliases getGenAliases() {
        if (VersionUtils.isVersionUpTo(1, 9)) {
            return null;
        }
        return new GenAliases();
    }

    @NotNull
    private static EnchAliases getEnchAliases() {
        if (VersionUtils.isVersionUpTo(1, 12)) {
            return new EnchAliasesOld();
        }
        return new EnchAliases();
    }

    private static AttributeAliases getAttributeAliases() {
        if (VersionUtils.isVersionUpTo(1, 11)) {
            return null;
        }
        if (VersionUtils.isVersionUpTo(1, 21, 2)) {
            return new AttributeAliasesOld();
        }
        return new AttributeAliasesNew();
    }

    private static OperationAliases getAttributeOperationAliases() {
        if (VersionUtils.isVersionUpTo(1, 11)) {
            return null;
        }
        return new OperationAliases();
    }

    private static RarityAliases getRarityAliases() {
        if (VersionUtils.isVersionUpTo(1, 20, 4)) {
            return null;
        }
        try {
            return new RarityAliases();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private static AxolotlVariantAliases getAxolotlVariantAliases() {
        if (VersionUtils.isVersionUpTo(1, 17)) {
            return null;
        }
        return new AxolotlVariantAliases();
    }

    private static GoatHornSoundAliases getGoatHornSoundAliases() {
        if (VersionUtils.isVersionUpTo(1, 19, 2)) {
            return null;
        }
        try {
            return new GoatHornSoundAliases();
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static SoundAliases getSoundAliases() {
        if (VersionUtils.isVersionAfter(1, 20, 5)) {
            return new SoundAliases();
        }
        return null;
    }
}

