/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.aliases;

import emanondev.itemedit.aliases.AliasSet;
import emanondev.itemedit.utility.TagContainer;
import java.util.Collection;
import java.util.HashSet;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Tag;
import org.jetbrains.annotations.NotNull;

public class TagAliasSet<T extends Keyed>
extends AliasSet<TagContainer<T>> {
    private final Class<T> clazz;
    private final String registry;

    public TagAliasSet(@NotNull String path, @NotNull Class<T> clazz, @NotNull String registry) {
        super(path);
        this.clazz = clazz;
        this.registry = registry;
    }

    @Override
    public String getPathName(TagContainer<T> value) {
        return (value.getTag().getKey().getNamespace().equals("minecraft") ? value.getTag().getKey().getKey() : value.getTag().getKey().toString()).replace(".", "_");
    }

    @Override
    public String getDefaultName(TagContainer<T> value) {
        return value.getTag().getKey().getKey();
    }

    @Override
    @Deprecated
    public String getName(TagContainer<T> value) {
        return (value.getTag().getKey().getNamespace().equals("minecraft") ? value.getTag().getKey().getKey() : value.getTag().getKey().toString()).replace(".", "_");
    }

    @Override
    public Collection<TagContainer<T>> getValues() {
        HashSet<TagContainer<T>> set = new HashSet<TagContainer<T>>();
        for (Tag tag : Bukkit.getTags((String)this.registry, this.clazz)) {
            set.add(new TagContainer(tag));
        }
        return set;
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public String getRegistry() {
        return this.registry;
    }
}

