/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.command.itemedit;

import emanondev.itemedit.Util;
import emanondev.itemedit.aliases.Aliases;
import emanondev.itemedit.command.ItemEditCommand;
import emanondev.itemedit.command.SubCmd;
import emanondev.itemedit.utility.CompleteUtility;
import emanondev.itemedit.utility.ItemUtils;
import java.util.Collections;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class BookType
extends SubCmd {
    public BookType(@NotNull ItemEditCommand cmd) {
        super("booktype", cmd, true, true);
    }

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull String alias, String[] args) {
        Player p = (Player)sender;
        ItemStack item = this.getItemInHand(p);
        if (item.getType() != Material.WRITTEN_BOOK) {
            Util.sendMessage((CommandSender)p, this.getLanguageString("wrong-type", null, sender, new String[0]));
            return;
        }
        try {
            BookMeta itemMeta = (BookMeta)ItemUtils.getMeta(item);
            if (args.length == 1) {
                itemMeta.setGeneration(null);
                item.setItemMeta((ItemMeta)itemMeta);
                this.updateView(p);
                return;
            }
            if (args.length != 2) {
                throw new IllegalArgumentException();
            }
            BookMeta.Generation type = (BookMeta.Generation)Aliases.BOOK_TYPE.convertAlias(args[1]);
            if (type == null) {
                this.onWrongAlias("wrong-generation", (CommandSender)p, Aliases.BOOK_TYPE, new String[0]);
                this.onFail((CommandSender)p, alias);
                return;
            }
            itemMeta.setGeneration(type);
            item.setItemMeta((ItemMeta)itemMeta);
            this.updateView(p);
        }
        catch (Exception e) {
            this.onFail((CommandSender)p, alias);
        }
    }

    @Override
    public List<String> onComplete(@NotNull CommandSender sender, String[] args) {
        if (args.length == 2) {
            return CompleteUtility.complete(args[1], Aliases.BOOK_TYPE);
        }
        return Collections.emptyList();
    }
}

