/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.command.itemedit;

import emanondev.itemedit.ItemEdit;
import emanondev.itemedit.Keys;
import emanondev.itemedit.ParsedItem;
import emanondev.itemedit.Util;
import emanondev.itemedit.UtilLegacy;
import emanondev.itemedit.UtilsString;
import emanondev.itemedit.aliases.Aliases;
import emanondev.itemedit.command.ItemEditCommand;
import emanondev.itemedit.command.SubCmd;
import emanondev.itemedit.utility.CompleteUtility;
import emanondev.itemedit.utility.ItemUtils;
import emanondev.itemedit.utility.VersionUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.FoodComponent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Food
extends SubCmd {
    private static final String[] foodSub;

    public Food(ItemEditCommand cmd) {
        super("food", cmd, true, true);
    }

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull String alias, String[] args) {
        Player p = (Player)sender;
        ItemStack item = this.getItemInHand(p);
        if (args.length == 1) {
            this.onFail((CommandSender)p, alias);
            return;
        }
        switch (args[1].toLowerCase(Locale.ENGLISH)) {
            case "clear": {
                this.foodClear(p, item, alias, args);
                return;
            }
            case "canalwayseat": {
                this.foodCanAlwaysEat(p, item, alias, args);
                return;
            }
            case "eatticks": {
                this.foodEatTicks(p, item, alias, args);
                return;
            }
            case "nutrition": {
                this.foodNutrition(p, item, alias, args);
                return;
            }
            case "saturation": {
                this.foodSaturation(p, item, alias, args);
                return;
            }
            case "addeffect": {
                this.foodAddEffect(p, item, alias, args);
                return;
            }
            case "removeeffect": {
                this.foodRemoveEffect(p, item, alias, args);
                return;
            }
            case "cleareffects": {
                this.foodClearEffects(p, item, alias, args);
                return;
            }
            case "consumeparticles": {
                if (!VersionUtils.isVersionAfter(1, 21, 2)) {
                    this.onFail((CommandSender)p, alias);
                    return;
                }
                this.foodConsumeParticles(p, item, alias, args);
                return;
            }
            case "animation": {
                if (!VersionUtils.isVersionAfter(1, 21, 2)) {
                    this.onFail((CommandSender)p, alias);
                    return;
                }
                this.foodAnimation(p, item, alias, args);
                return;
            }
            case "sound": {
                if (!VersionUtils.isVersionAfter(1, 21, 2)) {
                    this.onFail((CommandSender)p, alias);
                    return;
                }
                this.foodSound(p, item, alias, args);
                return;
            }
            case "info": {
                this.foodInfo(p, item, alias, args);
                return;
            }
            case "convertto": {
                if (!VersionUtils.isVersionAfter(1, 21)) {
                    this.onFail((CommandSender)p, alias);
                    return;
                }
                this.foodConvertTo(p, item, alias, args);
                return;
            }
        }
        this.onFail((CommandSender)p, alias);
    }

    private void foodSound(Player p, ItemStack item, String alias, String[] args) {
        try {
            if (args.length != 3) {
                this.sendFailFeedbackForSub((CommandSender)p, alias, "sound");
                return;
            }
            Sound value = (Sound)Aliases.SOUND.convertAlias(args[2]);
            ParsedItem parsed = new ParsedItem(item);
            parsed.set(value.getKey(), Keys.Component.CROSS_VERSION_CONSUMABLE.toString(), "sound");
            p.getInventory().setItemInMainHand(parsed.toItemStack());
            this.updateView(p);
        }
        catch (Exception e) {
            this.sendFailFeedbackForSub((CommandSender)p, alias, "sound");
        }
    }

    private void foodAnimation(Player p, ItemStack item, String alias, String[] args) {
        try {
            if (args.length != 3) {
                this.sendFailFeedbackForSub((CommandSender)p, alias, "animation");
                return;
            }
            String value = Aliases.ANIMATION.convertAlias(args[2]);
            if (value == null) {
                this.onWrongAlias("wrong-animation", (CommandSender)p, Aliases.ANIMATION, new String[0]);
                this.sendFailFeedbackForSub((CommandSender)p, alias, "animation");
                return;
            }
            ParsedItem parsed = new ParsedItem(item);
            parsed.set(value, Keys.Component.CROSS_VERSION_CONSUMABLE.toString(), "animation");
            p.getInventory().setItemInMainHand(parsed.toItemStack());
            this.updateView(p);
        }
        catch (Exception e) {
            this.sendFailFeedbackForSub((CommandSender)p, alias, "animation");
        }
    }

    private void foodConsumeParticles(Player p, ItemStack item, String alias, String[] args) {
        try {
            if (args.length != 2 && args.length != 3) {
                this.sendFailFeedbackForSub((CommandSender)p, alias, "consumeparticles");
                return;
            }
            Boolean value = args.length == 2 ? !this.consumeParticles(item) : Aliases.BOOLEAN.convertAlias(args[2]);
            ParsedItem parsed = new ParsedItem(item);
            parsed.set(value, Keys.Component.CROSS_VERSION_CONSUMABLE.toString(), "has_consume_particles");
            p.getInventory().setItemInMainHand(parsed.toItemStack());
            this.updateView(p);
        }
        catch (Exception e) {
            this.sendFailFeedbackForSub((CommandSender)p, alias, "consumeparticles");
        }
    }

    @Override
    public void onFail(@NotNull CommandSender target, @NotNull String alias) {
        Util.sendMessage(target, new ComponentBuilder(this.getLanguageString("help-header", "", target, new String[0])).create());
        for (String sub : foodSub) {
            Util.sendMessage(target, new ComponentBuilder(ChatColor.DARK_GREEN + "/" + alias + " " + this.getName() + ChatColor.GREEN + " " + sub + " " + this.getLanguageString(sub + ".params", "", target, new String[0])).event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/" + alias + " " + this.getName() + " " + sub + " ")).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(String.join((CharSequence)"\n", this.getLanguageStringList(sub + ".description", null, target, new String[0])))})).create());
        }
    }

    private void foodClear(Player p, ItemStack item, String alias, String[] args) {
        if (!item.hasItemMeta()) {
            return;
        }
        ItemMeta meta = ItemUtils.getMeta(item);
        if (!meta.hasFood()) {
            return;
        }
        ParsedItem parsed = new ParsedItem(item);
        parsed.remove(Keys.Component.CROSS_VERSION_CONSUMABLE.toString());
        parsed.remove(Keys.Component.FOOD.toString());
        p.getInventory().setItemInMainHand(parsed.toItemStack());
        this.updateView(p);
    }

    private void foodCanAlwaysEat(Player p, ItemStack item, String alias, String[] args) {
        try {
            if (args.length != 2 && args.length != 3) {
                this.sendFailFeedbackForSub((CommandSender)p, alias, "canalwayseat");
                return;
            }
            Boolean value = args.length == 2 ? !this.canAlwaysEat(item) : Aliases.BOOLEAN.convertAlias(args[2]);
            ParsedItem parsed = new ParsedItem(item);
            parsed.loadEmptyMap(Keys.Component.CONSUMABLE.toString());
            parsed.set(value, Keys.Component.FOOD.toString(), "can_always_eat");
            parsed.load(0, Keys.Component.FOOD.toString(), "nutrition");
            parsed.load(Float.valueOf(0.0f), Keys.Component.FOOD.toString(), "saturation");
            p.getInventory().setItemInMainHand(parsed.toItemStack());
            this.updateView(p);
        }
        catch (Exception e) {
            this.sendFailFeedbackForSub((CommandSender)p, alias, "canalwayseat");
        }
    }

    private ItemStack setFoodEffects(ItemStack stack, List<FoodPojo> value) {
        Map<String, Object> componentMap;
        ParsedItem parsed = new ParsedItem(stack);
        Map<String, Object> map2 = componentMap = value == null ? ParsedItem.getMap(parsed.getMap(), Keys.Component.CROSS_VERSION_CONSUMABLE.toString()) : ParsedItem.loadMap(parsed.getMap(), Keys.Component.CROSS_VERSION_CONSUMABLE.toString());
        if (componentMap == null) {
            return stack;
        }
        if (VersionUtils.isVersionUpTo(1, 21, 1)) {
            if (value == null) {
                componentMap.remove("effects");
            }
            List<Map<String, Object>> effects = parsed.loadEmptyList(Keys.Component.CROSS_VERSION_CONSUMABLE.toString(), "effects");
            value.forEach(foodPojo -> {
                LinkedHashMap<String, Object> potionMap = new LinkedHashMap<String, Object>();
                PotionEffect pot = foodPojo.getPotionEffect();
                potionMap.put("id", pot.getType().getKey());
                potionMap.put("duration", pot.getDuration());
                potionMap.put("amplifier", pot.getAmplifier());
                potionMap.put("ambient", pot.isAmbient());
                potionMap.put("show_particles", pot.hasParticles());
                potionMap.put("show_icon", pot.hasIcon());
                LinkedHashMap<String, Serializable> effectMap = new LinkedHashMap<String, Serializable>();
                effectMap.put("effect", potionMap);
                effectMap.put("probability", Float.valueOf(foodPojo.getProbability()));
                effects.add(effectMap);
            });
            parsed.set(effects, Keys.Component.CROSS_VERSION_CONSUMABLE.toString(), "effects");
            return parsed.toItemStack();
        }
        ArrayList<Map<String, Object>> tmp = parsed.readList(Keys.Component.CROSS_VERSION_CONSUMABLE.toString(), "on_consume_effects");
        ArrayList<Map<String, Object>> consumeEffects = tmp == null ? new ArrayList<Map<String, Object>>() : tmp;
        consumeEffects.removeIf(map -> Objects.equals(ParsedItem.readNamespacedKey(map, "type"), Keys.EffectType.APPLY_EFFECTS));
        value.forEach(food -> {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("type", Keys.EffectType.APPLY_EFFECTS);
            map.put("probability", Float.valueOf(food.getProbability()));
            PotionEffect pot = food.getPotionEffect();
            LinkedHashMap<String, Object> subMap = new LinkedHashMap<String, Object>();
            subMap.put("id", pot.getType().getKey());
            subMap.put("duration", pot.getDuration());
            subMap.put("amplifier", pot.getAmplifier());
            subMap.put("ambient", pot.isAmbient());
            subMap.put("show_particles", pot.hasParticles());
            subMap.put("show_icon", pot.hasIcon());
            ArrayList<LinkedHashMap<String, Object>> list = new ArrayList<LinkedHashMap<String, Object>>();
            list.add(subMap);
            map.put("effects", list);
            consumeEffects.add(map);
        });
        parsed.set(consumeEffects, Keys.Component.CROSS_VERSION_CONSUMABLE.toString(), "on_consume_effects");
        return parsed.toItemStack();
    }

    private List<FoodPojo> getFoodEffects(ItemStack stack) {
        ParsedItem parsed = new ParsedItem(stack);
        Map<String, Object> componentMap = ParsedItem.getMap(parsed.getMap(), Keys.Component.CROSS_VERSION_CONSUMABLE.toString());
        if (componentMap == null) {
            return new ArrayList<FoodPojo>();
        }
        if (VersionUtils.isVersionUpTo(1, 21, 1)) {
            List<Map<String, Object>> effects = ParsedItem.getListOfMap(componentMap, "effects");
            if (effects == null) {
                return new ArrayList<FoodPojo>();
            }
            ArrayList<FoodPojo> list = new ArrayList<FoodPojo>();
            effects.forEach(map -> {
                Map<String, Object> subMap = ParsedItem.getMap(map, "effect");
                list.add(new FoodPojo(new PotionEffect((PotionEffectType)Registry.EFFECT.get(ParsedItem.readNamespacedKey(subMap, "id")), ParsedItem.readInt(subMap, "duration", 30).intValue(), ParsedItem.readInt(subMap, "amplifier", 0).intValue(), ParsedItem.readBoolean(subMap, "ambient", false).booleanValue(), ParsedItem.readBoolean(subMap, "show_particles", true).booleanValue(), ParsedItem.readBoolean(subMap, "show_icon", true).booleanValue()), ParsedItem.readFloat(map, "probability", Float.valueOf(1.0f)).floatValue()));
            });
            return list;
        }
        List<Map<String, Object>> consumeEffects = ParsedItem.getListOfMap(componentMap, "on_consume_effects");
        if (consumeEffects == null || consumeEffects.isEmpty()) {
            return new ArrayList<FoodPojo>();
        }
        ArrayList<FoodPojo> list = new ArrayList<FoodPojo>();
        consumeEffects.forEach(map -> {
            if (!Objects.equals(ParsedItem.readNamespacedKey(map, "type"), Keys.EffectType.APPLY_EFFECTS)) {
                return;
            }
            float probability = ParsedItem.readFloat(map, "probability", Float.valueOf(1.0f)).floatValue();
            ParsedItem.loadListOfMap(map, "effects").forEach(effect -> list.add(new FoodPojo(new PotionEffect((PotionEffectType)Registry.EFFECT.get(ParsedItem.readNamespacedKey(effect, "id")), ParsedItem.readInt(effect, "duration", 30).intValue(), ParsedItem.readInt(effect, "amplifier", 0).intValue(), ParsedItem.readBoolean(effect, "ambient", false).booleanValue(), ParsedItem.readBoolean(effect, "show_particles", true).booleanValue(), ParsedItem.readBoolean(effect, "show_icon", true).booleanValue()), probability)));
        });
        return list;
    }

    private boolean canAlwaysEat(ItemStack stack) {
        ParsedItem parsed = new ParsedItem(stack);
        return parsed.readBoolean(false, Keys.Component.FOOD.toString(), "can_always_eat");
    }

    private void foodEatTicks(Player p, ItemStack item, String alias, String[] args) {
        try {
            if (args.length != 3) {
                this.sendFailFeedbackForSub((CommandSender)p, alias, "eatticks");
                return;
            }
            int val = Integer.parseInt(args[2]);
            if (val < 0) {
                val = 0;
            }
            ParsedItem parsedItem = new ParsedItem(item);
            parsedItem.loadEmptyMap(Keys.Component.CROSS_VERSION_CONSUMABLE.toString());
            parsedItem.set(Float.valueOf((float)val / 20.0f), Keys.Component.CROSS_VERSION_CONSUMABLE.toString(), "consume_seconds");
            p.getInventory().setItemInMainHand(parsedItem.toItemStack());
            this.updateView(p);
        }
        catch (Exception e) {
            this.sendFailFeedbackForSub((CommandSender)p, alias, "eatticks");
        }
    }

    private float getEastSeconds(ItemStack stack) {
        ParsedItem parsed = new ParsedItem(stack);
        return parsed.readFloat(Float.valueOf(1.6f), Keys.Component.CROSS_VERSION_CONSUMABLE.toString(), "consume_seconds").floatValue();
    }

    private void foodNutrition(Player p, ItemStack item, String alias, String[] args) {
        try {
            if (args.length != 3) {
                this.sendFailFeedbackForSub((CommandSender)p, alias, "nutrition");
                return;
            }
            int val = Integer.parseInt(args[2]);
            ParsedItem parsedItem = new ParsedItem(item);
            parsedItem.loadEmptyMap(Keys.Component.CROSS_VERSION_CONSUMABLE.toString());
            parsedItem.set(val, Keys.Component.FOOD.toString(), "nutrition");
            parsedItem.load(Float.valueOf(0.0f), Keys.Component.FOOD.toString(), "saturation");
            p.getInventory().setItemInMainHand(parsedItem.toItemStack());
            this.updateView(p);
        }
        catch (Exception e) {
            this.sendFailFeedbackForSub((CommandSender)p, alias, "nutrition");
        }
    }

    private void foodSaturation(Player p, ItemStack item, String alias, String[] args) {
        try {
            if (args.length != 3) {
                this.sendFailFeedbackForSub((CommandSender)p, alias, "saturation");
                return;
            }
            float val = Float.parseFloat(args[2]);
            ParsedItem parsedItem = new ParsedItem(item);
            parsedItem.loadEmptyMap(Keys.Component.CROSS_VERSION_CONSUMABLE.toString());
            parsedItem.set(0, Keys.Component.FOOD.toString(), "nutrition");
            parsedItem.load(Float.valueOf(val), Keys.Component.FOOD.toString(), "saturation");
            p.getInventory().setItemInMainHand(parsedItem.toItemStack());
            this.updateView(p);
        }
        catch (Exception e) {
            this.sendFailFeedbackForSub((CommandSender)p, alias, "saturation");
        }
    }

    private void foodAddEffect(Player p, ItemStack item, String alias, String[] args) {
        try {
            if (args.length < 4 || args.length > 9) {
                this.sendFailFeedbackForSub((CommandSender)p, alias, "addeffect");
                return;
            }
            PotionEffectType effect = Aliases.POTION_EFFECT.convertAlias(args[2]);
            if (effect == null) {
                this.onWrongAlias("wrong-effect", (CommandSender)p, Aliases.POTION_EFFECT, new String[0]);
                this.sendFailFeedbackForSub((CommandSender)p, alias, "addeffect");
                return;
            }
            int duration = UtilLegacy.readPotionEffectDurationSecondsToTicks(args[3]);
            int level = 0;
            if (args.length >= 5 && ((level = Integer.parseInt(args[4]) - 1) < 0 || level > 127)) {
                throw new IllegalArgumentException();
            }
            boolean particles = true;
            if (args.length >= 6) {
                particles = Aliases.BOOLEAN.convertAlias(args[5]);
            }
            boolean ambient = false;
            if (args.length >= 7) {
                ambient = Aliases.BOOLEAN.convertAlias(args[6]);
            }
            boolean icon = true;
            if (args.length >= 8) {
                icon = Aliases.BOOLEAN.convertAlias(args[7]);
            }
            float chance = 1.0f;
            if (args.length == 9 && ((chance = Float.parseFloat(args[8]) / 100.0f) <= 0.0f || chance > 1.0f)) {
                throw new IllegalArgumentException();
            }
            if (!p.hasPermission(this.getPermission() + ".bypass_limits")) {
                level = Math.min(level, 1);
            }
            List<FoodPojo> values = this.getFoodEffects(item);
            values.add(new FoodPojo(new PotionEffect(effect, duration, level, ambient, particles, icon), chance));
            p.getInventory().setItemInMainHand(this.setFoodEffects(item, values));
            this.updateView(p);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sendFailFeedbackForSub((CommandSender)p, alias, "addeffect");
        }
    }

    private void foodRemoveEffect(Player p, ItemStack item, String alias, String[] args) {
        try {
            Integer level;
            if (args.length != 3 && args.length != 4) {
                this.sendFailFeedbackForSub((CommandSender)p, alias, "removeeffect");
                return;
            }
            PotionEffectType type = Aliases.POTION_EFFECT.convertAlias(args[2]);
            if (type == null) {
                this.onWrongAlias("wrong-effect", (CommandSender)p, Aliases.POTION_EFFECT, new String[0]);
                this.sendFailFeedbackForSub((CommandSender)p, alias, "removeeffect");
                return;
            }
            if (args.length == 4) {
                level = Integer.parseInt(args[3]) - 1;
                if (level < 0 || level > 127) {
                    throw new IllegalArgumentException();
                }
            } else {
                level = null;
            }
            List<FoodPojo> values = this.getFoodEffects(item);
            values.removeIf(effect -> effect.getPotionEffect().getType().equals(type) && (level == null || effect.getPotionEffect().getAmplifier() == level.intValue()));
            p.getInventory().setItemInMainHand(this.setFoodEffects(item, values));
            this.updateView(p);
        }
        catch (Exception e) {
            this.sendFailFeedbackForSub((CommandSender)p, alias, "removeeffect");
        }
    }

    private void foodClearEffects(Player p, ItemStack item, String alias, String[] args) {
        try {
            p.getInventory().setItemInMainHand(this.setFoodEffects(item, null));
            this.updateView(p);
        }
        catch (Exception e) {
            this.sendFailFeedbackForSub((CommandSender)p, alias, "cleareffects");
        }
    }

    private void foodInfo(Player p, ItemStack item, String alias, String[] args) {
        try {
            ParsedItem parsedItem = new ParsedItem(item);
            if (!item.hasItemMeta() || !parsedItem.getMap().containsKey(Keys.Component.CROSS_VERSION_CONSUMABLE.toString()) && !parsedItem.getMap().containsKey("use_remainer")) {
                this.sendLanguageString("info.not_food", "", (CommandSender)p, new String[0]);
                return;
            }
            ItemStack remainer = VersionUtils.isVersionAfter(1, 21) ? this.getUseRemainder(item) : null;
            String[] stringArray = new String[18];
            stringArray[0] = "%eatseconds%";
            stringArray[1] = UtilsString.formatNumber(this.getEastSeconds(item), 2, false);
            stringArray[2] = "%eatticks%";
            stringArray[3] = UtilsString.formatNumber(this.getEastSeconds(item) * 20.0f, 0, false);
            stringArray[4] = "%saturation%";
            stringArray[5] = UtilsString.formatNumber(this.getSaturation(item), 2, false);
            stringArray[6] = "%nutrition%";
            stringArray[7] = String.valueOf(this.getNutrition(item));
            stringArray[8] = "%canalwayseat%";
            stringArray[9] = Aliases.BOOLEAN.getDefaultName(this.canAlwaysEat(item));
            stringArray[10] = "%convertto%";
            stringArray[11] = VersionUtils.isVersionAfter(1, 21) ? (remainer == null ? Aliases.BOOLEAN.getDefaultName(false) : remainer.getType().name() + (remainer.hasItemMeta() ? " [...]" : "") + (remainer.getAmount() == 1 ? "" : " x" + remainer.getAmount())) : "&c1.21+";
            stringArray[12] = "%consumeparticles%";
            stringArray[13] = Aliases.BOOLEAN.getDefaultName(this.consumeParticles(item));
            stringArray[14] = "%animation%";
            stringArray[15] = Aliases.ANIMATION.getDefaultName(this.animation(item));
            stringArray[16] = "%sound%";
            stringArray[17] = Aliases.SOUND.getDefaultName(this.sound(item));
            ArrayList<String> list = new ArrayList<String>(this.getLanguageStringList("info.message", Collections.emptyList(), (CommandSender)p, stringArray));
            int appliedEffects = this.getFoodEffects(item).size();
            if (appliedEffects > 0) {
                list.addAll(this.getLanguageStringList("info.apply_effect_prefix", Collections.emptyList(), (CommandSender)p, "%effects%", String.valueOf(this.getFoodEffects(item).size())));
                int index = 1;
                for (FoodPojo foodEffect : this.getFoodEffects(item)) {
                    PotionEffect effect = foodEffect.getPotionEffect();
                    list.addAll(this.getLanguageStringList("info.apply_effect", Collections.emptyList(), (CommandSender)p, "%index%", String.valueOf(index), "%type%", Aliases.POTION_EFFECT.getDefaultName(effect.getType()), "%level%", String.valueOf(effect.getAmplifier() + 1), "%duration_s%", effect.getDuration() == -1 ? "\u221e" : UtilsString.formatNumber((double)effect.getDuration() / 20.0, 2, true), "%hasparticle%", Aliases.BOOLEAN.getDefaultName(effect.hasParticles()), "%isambient%", Aliases.BOOLEAN.getDefaultName(effect.isAmbient()), "%hasicon%", Aliases.BOOLEAN.getDefaultName(!VersionUtils.isVersionAfter(1, 13) || effect.hasIcon()), "%duration_ticks%", effect.getDuration() == -1 ? "\u221e" : String.valueOf(effect.getDuration()), "%chance_perc%", UtilsString.formatNumber(foodEffect.getProbability() * 100.0f, 2, true)));
                    ++index;
                }
            }
            Util.sendMessage((CommandSender)p, String.join((CharSequence)"\n", list));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String animation(ItemStack item) {
        ParsedItem parsedItem = new ParsedItem(item);
        return parsedItem.readString("eat", Keys.Component.CROSS_VERSION_CONSUMABLE.toString(), "animation");
    }

    private Sound sound(ItemStack item) {
        ParsedItem parsedItem = new ParsedItem(item);
        String val = parsedItem.readString(null, Keys.Component.CROSS_VERSION_CONSUMABLE.toString(), "sound");
        if (val == null) {
            return Sound.ENTITY_GENERIC_EAT;
        }
        try {
            Sound value = (Sound)Registry.SOUNDS.get(new NamespacedKey(val.split(":")[0], val.split(":")[1]));
            return value == null ? Sound.ENTITY_GENERIC_EAT : value;
        }
        catch (Exception e) {
            return Sound.ENTITY_GENERIC_EAT;
        }
    }

    private boolean consumeParticles(ItemStack item) {
        ParsedItem parsedItem = new ParsedItem(item);
        return parsedItem.readBoolean(true, Keys.Component.CROSS_VERSION_CONSUMABLE.toString(), "has_consume_particles");
    }

    private float getSaturation(ItemStack item) {
        ParsedItem parsedItem = new ParsedItem(item);
        Map<String, Object> food = ParsedItem.getMap(parsedItem.getMap(), "food");
        if (food == null || !food.containsKey("saturation")) {
            return 0.0f;
        }
        return ParsedItem.readFloat(food, "saturation", Float.valueOf(0.0f)).floatValue();
    }

    private int getNutrition(ItemStack item) {
        ParsedItem parsedItem = new ParsedItem(item);
        Map<String, Object> food = ParsedItem.getMap(parsedItem.getMap(), "food");
        if (food == null || !food.containsKey("nutrition")) {
            return 0;
        }
        return ParsedItem.readInt(food, "nutrition", 0);
    }

    private void foodConvertTo(Player p, ItemStack item, String alias, String[] args) {
        try {
            if (args.length > 4) {
                this.sendFailFeedbackForSub((CommandSender)p, alias, "convertto");
                return;
            }
            ItemStack target = null;
            if (args.length >= 3) {
                String name = args[2];
                target = ItemEdit.get().getServerStorage().getItem(name);
                if (target == null) {
                    try {
                        Material mat = Material.valueOf((String)name.toUpperCase(Locale.ENGLISH));
                        if (!ItemUtils.isItem(mat)) {
                            throw new IllegalArgumentException();
                        }
                        target = new ItemStack(mat);
                    }
                    catch (IllegalArgumentException e2) {
                        this.sendFailFeedbackForSub((CommandSender)p, alias, "convertto");
                        return;
                    }
                }
            }
            int amount = 1;
            if (args.length == 4) {
                amount = Integer.parseInt(args[3]);
            }
            if (target.getType().isAir()) {
                target = null;
            }
            if (target != null) {
                target.setAmount(amount);
            }
            this.setUseRemainder(item, target);
            this.updateView(p);
        }
        catch (Exception e) {
            this.sendFailFeedbackForSub((CommandSender)p, alias, "convertto");
        }
    }

    @Override
    public List<String> onComplete(@NotNull CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        switch (args.length) {
            case 2: {
                List<String> list = CompleteUtility.complete(args[1], foodSub);
                if (!VersionUtils.isVersionAfter(1, 21)) {
                    list.remove("convertto");
                }
                return list;
            }
            case 3: {
                switch (args[1].toLowerCase(Locale.ENGLISH)) {
                    case "canalwayseat": {
                        return CompleteUtility.complete(args[2], Aliases.BOOLEAN);
                    }
                    case "consumeparticles": {
                        if (VersionUtils.isVersionAfter(1, 21, 2)) {
                            return CompleteUtility.complete(args[2], Aliases.BOOLEAN);
                        }
                        return Collections.emptyList();
                    }
                    case "animation": {
                        if (VersionUtils.isVersionAfter(1, 21, 2)) {
                            return CompleteUtility.complete(args[2], Aliases.ANIMATION);
                        }
                        return Collections.emptyList();
                    }
                    case "sound": {
                        if (VersionUtils.isVersionAfter(1, 21, 2)) {
                            return CompleteUtility.complete(args[2], Aliases.SOUND);
                        }
                        return Collections.emptyList();
                    }
                    case "eatticks": {
                        return CompleteUtility.complete(args[2], "1", "20", "40");
                    }
                    case "saturation": {
                        return CompleteUtility.complete(args[2], "0", "1", "1.5", "2", "10");
                    }
                    case "nutrition": {
                        return CompleteUtility.complete(args[2], "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20");
                    }
                    case "addeffect": {
                        return CompleteUtility.complete(args[2], Aliases.POTION_EFFECT);
                    }
                    case "removeeffect": {
                        ItemStack item = this.getItemInHand((Player)sender);
                        if (item == null || !item.hasItemMeta()) {
                            return Collections.emptyList();
                        }
                        HashSet<PotionEffectType> types = new HashSet<PotionEffectType>();
                        for (FoodPojo food : this.getFoodEffects(item)) {
                            types.add(food.getPotionEffect().getType());
                        }
                        ArrayList<String> list2 = new ArrayList<String>();
                        for (PotionEffectType type : types) {
                            list2.add(Aliases.POTION_EFFECT.getDefaultName(type));
                        }
                        return CompleteUtility.complete(args[2], list2);
                    }
                    case "convertto": {
                        if (!VersionUtils.isVersionAfter(1, 21)) break;
                        List<String> list2 = CompleteUtility.complete(args[2], Material.class);
                        list2.addAll(CompleteUtility.complete(args[2], ItemEdit.get().getServerStorage().getIds()));
                        return list2;
                    }
                }
                return Collections.emptyList();
            }
            case 4: {
                switch (args[1].toLowerCase(Locale.ENGLISH)) {
                    case "addeffect": {
                        return CompleteUtility.complete(args[3], "infinite", "instant", "1", "90", "180", "480");
                    }
                    case "removeeffect": {
                        return CompleteUtility.complete(args[3], "1", "2", "3", "4", "5");
                    }
                    case "convertto": {
                        if (!VersionUtils.isVersionAfter(1, 21)) break;
                        return CompleteUtility.complete(args[3], "1", "10", "64");
                    }
                }
                return Collections.emptyList();
            }
            case 5: {
                if (args[1].toLowerCase(Locale.ENGLISH).equals("addeffect")) {
                    return CompleteUtility.complete(args[4], "1", "2", "3", "4", "5");
                }
                return Collections.emptyList();
            }
            case 6: 
            case 7: 
            case 8: {
                if (args[1].toLowerCase(Locale.ENGLISH).equals("addeffect")) {
                    return CompleteUtility.complete(args[args.length - 1], Aliases.BOOLEAN);
                }
                return Collections.emptyList();
            }
            case 9: {
                if (args[1].toLowerCase(Locale.ENGLISH).equals("addeffect")) {
                    return CompleteUtility.complete(args[8], "0.01", "10.0", "50.0", "100.0");
                }
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    private void setUseRemainder(ItemStack origin, ItemStack d) {
        ItemMeta meta = ItemUtils.getMeta(origin);
        if (VersionUtils.isVersionUpTo(1, 21, 1)) {
            FoodComponent food = meta.getFood();
            try {
                food.getClass().getMethod("setUsingConvertsTo", ItemStack.class).invoke((Object)food, d);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            meta.setFood(food);
            origin.setItemMeta(meta);
            return;
        }
        meta.setUseRemainder(d);
        origin.setItemMeta(meta);
    }

    @Nullable
    private ItemStack getUseRemainder(ItemStack origin) {
        if (VersionUtils.isVersionUpTo(1, 21, 1)) {
            FoodComponent food = ItemUtils.getMeta(origin).getFood();
            try {
                return (ItemStack)food.getClass().getMethod("getUsingConvertsTo", new Class[0]).invoke((Object)food, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return ItemUtils.getMeta(origin).getUseRemainder();
    }

    static {
        String[] stringArray;
        if (VersionUtils.isVersionAfter(1, 21, 2)) {
            String[] stringArray2 = new String[13];
            stringArray2[0] = "clear";
            stringArray2[1] = "canalwayseat";
            stringArray2[2] = "eatticks";
            stringArray2[3] = "nutrition";
            stringArray2[4] = "saturation";
            stringArray2[5] = "addeffect";
            stringArray2[6] = "removeeffect";
            stringArray2[7] = "cleareffects";
            stringArray2[8] = "info";
            stringArray2[9] = "convertto";
            stringArray2[10] = "consumeparticles";
            stringArray2[11] = "animation";
            stringArray = stringArray2;
            stringArray2[12] = "sound";
        } else if (VersionUtils.isVersionAfter(1, 21)) {
            String[] stringArray3 = new String[10];
            stringArray3[0] = "clear";
            stringArray3[1] = "canalwayseat";
            stringArray3[2] = "eatticks";
            stringArray3[3] = "nutrition";
            stringArray3[4] = "saturation";
            stringArray3[5] = "addeffect";
            stringArray3[6] = "removeeffect";
            stringArray3[7] = "cleareffects";
            stringArray3[8] = "info";
            stringArray = stringArray3;
            stringArray3[9] = "convertto";
        } else {
            String[] stringArray4 = new String[9];
            stringArray4[0] = "clear";
            stringArray4[1] = "canalwayseat";
            stringArray4[2] = "eatticks";
            stringArray4[3] = "nutrition";
            stringArray4[4] = "saturation";
            stringArray4[5] = "addeffect";
            stringArray4[6] = "removeeffect";
            stringArray4[7] = "cleareffects";
            stringArray = stringArray4;
            stringArray4[8] = "info";
        }
        foodSub = stringArray;
    }

    private static class FoodPojo {
        private PotionEffect potionEffect;
        private float probability;

        public FoodPojo(PotionEffect potionEffect, float probability) {
            this.potionEffect = potionEffect;
            this.probability = probability;
        }

        public PotionEffect getPotionEffect() {
            return this.potionEffect;
        }

        public void setPotionEffect(PotionEffect potionEffect) {
            this.potionEffect = potionEffect;
        }

        public float getProbability() {
            return this.probability;
        }

        public void setProbability(float probability) {
            this.probability = probability;
        }
    }
}

