/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.command.itemedit;

import emanondev.itemedit.ItemEdit;
import emanondev.itemedit.command.ItemEditCommand;
import emanondev.itemedit.command.SubCmd;
import emanondev.itemedit.utility.ItemUtils;
import emanondev.itemedit.utility.VersionUtils;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class HideAll
extends SubCmd {
    public HideAll(ItemEditCommand cmd) {
        super("hideall", cmd, true, true);
    }

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull String alias, String[] args) {
        Player p = (Player)sender;
        ItemStack item = this.getItemInHand(p);
        try {
            if (args.length != 1) {
                throw new IllegalArgumentException("Wrong param number");
            }
            ItemMeta itemMeta = ItemUtils.getMeta(item);
            this.handleFlagChange(item, itemMeta);
            itemMeta.addItemFlags(ItemFlag.values());
            item.setItemMeta(itemMeta);
            this.updateView(p);
        }
        catch (Exception e) {
            this.onFail((CommandSender)p, alias);
        }
    }

    private void handleFlagChange(ItemStack item, ItemMeta meta) {
        if (!(VersionUtils.hasPaperAPI() && VersionUtils.isVersionAfter(1, 20, 5) && ItemEdit.get().getConfig().loadBoolean("itemedit.paper_hide_fix", true).booleanValue())) {
            return;
        }
        if (meta.getAttributeModifiers() != null) {
            return;
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            item.getType().getDefaultAttributeModifiers(slot).forEach((arg_0, arg_1) -> ((ItemMeta)meta).addAttributeModifier(arg_0, arg_1));
        }
    }

    @Override
    public List<String> onComplete(@NotNull CommandSender sender, String[] args) {
        return Collections.emptyList();
    }
}

