/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.command.itemedit;

import emanondev.itemedit.Util;
import emanondev.itemedit.aliases.Aliases;
import emanondev.itemedit.aliases.IAliasSet;
import emanondev.itemedit.command.ItemEditCommand;
import emanondev.itemedit.command.SubCmd;
import emanondev.itemedit.utility.CompleteUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class ListAliases
extends SubCmd {
    public ListAliases(ItemEditCommand cmd) {
        super("listaliases", cmd, false, false);
    }

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull String alias, String[] args) {
        try {
            if (args.length != 1 && args.length != 2) {
                throw new IllegalArgumentException("Wrong param number");
            }
            if (args.length == 1) {
                String prefix = this.getLanguageString("prefix_line", null, sender, new String[0]);
                String postfix = this.getLanguageString("postfix_line", null, sender, new String[0]);
                String colorOne = this.getLanguageString("first_color", null, sender, new String[0]);
                String colorTwo = this.getLanguageString("second_color", null, sender, new String[0]);
                String hover = this.getLanguageString("hover_type", null, sender, new String[0]);
                ComponentBuilder comp = prefix != null && !prefix.isEmpty() ? new ComponentBuilder(prefix + "\n") : new ComponentBuilder("");
                boolean counter = true;
                ArrayList<String> values = new ArrayList<String>(Aliases.getTypes().keySet());
                Collections.sort(values);
                for (String id : values) {
                    comp.retain(ComponentBuilder.FormatRetention.NONE).append((counter ? colorOne : colorTwo) + id).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(hover).create())).event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/" + alias + " " + this.getName() + " " + id)).append(" ");
                    counter = !counter;
                }
                if (postfix != null && !postfix.isEmpty()) {
                    comp.retain(ComponentBuilder.FormatRetention.NONE).append("\n" + postfix);
                }
                Util.sendMessage(sender, comp.create());
            } else {
                IAliasSet<?> set = Aliases.getTypes().get(args[1].toLowerCase(Locale.ENGLISH));
                if (set == null) {
                    this.onFail(sender, alias);
                    return;
                }
                String prefix = this.getLanguageString("prefix_line", null, sender, new String[0]);
                String postfix = this.getLanguageString("postfix_line", null, sender, new String[0]);
                String colorOne = this.getLanguageString("first_color", null, sender, new String[0]);
                String colorTwo = this.getLanguageString("second_color", null, sender, new String[0]);
                String hover = this.getLanguageString("hover_info", null, sender, "%default%", "%default%");
                ComponentBuilder comp = prefix != null && !prefix.isEmpty() ? new ComponentBuilder(prefix + "\n") : new ComponentBuilder("");
                boolean counter = true;
                for (String aliasS : set.getAliases()) {
                    comp.retain(ComponentBuilder.FormatRetention.NONE).append((counter ? colorOne : colorTwo) + aliasS).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(hover.replace("%default%", set.getName(set.convertAlias(aliasS)))).create())).append(" ");
                    counter = !counter;
                }
                if (postfix != null && !postfix.isEmpty()) {
                    comp.retain(ComponentBuilder.FormatRetention.NONE).append("\n" + postfix);
                }
                Util.sendMessage(sender, comp.create());
            }
        }
        catch (Exception e) {
            this.onFail(sender, alias);
        }
    }

    @Override
    public List<String> onComplete(@NotNull CommandSender sender, String[] args) {
        if (args.length == 2) {
            return CompleteUtility.complete(args[1], Aliases.getTypes().keySet());
        }
        return Collections.emptyList();
    }
}

