/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.command.serveritem;

import emanondev.itemedit.ItemEdit;
import emanondev.itemedit.Util;
import emanondev.itemedit.UtilsString;
import emanondev.itemedit.aliases.Aliases;
import emanondev.itemedit.command.ServerItemCommand;
import emanondev.itemedit.command.SubCmd;
import emanondev.itemedit.utility.CompleteUtility;
import emanondev.itemedit.utility.InventoryUtils;
import emanondev.itemedit.utility.ItemUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.NotNull;

public class Sell
extends SubCmd {
    private static Economy economy = null;

    public Sell(ServerItemCommand cmd) {
        super("sell", cmd, false, false);
        this.setupEconomy();
    }

    private void setupEconomy() {
        RegisteredServiceProvider economyProvider = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            economy = (Economy)economyProvider.getProvider();
        }
        if (economy == null) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull String alias, String[] args) {
        try {
            int amount;
            Boolean silent;
            if (args.length < 5 || args.length > 6) {
                throw new IllegalArgumentException("Wrong param number");
            }
            Boolean bl = silent = args.length == 6 ? Aliases.BOOLEAN.convertAlias(args[5]) : Boolean.valueOf(false);
            if (silent == null) {
                silent = Boolean.parseBoolean(args[5]);
            }
            if ((amount = Integer.parseInt(args[2])) < 1) {
                throw new IllegalArgumentException("Wrong amount number");
            }
            ItemStack item = ItemEdit.get().getServerStorage().getItem(args[1]);
            Player target = Bukkit.getPlayer((String)args[3]);
            double price = Double.parseDouble(args[4]);
            if (price <= 0.0) {
                throw new IllegalArgumentException();
            }
            if (ItemEdit.get().getConfig().loadBoolean("serveritem.replace-holders", true).booleanValue()) {
                ItemMeta meta = ItemUtils.getMeta(item);
                meta.setDisplayName(UtilsString.fix(meta.getDisplayName(), target, true, "%player_name%", target.getName(), "%player_uuid%", target.getUniqueId().toString()));
                meta.setLore(UtilsString.fix(meta.getLore(), target, true, "%player_name%", target.getName(), "%player_uuid%", target.getUniqueId().toString()));
                item.setItemMeta(meta);
            }
            if (!economy.has((OfflinePlayer)target, price)) {
                if (!silent.booleanValue()) {
                    this.sendLanguageString("not-enough-money", null, (CommandSender)target, "%id%", args[1].toLowerCase(), "%nick%", ItemEdit.get().getServerStorage().getNick(args[1]), "%amount%", String.valueOf(amount), "%price%", economy.format(price));
                }
                return;
            }
            if (!economy.withdrawPlayer((OfflinePlayer)target, price).transactionSuccess()) {
                if (!silent.booleanValue()) {
                    Util.sendMessage((CommandSender)target, "&cAn error occurred, try again, if this message shows again try to contact the server administrators");
                }
                Util.logToFile("[transaction failed] no errors, is your Economy provider stable?");
                return;
            }
            int given = InventoryUtils.giveAmount((HumanEntity)target, item, amount, InventoryUtils.ExcessMode.CANCEL);
            if (given == 0) {
                if (!silent.booleanValue()) {
                    this.sendLanguageString("not-enough-space", null, (CommandSender)target, "%id%", args[1].toLowerCase(), "%nick%", ItemEdit.get().getServerStorage().getNick(args[1]), "%amount%", String.valueOf(amount));
                }
                if (!economy.depositPlayer((OfflinePlayer)target, price).transactionSuccess()) {
                    if (!silent.booleanValue()) {
                        Util.sendMessage((CommandSender)target, "&cAn error occurred, try again, if this message shows again try to contact the server administrators");
                    }
                    Util.logToFile("[transaction failed] player '" + target.getName() + "' (" + target.getUniqueId() + ") lost " + economy.format(price) + " money, is your Economy provider stable?");
                    return;
                }
                return;
            }
            if (!silent.booleanValue()) {
                this.sendLanguageString("feedback", null, (CommandSender)target, "%id%", args[1].toLowerCase(), "%nick%", ItemEdit.get().getServerStorage().getNick(args[1]), "%amount%", String.valueOf(amount), "%price%", economy.format(price));
            }
            if (ItemEdit.get().getConfig().loadBoolean("log.action.sell", true).booleanValue()) {
                String msg = UtilsString.fix(this.getConfigString("log", new String[0]), target, true, "%id%", args[1].toLowerCase(), "%nick%", ItemEdit.get().getServerStorage().getNick(args[1]), "%amount%", String.valueOf(amount), "%player_name%", target.getName(), "%price%", economy.format(price));
                if (ItemEdit.get().getConfig().loadBoolean("log.console", true).booleanValue()) {
                    Util.sendMessage((CommandSender)Bukkit.getConsoleSender(), msg);
                }
                if (ItemEdit.get().getConfig().loadBoolean("log.file", true).booleanValue()) {
                    Util.logToFile(msg);
                }
            }
        }
        catch (Exception e) {
            this.onFail(sender, alias);
        }
    }

    @Override
    public List<String> onComplete(@NotNull CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        switch (args.length) {
            case 2: {
                return CompleteUtility.complete(args[1], ItemEdit.get().getServerStorage().getIds());
            }
            case 3: {
                return CompleteUtility.complete(args[2], Arrays.asList("1", "10", "64", "576", "2304"));
            }
            case 4: {
                return CompleteUtility.completePlayers(args[3]);
            }
            case 5: {
                return CompleteUtility.complete(args[2], Arrays.asList("10", "100", "1000", "10000"));
            }
            case 6: {
                return CompleteUtility.complete(args[4], Aliases.BOOLEAN);
            }
        }
        return Collections.emptyList();
    }
}

