/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.gui;

import emanondev.itemedit.APlugin;
import emanondev.itemedit.Util;
import emanondev.itemedit.aliases.Aliases;
import emanondev.itemedit.gui.Gui;
import emanondev.itemedit.utility.InventoryUtils;
import emanondev.itemedit.utility.ItemUtils;
import emanondev.itemedit.utility.SchedulerUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ColorListSelectorGui
implements Gui {
    private static final String subPath = "gui.colorselector.";
    private final List<DyeColor> colors;
    private final Gui parent;
    private final Inventory inventory;

    public ColorListSelectorGui(@NotNull Gui parent, @NotNull List<DyeColor> colors) {
        this.colors = colors;
        this.parent = parent;
        String title = this.getLanguageMessage("gui.colorselector.title", new String[0]);
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)18, (String)title);
        this.inventory.setItem(this.inventory.getSize() - 1, this.getBackItem());
    }

    public void updateInventory() {
        int i = 0;
        ArrayList<String> list = new ArrayList<String>();
        for (DyeColor c : this.colors) {
            list.add(Aliases.COLOR.getName(c));
        }
        for (DyeColor color : DyeColor.values()) {
            ItemStack item = Util.getDyeItemFromColor(color);
            ItemMeta meta = ItemUtils.getMeta(item);
            meta.addItemFlags(ItemFlag.values());
            this.loadLanguageDescription(meta, "gui.colorselector.buttons.color", "%colors%", String.join((CharSequence)"&b, &e", list), "%color%", Aliases.COLOR.getName(color));
            item.setItemMeta(meta);
            item.setAmount(Math.max(Math.min(101, this.colors.size()), 1));
            this.inventory.setItem(i, item);
            ++i;
        }
    }

    @Override
    public void onClose(InventoryCloseEvent event) {
        SchedulerUtils.runLater((Plugin)this.getPlugin(), 1L, () -> {
            if (!InventoryUtils.getTopInventory(this.getTargetPlayer()).equals((Object)this.parent.getInventory())) {
                this.getTargetPlayer().openInventory(this.parent.getInventory());
            }
        });
    }

    @Override
    public void onClick(InventoryClickEvent event) {
        if (!event.getWhoClicked().equals((Object)this.parent.getTargetPlayer())) {
            return;
        }
        if (!this.inventory.equals((Object)event.getClickedInventory())) {
            return;
        }
        if (ItemUtils.isAirOrNull(event.getCurrentItem())) {
            return;
        }
        if (event.getClick() == ClickType.DOUBLE_CLICK) {
            return;
        }
        if (event.getSlot() < DyeColor.values().length) {
            switch (event.getClick()) {
                case LEFT: {
                    this.colors.add(DyeColor.values()[event.getSlot()]);
                    this.updateInventory();
                    break;
                }
                case RIGHT: {
                    this.colors.remove(this.colors.size() - 1);
                    this.updateInventory();
                    break;
                }
                case SHIFT_RIGHT: {
                    this.colors.clear();
                    this.updateInventory();
                }
            }
            return;
        }
        if (event.getSlot() == this.inventory.getSize() - 1) {
            this.getTargetPlayer().openInventory(this.parent.getInventory());
        }
    }

    @Override
    public void onDrag(InventoryDragEvent event) {
    }

    @Override
    public void onOpen(InventoryOpenEvent event) {
        this.updateInventory();
    }

    @Override
    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    @Override
    public Player getTargetPlayer() {
        return this.parent.getTargetPlayer();
    }

    @Override
    @NotNull
    public APlugin getPlugin() {
        return this.parent.getPlugin();
    }
}

