/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.gui;

import emanondev.itemedit.ItemEdit;
import emanondev.itemedit.Util;
import emanondev.itemedit.aliases.Aliases;
import emanondev.itemedit.gui.ColorListSelectorGui;
import emanondev.itemedit.gui.Gui;
import emanondev.itemedit.utility.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class FireworkEditor
implements Gui {
    private static final String subPath = "gui.firework.";
    private final FireworkMeta meta;
    private final Player target;
    private final Inventory inventory;
    private final List<FireworkEffectData> effects = new ArrayList<FireworkEffectData>();
    private final ItemStack firework;

    public FireworkEditor(Player target, ItemStack item) {
        if (item == null || !(item.getItemMeta() instanceof FireworkMeta)) {
            try {
                item = new ItemStack(Material.FIREWORK_ROCKET);
            }
            catch (Exception e) {
                item = new ItemStack(Material.valueOf((String)"FIREWORK"));
            }
        }
        this.firework = item.clone();
        this.meta = (FireworkMeta)ItemUtils.getMeta(this.firework);
        this.target = target;
        String title = this.getLanguageMessage("gui.firework.title", new String[0]);
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)title);
        for (int i = 0; i < 9; ++i) {
            if (i < this.meta.getEffects().size()) {
                this.effects.add(new FireworkEffectData((FireworkEffect)this.meta.getEffects().get(i)));
                continue;
            }
            this.effects.add(new FireworkEffectData());
        }
    }

    private static List<DyeColor> translateToDyeColor(List<Color> colors) {
        if (colors == null) {
            return null;
        }
        ArrayList<DyeColor> list = new ArrayList<DyeColor>();
        for (Color color : colors) {
            DyeColor col = DyeColor.getByFireworkColor((Color)color);
            if (col == null) continue;
            list.add(col);
        }
        return list;
    }

    private static List<Color> translateToColor(List<DyeColor> colors) {
        if (colors == null) {
            return null;
        }
        ArrayList<Color> list = new ArrayList<Color>();
        for (DyeColor color : colors) {
            Color col = color.getFireworkColor();
            if (col == null) continue;
            list.add(col);
        }
        return list;
    }

    @Override
    @NotNull
    public ItemEdit getPlugin() {
        return ItemEdit.get();
    }

    @Override
    public void onClose(InventoryCloseEvent event) {
        try {
            this.target.getInventory().setItemInMainHand(this.firework);
        }
        catch (Throwable t) {
            this.target.getInventory().setItemInHand(this.firework);
        }
    }

    @Override
    public void onClick(InventoryClickEvent event) {
        if (!event.getWhoClicked().equals((Object)this.target)) {
            return;
        }
        if (!this.inventory.equals((Object)event.getClickedInventory())) {
            return;
        }
        if (ItemUtils.isAirOrNull(event.getCurrentItem())) {
            return;
        }
        if (event.getClick() == ClickType.DOUBLE_CLICK) {
            return;
        }
        if (event.getSlot() < 9) {
            if (event.getClick() == ClickType.MIDDLE || event.getClick() == ClickType.CREATIVE || event.getClick() == ClickType.NUMBER_KEY && event.getHotbarButton() == 0) {
                this.effects.get(event.getSlot()).active = !this.effects.get(event.getSlot()).active;
            }
            if (event.isLeftClick()) {
                if (event.getSlot() == 0) {
                    return;
                }
                this.effects.add(event.getSlot() - 1, this.effects.remove(event.getSlot()));
            } else if (event.isRightClick()) {
                if (event.getSlot() == 8) {
                    return;
                }
                this.effects.add(event.getSlot() + 1, this.effects.remove(event.getSlot()));
            }
            this.updateInventory();
            return;
        }
        if (event.getSlot() < 45) {
            if (!this.effects.get(event.getSlot() % 9).active) {
                return;
            }
            this.effects.get(event.getSlot() % 9).onClick(event.getSlot() / 9, event);
            this.updateInventory();
            return;
        }
        if (event.getSlot() == 47) {
            if (event.isLeftClick()) {
                this.meta.setPower((this.meta.getPower() + 1) % 6);
            } else {
                this.meta.setPower((this.meta.getPower() - 1 + 6) % 6);
            }
            this.updateInventory();
            return;
        }
        if (event.getSlot() == 49) {
            this.target.getInventory().addItem(new ItemStack[]{this.firework});
        }
    }

    @Override
    public void onDrag(InventoryDragEvent event) {
    }

    @Override
    public void onOpen(InventoryOpenEvent event) {
        this.updateInventory();
    }

    private void updateInventory() {
        ItemStack item;
        this.meta.clearEffects();
        for (int i = 0; i < 9; ++i) {
            ItemStack item2 = this.effects.get(i).getPositionItem();
            item2.setAmount(i + 1);
            this.getInventory().setItem(i, item2);
            this.getInventory().setItem(i + 9, this.effects.get(i).getTypeItem());
            this.getInventory().setItem(i + 18, this.effects.get(i).getColorsItem());
            this.getInventory().setItem(i + 27, this.effects.get(i).getFadeColorsItem());
            this.getInventory().setItem(i + 36, this.effects.get(i).getTrailFlickerItem());
            if (!this.effects.get(i).active || this.effects.get(i).colors.isEmpty()) continue;
            this.meta.addEffect(this.effects.get(i).getEffect());
        }
        this.firework.setItemMeta((ItemMeta)this.meta);
        this.getInventory().setItem(49, this.firework);
        try {
            item = new ItemStack(Material.GUNPOWDER);
        }
        catch (Throwable t) {
            item = new ItemStack(Material.valueOf((String)"SULPHUR"));
        }
        item.setAmount(this.meta.getPower() + 1);
        ItemMeta powerMeta = ItemUtils.getMeta(item);
        powerMeta.addItemFlags(ItemFlag.values());
        this.loadLanguageDescription(powerMeta, "gui.firework.buttons.power", "%power%", String.valueOf(this.meta.getPower() + 1));
        item.setItemMeta(powerMeta);
        this.getInventory().setItem(47, item);
    }

    @Override
    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    @Override
    public Player getTargetPlayer() {
        return this.target;
    }

    private class FireworkEffectData {
        private final List<DyeColor> colors = new ArrayList<DyeColor>();
        private final List<DyeColor> fadeColors = new ArrayList<DyeColor>();
        private FireworkEffect.Type type;
        private boolean flicker;
        private boolean trail;
        private boolean active = false;

        private FireworkEffectData() {
            this(null, null, null, false, false);
        }

        private FireworkEffectData(FireworkEffect effect) {
            this(effect.getType(), FireworkEditor.translateToDyeColor(effect.getColors()), FireworkEditor.translateToDyeColor(effect.getFadeColors()), effect.hasFlicker(), effect.hasTrail());
            this.active = true;
        }

        private FireworkEffectData(FireworkEffect.Type type, List<DyeColor> colors, List<DyeColor> fadeColors, boolean flicker, boolean trail) {
            this.type = type != null ? type : FireworkEffect.Type.values()[(int)(Math.random() * (double)FireworkEffect.Type.values().length)];
            if (colors != null) {
                this.colors.addAll(colors);
            }
            if (this.colors.isEmpty()) {
                this.colors.add(DyeColor.values()[(int)(Math.random() * (double)DyeColor.values().length)]);
            }
            if (fadeColors != null) {
                this.fadeColors.addAll(fadeColors);
            }
            this.flicker = flicker;
            this.trail = trail;
        }

        public ItemStack getTypeItem() {
            ItemStack item;
            if (!this.active) {
                return null;
            }
            switch (this.type) {
                case BALL: {
                    try {
                        item = new ItemStack(Material.FIREWORK_STAR);
                    }
                    catch (Throwable t) {
                        item = new ItemStack(Material.valueOf((String)"FIREWORK_CHARGE"));
                    }
                    break;
                }
                case BALL_LARGE: {
                    try {
                        item = new ItemStack(Material.FIRE_CHARGE);
                    }
                    catch (Exception e) {
                        item = new ItemStack(Material.valueOf((String)"FIREBALL"));
                    }
                    break;
                }
                case BURST: {
                    item = new ItemStack(Material.FEATHER);
                    break;
                }
                case CREEPER: {
                    try {
                        item = new ItemStack(Material.CREEPER_HEAD);
                    }
                    catch (Throwable t) {
                        item = new ItemStack(Material.valueOf((String)"SKULL"), 1, 0, Byte.valueOf((byte)4));
                    }
                    break;
                }
                case STAR: {
                    item = new ItemStack(Material.GOLD_NUGGET);
                    break;
                }
                default: {
                    item = new ItemStack(Material.ARROW);
                }
            }
            ItemMeta meta = ItemUtils.getMeta(item);
            meta.addItemFlags(ItemFlag.values());
            FireworkEditor.this.loadLanguageDescription(meta, "gui.firework.buttons.type", "%type%", Aliases.FIREWORK_TYPE.getName(this.type));
            item.setItemMeta(meta);
            return item;
        }

        public ItemStack getColorsItem() {
            if (!this.active) {
                return null;
            }
            ItemStack item = Util.getDyeItemFromColor(!this.colors.isEmpty() ? DyeColor.LIGHT_BLUE : DyeColor.RED);
            ItemMeta meta = ItemUtils.getMeta(item);
            meta.addItemFlags(ItemFlag.values());
            ArrayList<String> colorNames = new ArrayList<String>();
            for (DyeColor color : this.colors) {
                colorNames.add(Aliases.COLOR.getName(color));
            }
            FireworkEditor.this.loadLanguageDescription(meta, "gui.firework.buttons.colors", "%colors%", String.join((CharSequence)"&b, &e", colorNames));
            item.setItemMeta(meta);
            item.setAmount(Math.max(Math.min(101, this.colors.size()), 1));
            return item;
        }

        public ItemStack getFadeColorsItem() {
            if (!this.active) {
                return null;
            }
            ItemStack item = Util.getDyeItemFromColor(DyeColor.BLUE);
            ItemMeta meta = ItemUtils.getMeta(item);
            meta.addItemFlags(ItemFlag.values());
            ArrayList<String> colorNames = new ArrayList<String>();
            for (DyeColor color : this.fadeColors) {
                colorNames.add(Aliases.COLOR.getName(color));
            }
            FireworkEditor.this.loadLanguageDescription(meta, "gui.firework.buttons.fadecolors", "%colors%", String.join((CharSequence)"&b, &e", colorNames));
            item.setItemMeta(meta);
            item.setAmount(Math.max(Math.min(101, this.fadeColors.size()), 1));
            return item;
        }

        public ItemStack getTrailFlickerItem() {
            if (!this.active) {
                return null;
            }
            ItemStack item = this.trail ? new ItemStack(Material.DIAMOND) : Util.getDyeItemFromColor(DyeColor.GRAY);
            ItemMeta meta = ItemUtils.getMeta(item);
            meta.addItemFlags(ItemFlag.values());
            if (this.flicker) {
                meta.addEnchant(Enchantment.LURE, 1, true);
            }
            String[] stringArray = new String[2];
            stringArray[0] = "%status%";
            stringArray[1] = FireworkEditor.this.getLanguageMessage("gui.firework.buttons.flags." + (this.trail ? (this.flicker ? "both" : "trail") : (this.flicker ? "flicker" : "none")), new String[0]);
            FireworkEditor.this.loadLanguageDescription(meta, "gui.firework.buttons.flags.info", stringArray);
            item.setItemMeta(meta);
            return item;
        }

        public ItemStack getPositionItem() {
            ItemStack item = Util.getDyeItemFromColor(this.active ? (this.colors.isEmpty() ? DyeColor.RED : DyeColor.LIME) : DyeColor.GRAY);
            ItemMeta meta = ItemUtils.getMeta(item);
            meta.addItemFlags(ItemFlag.values());
            FireworkEditor.this.loadLanguageDescription(meta, "gui.firework.buttons.position", "%middle_click%", FireworkEditor.this.getLanguageMessage("gui.middleclick." + (FireworkEditor.this.getTargetPlayer().getGameMode() == GameMode.CREATIVE ? "creative" : "other"), new String[0]));
            item.setItemMeta(meta);
            return item;
        }

        public FireworkEffect getEffect() {
            return FireworkEffect.builder().with(this.type).flicker(this.flicker).trail(this.trail).withFade((Iterable)FireworkEditor.translateToColor(this.fadeColors)).withColor((Iterable)FireworkEditor.translateToColor(this.colors)).build();
        }

        public void onClick(int line, InventoryClickEvent event) {
            switch (line) {
                case 1: {
                    this.type = event.isLeftClick() ? FireworkEffect.Type.values()[(this.type.ordinal() + 1) % FireworkEffect.Type.values().length] : FireworkEffect.Type.values()[(this.type.ordinal() - 1 + FireworkEffect.Type.values().length) % FireworkEffect.Type.values().length];
                    return;
                }
                case 2: {
                    FireworkEditor.this.getTargetPlayer().openInventory(new ColorListSelectorGui(FireworkEditor.this, this.colors).getInventory());
                    return;
                }
                case 3: {
                    FireworkEditor.this.getTargetPlayer().openInventory(new ColorListSelectorGui(FireworkEditor.this, this.fadeColors).getInventory());
                    return;
                }
                case 4: {
                    if (event.isLeftClick()) {
                        boolean bl = this.trail = !this.trail;
                    }
                    if (event.isRightClick()) {
                        this.flicker = !this.flicker;
                    }
                    return;
                }
            }
        }
    }
}

