/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.gui;

import emanondev.itemedit.APlugin;
import emanondev.itemedit.YMLConfig;
import emanondev.itemedit.utility.ItemUtils;
import java.util.Collections;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Gui
extends InventoryHolder {
    public void onClose(InventoryCloseEvent var1);

    public void onClick(InventoryClickEvent var1);

    public void onDrag(InventoryDragEvent var1);

    public void onOpen(InventoryOpenEvent var1);

    @NotNull
    public Inventory getInventory();

    public Player getTargetPlayer();

    @NotNull
    public APlugin getPlugin();

    default public String getLanguageMessage(@NotNull String fullPath, String ... holders) {
        return this.getPlugin().getLanguageConfig((CommandSender)this.getTargetPlayer()).loadMessage(fullPath, "", null, true, holders);
    }

    default public List<String> getLanguageMultiMessage(@NotNull String fullPath, String ... holders) {
        return this.getPlugin().getLanguageConfig((CommandSender)this.getTargetPlayer()).loadMultiMessage(fullPath, Collections.emptyList(), null, true, holders);
    }

    @Contract(value="null,_,_->null;!null,_,_->!null")
    default public ItemStack loadLanguageDescription(@Nullable ItemStack item, @NotNull String fullPath, String ... holders) {
        if (item == null) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        this.loadLanguageDescription(meta, fullPath, holders);
        item.setItemMeta(meta);
        return item;
    }

    @Contract(value="null,_,_->null;!null,_,_->!null")
    default public ItemMeta loadLanguageDescription(@Nullable ItemMeta meta, @NotNull String fullPath, String ... holders) {
        if (meta == null) {
            return null;
        }
        List<String> list = this.getPlugin().getLanguageConfig((CommandSender)this.getTargetPlayer()).loadMultiMessage(fullPath, null, this.getTargetPlayer(), true, holders);
        meta.setDisplayName(list == null || list.isEmpty() ? " " : list.get(0));
        if (list != null && !list.isEmpty()) {
            meta.setLore(list.subList(1, list.size()));
        }
        return meta;
    }

    @NotNull
    default public ItemStack getGuiItem(@NotNull String path, @NotNull Material defMaterial) {
        return this.getGuiItem(path, defMaterial, 0);
    }

    @NotNull
    default public ItemStack getGuiItem(@NotNull String path, @NotNull Material defMaterial, int defDurability) {
        YMLConfig config = this.getPlugin().getConfig("gui.yml");
        ItemStack item = new ItemStack(config.loadMaterial(path + ".material", defMaterial));
        ItemMeta meta = ItemUtils.getMeta(item);
        meta.addItemFlags(ItemFlag.values());
        if (config.getBoolean(path + ".glow", false)) {
            meta.addEnchant(Enchantment.LURE, 1, true);
        }
        item.setItemMeta(meta);
        int dur = config.loadInteger(path + ".durability", defDurability);
        if (dur > 0) {
            item.setDurability((short)dur);
        }
        return item;
    }

    @NotNull
    default public ItemStack getBackItem() {
        return this.loadLanguageDescription(this.getGuiItem("buttons.back", Material.BARRIER), "gui.back.description", new String[0]);
    }
}

