/*
 * Decompiled with CFR 0.152.
 */
package emanondev.itemedit.gui;

import emanondev.itemedit.ItemEdit;
import emanondev.itemedit.UtilsString;
import emanondev.itemedit.YMLConfig;
import emanondev.itemedit.command.ItemStorageCommand;
import emanondev.itemedit.gui.PagedGui;
import emanondev.itemedit.storage.PlayerStorage;
import emanondev.itemedit.utility.InventoryUtils;
import emanondev.itemedit.utility.ItemUtils;
import java.util.ArrayList;
import java.util.Collections;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class ShowPlayerItemsGui
implements PagedGui {
    private static final YMLConfig GUI_CONFIG = ItemEdit.get().getConfig();
    private final Inventory inventory;
    private final Player target;
    private final int page;
    private int rows;
    private ArrayList<String> ids;
    private boolean showItems = true;

    public ShowPlayerItemsGui(Player player, int page) {
        if (player == null) {
            throw new NullPointerException();
        }
        if (page < 1) {
            throw new NullPointerException();
        }
        this.target = player;
        this.rows = GUI_CONFIG.loadInteger("gui.playeritems.rows", 6);
        if (this.rows < 1 || this.rows > 5) {
            this.rows = Math.min(5, Math.max(1, this.rows));
        }
        PlayerStorage storage = ItemEdit.get().getPlayerStorage();
        ArrayList<String> list = new ArrayList<String>(storage.getIds((OfflinePlayer)this.target));
        Collections.sort(list);
        int maxPages = (list.size() - 1) / (this.rows * 9) + 1;
        if (page > maxPages) {
            page = maxPages;
        }
        this.page = page;
        String title = this.getLanguageMessage("gui.playeritems.title", "%player_name%", this.target.getName(), "%page%", String.valueOf(page));
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)((this.rows + 1) * 9), (String)title);
        this.updateInventory();
        this.inventory.setItem(this.rows * 9 + 4, this.getPageInfoItem());
        if (page > 1) {
            this.inventory.setItem(this.rows * 9 + 1, this.getPreviousPageItem());
        }
        if (page < maxPages) {
            this.inventory.setItem(this.rows * 9 + 7, this.getNextPageItem());
        }
    }

    public void updateInventory() {
        PlayerStorage storage = ItemEdit.get().getPlayerStorage();
        ArrayList<String> list = new ArrayList<String>(storage.getIds((OfflinePlayer)this.target));
        this.ids = list;
        Collections.sort(list);
        for (int i = 0; i < this.rows * 9; ++i) {
            int slot = this.rows * 9 * (this.page - 1) + i;
            if (slot >= list.size()) {
                this.inventory.setItem(i, null);
                continue;
            }
            ItemStack item = storage.getItem((OfflinePlayer)this.target, list.get(slot));
            if (this.showItems) {
                this.inventory.setItem(i, item);
                continue;
            }
            ItemStack display = item.clone();
            ItemMeta meta = ItemUtils.getMeta(display);
            meta.addItemFlags(ItemFlag.values());
            meta.setDisplayName(UtilsString.fix("&9ID: &e" + list.get(slot), null, true, new String[0]));
            display.setItemMeta(meta);
            this.inventory.setItem(i, display);
        }
    }

    private ItemStack getPageInfoItem() {
        return this.loadLanguageDescription(this.getGuiItem("gui.playeritems.page-info", Material.NAME_TAG), "gui.playeritems.page-info.description", "%page%", String.valueOf(this.page));
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public void onClose(InventoryCloseEvent event) {
    }

    @Override
    public void onClick(InventoryClickEvent event) {
        if (!event.getWhoClicked().equals((Object)this.target)) {
            return;
        }
        if (!this.inventory.equals((Object)event.getClickedInventory())) {
            return;
        }
        if (ItemUtils.isAirOrNull(event.getCurrentItem())) {
            return;
        }
        if (event.getSlot() > this.inventory.getSize() - 9) {
            if (event.getSlot() == this.inventory.getSize() - 2) {
                this.target.openInventory(new ShowPlayerItemsGui(this.target, this.page + 1).getInventory());
            } else if (event.getSlot() == this.inventory.getSize() - 5) {
                this.showItems = !this.showItems;
                this.updateInventory();
            } else {
                this.target.openInventory(new ShowPlayerItemsGui(this.target, this.page - 1).getInventory());
            }
            return;
        }
        int slot = this.rows * 9 * (this.page - 1) + event.getSlot();
        String id = this.ids.get(slot);
        PlayerStorage storage = ItemEdit.get().getPlayerStorage();
        ItemStack item = storage.getItem((OfflinePlayer)this.target, id);
        if (ItemUtils.isAirOrNull(item)) {
            this.updateInventory();
            return;
        }
        switch (event.getClick()) {
            case LEFT: {
                InventoryUtils.giveAmount((HumanEntity)this.target, item, 1, InventoryUtils.ExcessMode.DELETE_EXCESS);
                return;
            }
            case SHIFT_LEFT: {
                InventoryUtils.giveAmount((HumanEntity)this.target, item, 64, InventoryUtils.ExcessMode.DELETE_EXCESS);
                return;
            }
            case SHIFT_RIGHT: {
                if (!event.getWhoClicked().hasPermission("itemedit.itemstorage.delete")) {
                    ItemStorageCommand.get().sendPermissionLackMessage("itemedit.itemstorage.delete", (CommandSender)event.getWhoClicked());
                    return;
                }
                storage.remove((OfflinePlayer)this.target, id);
                this.updateInventory();
                return;
            }
        }
    }

    @Override
    public void onDrag(InventoryDragEvent event) {
    }

    @Override
    public void onOpen(InventoryOpenEvent event) {
    }

    @Override
    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    @Override
    public Player getTargetPlayer() {
        return this.target;
    }

    @Override
    @NotNull
    public ItemEdit getPlugin() {
        return ItemEdit.get();
    }
}

